/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.crap4j.reader.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;

public class NumericalParser {
    private final DecimalFormatSymbols formatSymbols;

    public NumericalParser() {
        this(Locale.getDefault());
    }

    public NumericalParser(Locale locale) {
        this.formatSymbols = DecimalFormatSymbols.getInstance(locale);
    }

    public double parseDouble(String string) {
        DecimalFormat decimalFormat = new DecimalFormat("0.00", this.formatSymbols);
        try {
            return decimalFormat.parse(string).doubleValue();
        }
        catch (ParseException parseException) {
            throw new NumberFormatException(parseException.getMessage() + " for " + string);
        }
    }

    public int parseInt(String string) {
        return this.parseInteger(string);
    }

    public int parseInteger(String string) {
        return Integer.parseInt(string);
    }
}

