/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.crap4j.reader;

import com.schneide.crap4j.crap.GenericCrapData;
import com.schneide.crap4j.crap.MethodCrapManager;
import com.schneide.crap4j.reader.ClassManager;
import com.schneide.crap4j.reader.MethodManager;
import com.schneide.crap4j.reader.PackageManager;
import com.schneide.crap4j.reader.model.IClass;
import com.schneide.crap4j.reader.model.ICrap4JReport;
import com.schneide.crap4j.reader.model.IMethod;
import com.schneide.crap4j.reader.model.IMethodCrapData;
import com.schneide.crap4j.reader.model.IPackage;
import com.schneide.crap4j.reader.util.NumericalParser;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class ReportReader {
    private final Reader reportData;
    private final MethodManager methodManager;
    private final PackageManager packageManager;
    private final ClassManager classManager;
    private final MethodCrapManager methodCrapManager;
    private ParsedCrap4JData parsedData;

    public ReportReader(Reader reader) {
        this.reportData = reader;
        this.packageManager = new PackageManager();
        this.classManager = new ClassManager(this.packageManager);
        this.methodManager = new MethodManager(this.classManager);
        this.methodCrapManager = new MethodCrapManager();
        this.parsedData = null;
    }

    public synchronized ICrap4JReport parseData() throws IOException {
        if (null != this.parsedData) {
            return this.parsedData;
        }
        try {
            SAXBuilder sAXBuilder = new SAXBuilder(false);
            Document document = sAXBuilder.build(this.reportData);
            Element element = document.getRootElement();
            Element element2 = element.getChild("methods");
            List list = element2.getChildren("method");
            for (Object e : list) {
                IMethodCrapData iMethodCrapData = this.parseMethodCrap((Element)e);
                this.methodCrapManager.addMethodCrapData(iMethodCrapData);
            }
            String string = element.getChild("stats").getChild("crapThreshold").getTextTrim();
            this.parsedData = new ParsedCrap4JData(Integer.parseInt(string));
            return this.parsedData;
        }
        catch (JDOMException jDOMException) {
            throw new IOException(jDOMException);
        }
    }

    private IMethodCrapData parseMethodCrap(Element element) {
        IMethod iMethod = this.parseMethod(element);
        NumericalParser numericalParser = new NumericalParser();
        double d = numericalParser.parseDouble(this.readTextualContent(element, "crap"));
        int n = numericalParser.parseInt(this.readTextualContent(element, "crapLoad"));
        double d2 = numericalParser.parseDouble(this.readTextualContent(element, "coverage"));
        double d3 = numericalParser.parseDouble(this.readTextualContent(element, "complexity"));
        return new MethodCrapData(iMethod, d, n, d2, d3);
    }

    private String readTextualContent(Element element, String string) {
        return element.getChildText(string).trim();
    }

    private IMethod parseMethod(Element element) {
        IPackage iPackage = this.packageManager.getPackageFor(this.readTextualContent(element, "package"));
        IClass iClass = this.classManager.getClassFor(iPackage, this.readTextualContent(element, "className"));
        IMethod iMethod = this.methodManager.getMethodFor(iClass, this.readTextualContent(element, "methodName"), this.readTextualContent(element, "methodSignature"), this.readTextualContent(element, "fullMethod"));
        return iMethod;
    }

    private class MethodCrapData
    extends GenericCrapData<IMethod>
    implements IMethodCrapData {
        public MethodCrapData(IMethod iMethod, double d, int n, double d2, double d3) {
            super(iMethod, 0, 1, d, n, d2, d3);
        }

        @Override
        public int getCrappyMethods() {
            if (this.isCrappy()) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean isCrappy() {
            return this.getCrapLoad() > 0;
        }

        @Override
        public double getCrapPercentage() {
            if (this.isCrappy()) {
                return 1.0;
            }
            return 0.0;
        }
    }

    private class ParsedCrap4JData
    implements ICrap4JReport {
        private final int crapThreshold;

        public ParsedCrap4JData(int n) {
            this.crapThreshold = n;
        }

        @Override
        public int getCrapThreshold() {
            return this.crapThreshold;
        }

        @Override
        public ClassManager getClassManager() {
            return ReportReader.this.classManager;
        }

        @Override
        public MethodCrapManager getMethodCrapManager() {
            return ReportReader.this.methodCrapManager;
        }

        @Override
        public MethodManager getMethodManager() {
            return ReportReader.this.methodManager;
        }

        @Override
        public PackageManager getPackageManager() {
            return ReportReader.this.packageManager;
        }
    }
}

