/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.crap4j.reader;

import com.schneide.crap4j.reader.model.IClass;
import com.schneide.crap4j.reader.model.IPackage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PackageManager {
    private final Map<String, ManagedPackage> packages = new HashMap<String, ManagedPackage>();

    public IPackage getPackageFor(String string) {
        return this.getManagedPackageFor(string);
    }

    public int getPackageCount() {
        return this.packages.size();
    }

    public IPackage[] getAllPackages() {
        return this.packages.values().toArray(new IPackage[this.packages.size()]);
    }

    private ManagedPackage getManagedPackageFor(String string) {
        if (!this.packages.containsKey(string)) {
            this.packages.put(string, new ManagedPackage(string));
        }
        return this.packages.get(string);
    }

    public void addToPackage(String string, IClass iClass) {
        ManagedPackage managedPackage = this.getManagedPackageFor(string);
        managedPackage.addClass(iClass);
    }

    private class ManagedPackage
    implements IPackage {
        private final String name;
        private final List<IClass> classes;
        private final Set<String> classNames;

        public ManagedPackage(String string) {
            this.name = string;
            this.classes = new ArrayList<IClass>();
            this.classNames = new HashSet<String>();
        }

        public void addClass(IClass iClass) {
            if (this.classNames.contains(iClass.getName())) {
                return;
            }
            this.classes.add(iClass);
            this.classNames.add(iClass.getName());
        }

        @Override
        public String getFullName() {
            return this.getName();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public IClass[] getClasses() {
            return this.classes.toArray(new IClass[this.classes.size()]);
        }

        public String toString() {
            return this.getName();
        }
    }
}

