/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.crap4j.reader;

import com.schneide.crap4j.reader.ClassManager;
import com.schneide.crap4j.reader.model.IClass;
import com.schneide.crap4j.reader.model.IMethod;
import java.util.HashMap;
import java.util.Map;

public class MethodManager {
    private final ClassManager classManager;
    private final Map<String, ManagedMethod> methods;

    public MethodManager(ClassManager classManager) {
        this.classManager = classManager;
        this.methods = new HashMap<String, ManagedMethod>();
    }

    public int getMethodCount() {
        return this.methods.size();
    }

    public IMethod[] getAllMethods() {
        return this.methods.values().toArray(new IMethod[this.methods.size()]);
    }

    public IMethod getMethodFor(IClass iClass, String string, String string2, String string3) {
        String string4 = this.buildFullMethodName(iClass, string3);
        if (!this.methods.containsKey(string4)) {
            ManagedMethod managedMethod = new ManagedMethod(iClass, string, string2, string3);
            this.methods.put(string4, managedMethod);
            this.classManager.addToClass(iClass, managedMethod);
        }
        return this.methods.get(string4);
    }

    private String buildFullMethodName(IClass iClass, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(iClass.getPackage().getName());
        stringBuilder.append("#");
        stringBuilder.append(iClass.getName());
        stringBuilder.append("::");
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    private class ManagedMethod
    implements IMethod {
        private final IClass clazz;
        private final String name;
        private final String signature;
        private final String fullMethod;

        public ManagedMethod(IClass iClass, String string, String string2, String string3) {
            this.clazz = iClass;
            this.name = string;
            this.signature = string2;
            this.fullMethod = string3;
        }

        @Override
        public IClass getClazz() {
            return this.clazz;
        }

        @Override
        public String getFullMethod() {
            return this.fullMethod;
        }

        @Override
        public String getFullName() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getClazz().getFullName());
            stringBuilder.append(".");
            stringBuilder.append(this.getName());
            stringBuilder.append("(...)");
            return stringBuilder.toString();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getSignature() {
            return this.signature;
        }

        public String toString() {
            return this.getName();
        }
    }
}

