/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.crap4j.reader;

import com.schneide.crap4j.reader.PackageManager;
import com.schneide.crap4j.reader.model.IClass;
import com.schneide.crap4j.reader.model.IMethod;
import com.schneide.crap4j.reader.model.IPackage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClassManager {
    private final PackageManager packageManager;
    private final Map<String, ManagedClass> classes;

    public ClassManager(PackageManager packageManager) {
        this.packageManager = packageManager;
        this.classes = new HashMap<String, ManagedClass>();
    }

    public IClass getClassFor(IPackage iPackage, String string) {
        return this.getManagedClassFor(iPackage, string);
    }

    public int getClassCount() {
        return this.classes.size();
    }

    public IClass[] getAllClasses() {
        return this.classes.values().toArray(new IClass[this.classes.size()]);
    }

    private ManagedClass getManagedClassFor(IPackage iPackage, String string) {
        String string2 = this.buildFullClassName(iPackage, string);
        if (!this.classes.containsKey(string2)) {
            ManagedClass managedClass = new ManagedClass(iPackage, string);
            this.classes.put(string2, managedClass);
            this.packageManager.addToPackage(iPackage.getName(), managedClass);
        }
        return this.classes.get(string2);
    }

    public void addToClass(IClass iClass, IMethod iMethod) {
        ManagedClass managedClass = this.getManagedClassFor(iClass.getPackage(), iClass.getName());
        managedClass.addMethod(iMethod);
    }

    private String buildFullClassName(IPackage iPackage, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(iPackage.getName());
        stringBuilder.append("#");
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    private class ManagedClass
    implements IClass {
        private final IPackage classPackage;
        private final String name;
        private final List<IMethod> methods;
        private final Set<String> fullMethodNames;

        public ManagedClass(IPackage iPackage, String string) {
            this.classPackage = iPackage;
            this.name = string;
            this.methods = new ArrayList<IMethod>();
            this.fullMethodNames = new HashSet<String>();
        }

        public void addMethod(IMethod iMethod) {
            if (this.fullMethodNames.contains(iMethod.getFullMethod())) {
                return;
            }
            this.methods.add(iMethod);
            this.fullMethodNames.add(iMethod.getFullMethod());
        }

        @Override
        public IMethod[] getMethods() {
            return this.methods.toArray(new IMethod[this.methods.size()]);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public IPackage getPackage() {
            return this.classPackage;
        }

        public String toString() {
            return this.getName();
        }

        @Override
        public String getFullName() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getPackage().getFullName());
            stringBuilder.append(".");
            stringBuilder.append(this.getName());
            return stringBuilder.toString();
        }
    }
}

