/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.crap4j.crap;

import com.schneide.crap4j.reader.model.IContextedCrapData;
import com.schneide.crap4j.reader.model.ICrapContext;
import com.schneide.crap4j.reader.model.ICrapData;

public class GenericCrapData<O extends ICrapContext>
implements IContextedCrapData<O> {
    private final O context;
    private final int crappyMethods;
    private final int totalMethods;
    private final double crap;
    private final int crapLoad;
    private final double coverage;
    private final double complexity;

    public GenericCrapData(O o, ICrapData iCrapData) {
        this(o, iCrapData.getCrappyMethods(), iCrapData.getTotalMethods(), iCrapData.getCrap(), iCrapData.getCrapLoad(), iCrapData.getCoverage(), iCrapData.getComplexity());
    }

    public GenericCrapData(O o, int n, int n2, double d, int n3, double d2, double d3) {
        this.context = o;
        this.crappyMethods = n;
        this.totalMethods = n2;
        this.crap = d;
        this.crapLoad = n3;
        this.coverage = d2;
        this.complexity = d3;
    }

    @Override
    public O getContext() {
        return this.context;
    }

    @Override
    public double getCoverage() {
        return this.coverage;
    }

    @Override
    public double getCrap() {
        return this.crap;
    }

    @Override
    public int getCrapLoad() {
        return this.crapLoad;
    }

    @Override
    public int getCrappyMethods() {
        return this.crappyMethods;
    }

    @Override
    public int getTotalMethods() {
        return this.totalMethods;
    }

    @Override
    public double getCrapPercentage() {
        return (double)this.getCrappyMethods() / (double)this.getTotalMethods();
    }

    @Override
    public double getComplexity() {
        return this.complexity;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.valueOf(this.getContext()));
        stringBuilder.append(": crapPercentage=");
        stringBuilder.append(this.getCrapPercentage());
        stringBuilder.append(", crap=");
        stringBuilder.append(this.getCrap());
        stringBuilder.append(", crapLoad=");
        stringBuilder.append(this.getCrapLoad());
        stringBuilder.append(", coverage=");
        stringBuilder.append(this.getCoverage());
        stringBuilder.append(", complexity=");
        stringBuilder.append(this.getComplexity());
        return stringBuilder.toString();
    }
}

