/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.crap4j.crap;

import com.schneide.crap4j.reader.model.ICrapData;
import com.schneide.crap4j.reader.model.IMethodCrapData;

public class CrapCalculator {
    public ICrapData calculateFor(IMethodCrapData ... iMethodCrapDataArray) {
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (IMethodCrapData iMethodCrapData : iMethodCrapDataArray) {
            d += iMethodCrapData.getCrap();
            d2 += iMethodCrapData.getCoverage();
            d3 += iMethodCrapData.getComplexity();
            if (!iMethodCrapData.isCrappy()) continue;
            ++n;
            n2 += iMethodCrapData.getCrapLoad();
        }
        double d4 = d2 / (double)iMethodCrapDataArray.length;
        double d5 = d3 / (double)iMethodCrapDataArray.length;
        return new CalculatedCrapData(n, iMethodCrapDataArray.length, d, n2, d4, d5);
    }

    private static class CalculatedCrapData
    implements ICrapData {
        private final double crap;
        private final int crapLoad;
        private final double coverage;
        private final double complexity;
        private final int crappyMethods;
        private final int totalMethods;

        public CalculatedCrapData(int n, int n2, double d, int n3, double d2, double d3) {
            this.crappyMethods = n;
            this.totalMethods = n2;
            this.crap = d;
            this.crapLoad = n3;
            this.coverage = d2;
            this.complexity = d3;
        }

        @Override
        public double getCoverage() {
            return this.coverage;
        }

        @Override
        public double getCrap() {
            return this.crap;
        }

        @Override
        public int getCrapLoad() {
            return this.crapLoad;
        }

        @Override
        public int getCrappyMethods() {
            return this.crappyMethods;
        }

        @Override
        public int getTotalMethods() {
            return this.totalMethods;
        }

        @Override
        public double getCrapPercentage() {
            return (double)this.getCrappyMethods() / (double)this.getTotalMethods();
        }

        @Override
        public double getComplexity() {
            return this.complexity;
        }
    }
}

