/*
 * Decompiled with CFR 0.152.
 */
package org.crap4j.gauge;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.crap4j.util.FormatUtil;

public class CrapImageGenerator {
    private static final String NEEDLE_GIF = "needle.gif";
    private static final String BACKGROUND_GIF = "meter_background.gif";
    private Image gauge;
    private Image needle;
    private float crapScore;
    private String dir;
    private String crapGaugeFilename = "CRI.png";
    private float crapPercentWarningThreshold;
    private float crapPercentCriticalThreshold;

    public CrapImageGenerator(float crapNumber, String dir, String filename, float crapPercentWarningThreshold, float crapPercentCriticalThreshold) {
        this.crapScore = crapNumber;
        this.dir = dir;
        this.crapPercentWarningThreshold = crapPercentWarningThreshold;
        this.crapPercentCriticalThreshold = crapPercentCriticalThreshold;
        if (this.isValidFilename(filename)) {
            this.crapGaugeFilename = filename;
        }
        this.gauge = new ImageIcon(CrapImageGenerator.class.getResource(BACKGROUND_GIF)).getImage();
        this.needle = new ImageIcon(CrapImageGenerator.class.getResource(NEEDLE_GIF)).getImage();
    }

    private boolean isValidFilename(String filename) {
        return !CrapImageGenerator.isEmpty(filename);
    }

    public void makeGaugeAndWriteToFile() {
        this.writeImageToFile(this.makeGauge());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeImageToFile(BufferedImage bi) {
        File file = new File(this.dir, this.crapGaugeFilename);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            ImageIO.write((RenderedImage)bi, "png", out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private BufferedImage makeGauge() {
        int w = this.getGaugeWidth();
        int h = this.getGaugeHeight();
        BufferedImage bufferedImage = new BufferedImage(w, h, 1);
        Graphics2D imageGraphics = bufferedImage.createGraphics();
        imageGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        imageGraphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        imageGraphics.setBackground(Color.white);
        imageGraphics.clearRect(0, 0, w, h);
        imageGraphics.drawImage(this.gauge, 0, 0, w, h, null);
        this.drawCrapOnGauge(imageGraphics, w, h, this.crapScore);
        this.drawCrapScoreOnGauge(imageGraphics, w, h, this.crapScore);
        this.drawNeedle(w, h, imageGraphics, this.crapScore / 10.0f);
        return bufferedImage;
    }

    private void drawNeedle(int w, int h, Graphics2D big, float crapScore2) {
        int translateWidth = w / 2;
        int translateHeight = h / 2;
        big.translate(translateWidth, translateHeight);
        big.rotate(this.convertDegrees(crapScore2));
        big.translate(-translateWidth, -translateHeight);
        int needleW = this.needle.getWidth(null);
        int needleH = this.needle.getHeight(null);
        big.drawImage(this.needle, 0, 0, needleW, needleH, null);
    }

    private void drawCrapScoreOnGauge(Graphics2D big, int width, int height, float crapScore2) {
        String crapScoreString = FormatUtil.getNumberFormatter().format(crapScore2) + "%";
        Font currFont = big.getFont();
        Font bigger = currFont.deriveFont(0, 14.0f);
        big.setFont(bigger);
        FontMetrics fm = big.getFontMetrics();
        Rectangle2D rect = fm.getStringBounds(crapScoreString, big);
        double startX = (double)(width / 2) - (rect.getWidth() + 4.0) / 2.0;
        double startY = (double)(height - 35) - rect.getHeight();
        Color color = this.getBackgroundColor(crapScore2);
        big.setColor(color);
        big.fillRect((int)startX, (int)startY, (int)rect.getWidth() + 6, (int)rect.getHeight() + 5);
        big.setColor(Color.BLACK);
        big.drawRect((int)startX - 1, (int)startY - 1, (int)rect.getWidth() + 6 + 1, (int)rect.getHeight() + 6);
        big.setColor(Color.DARK_GRAY);
        big.drawRect((int)startX, (int)startY, (int)rect.getWidth() + 6, (int)rect.getHeight() + 4);
        big.setColor(Color.BLACK);
        big.drawRect((int)startX - 1, (int)startY - 1, (int)rect.getWidth() + 6 + 2, (int)rect.getHeight() + 6);
        big.setColor(Color.BLACK);
        big.drawString(crapScoreString, (int)((double)(width / 2) - (rect.getWidth() - 4.0) / 2.0), height - 36);
    }

    private void drawCrapOnGauge(Graphics2D big, int width, int height, float crapScore2) {
        Font currFont = big.getFont();
        Font bigger = currFont.deriveFont(2, 14.0f);
        big.setFont(bigger);
        FontMetrics fm = big.getFontMetrics();
        String crap = "C.R.A.P.";
        Rectangle2D rect = fm.getStringBounds(crap, big);
        big.setColor(Color.BLACK);
        int heightOfLogo = height - (int)((double)height * 0.65);
        if (this.isInUpperHalfOfGauge(crapScore2)) {
            heightOfLogo = height - (int)((double)height * 0.3);
        }
        big.drawString(crap, (float)((double)(width / 2) - rect.getWidth() / 2.0), (float)heightOfLogo);
    }

    private boolean isInUpperHalfOfGauge(float crapScore2) {
        boolean upperHalfOfGauge = (double)crapScore2 > 3.5 && (double)crapScore2 < 6.5;
        return upperHalfOfGauge;
    }

    private Color getBackgroundColor(float crapScore2) {
        if ((double)this.crapScore / 100.0 >= (double)this.crapPercentCriticalThreshold) {
            return Color.red;
        }
        if ((double)this.crapScore / 100.0 >= (double)this.crapPercentWarningThreshold) {
            return Color.ORANGE;
        }
        return Color.GREEN;
    }

    private double convertDegrees(float crapScore2) {
        double rank = Math.min(10.0, (double)crapScore2);
        double degrees = 216.0 + 29.0 * rank;
        return Math.PI * degrees / 180.0;
    }

    private int getGaugeHeight() {
        return this.gauge.getWidth(null);
    }

    private int getGaugeWidth() {
        return this.gauge.getHeight(null);
    }

    private static void showUsage() {
        System.out.println("Usage: crapScore destination_directory");
    }

    public static void main(String[] argv) {
        CrapImageGenerator.validateArgs(argv);
        String crapScore = CrapImageGenerator.validateCrapScore(argv[0]);
        String dir = CrapImageGenerator.validateOutputDirectory(argv[1]);
        CrapImageGenerator demo = new CrapImageGenerator(Float.parseFloat(crapScore), dir, null, 5.0f, 15.0f);
        BufferedImage bi = demo.makeGauge();
        demo.writeImageToFile(bi);
        if (!CrapImageGenerator.isRunningHeadless()) {
            CrapImageGenerator.displayOnScreen(bi);
        }
    }

    private static String validateOutputDirectory(String dir) {
        if (CrapImageGenerator.isEmpty(dir)) {
            CrapImageGenerator.showUsage();
            System.exit(0);
        }
        return dir;
    }

    private static String validateCrapScore(String crapScore) {
        if (CrapImageGenerator.isEmpty(crapScore)) {
            CrapImageGenerator.showUsage();
        }
        return crapScore;
    }

    private static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    private static void validateArgs(String[] argv) {
        if (argv == null || argv.length == 0) {
            CrapImageGenerator.showUsage();
            System.exit(0);
        }
    }

    private static boolean isRunningHeadless() {
        String headlessProperty = System.getProperty("java.awt.headless");
        return headlessProperty != null && headlessProperty.toUpperCase().equals("true");
    }

    private static void displayOnScreen(BufferedImage bi) {
        JFrame frame = new JFrame();
        JPanel gaugePanel = new JPanel();
        gaugePanel.add(new JLabel(new ImageIcon(bi)));
        frame.getContentPane().add(gaugePanel);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.pack();
        frame.setVisible(true);
    }
}

