/*
 * Decompiled with CFR 0.152.
 */
package org.crap4j.anttask;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.crap4j.CrapProject;
import org.crap4j.Main;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Crap4jAntTask
extends Task {
    private String crap4jHome;
    private boolean debug;
    private boolean dontTest;
    private boolean downloadAverages = true;
    private String server;
    private File projectDir;
    private File outputDir;
    private Path libClasspath;
    private Path classDirs;
    private Path srcDirs;
    private Path testClassDirs;
    private Project antProject;

    public void CrapjAntTask(Project p) {
        this.antProject = p;
    }

    public Path createClassDirs() {
        if (this.classDirs == null) {
            this.classDirs = new Path(this.antProject);
        }
        return this.classDirs.createPath();
    }

    public Path createSrcDirs() {
        if (this.srcDirs == null) {
            this.srcDirs = new Path(this.antProject);
        }
        return this.srcDirs.createPath();
    }

    public Path createTestClassDirs() {
        if (this.testClassDirs == null) {
            this.testClassDirs = new Path(this.antProject);
        }
        return this.testClassDirs.createPath();
    }

    public Path createLibClasspath() {
        if (this.libClasspath == null) {
            this.libClasspath = new Path(this.antProject);
        }
        return this.libClasspath.createPath();
    }

    public String getServer() {
        this.server = "http://www.crap4j.org/benchmark/";
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void execute() throws BuildException {
        if (this.isDebug()) {
            System.out.println("projectDir is " + this.getProjectDir());
            System.out.println("outputDir is " + this.getOutputDir());
            System.out.println("srcDir is " + this.getSrcDirs());
            System.out.println("classDirs is " + this.stringOf(this.getClassDirs()));
            System.out.println("testClassDirs is " + this.stringOf(this.getTestClassDirs()));
            System.out.println("libClasspath is " + this.stringOf(this.getLibClasspath()));
            System.out.println("server is " + this.getServer());
            System.out.println("downloadAverages is " + this.isDownloadAverages());
            System.out.println("debug is " + this.isDebug());
            System.out.println("dontTest is " + this.isDontTest());
        }
        CrapProject p = this.createCrapProject();
        try {
            Main.createMain().run(p, this.isDebug(), this.isDontTest(), this.isDownloadAverages(), this.getServer());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String stringOf(Path classDirs2) {
        StringBuilder b = new StringBuilder();
        for (String s : classDirs2.list()) {
            b.append(s);
            b.append(", ");
        }
        return b.toString();
    }

    private CrapProject createCrapProject() {
        CrapProject p = new CrapProject(this.getProjectDir().getAbsolutePath(), this.makeListFrom(this.getLibClasspath()), this.makeListFrom(this.getTestClassDirs()), this.makeListFrom(this.getClassDirs()), this.makeListFrom(this.getSrcDirs()), this.getOutputDir() != null ? this.getOutputDir().getAbsolutePath() : null);
        return p;
    }

    private List<String> makeListFrom(Path path) {
        ArrayList<String> list = new ArrayList<String>();
        for (String string : path.list()) {
            list.add(string);
        }
        return list;
    }

    public String getCrap4jHome() {
        return this.crap4jHome;
    }

    public void setCrap4jHome(String crap4jHome) {
        this.crap4jHome = crap4jHome;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isDontTest() {
        return this.dontTest;
    }

    public void setDontTest(boolean dontTest) {
        this.dontTest = dontTest;
    }

    public Path getLibClasspath() {
        return this.libClasspath;
    }

    public void setLibClasspath(Path path) {
        this.libClasspath = path;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    public void setProjectDir(File projectDir) {
        this.projectDir = projectDir;
    }

    public Path getSrcDirs() {
        return this.srcDirs;
    }

    public void setSrcDirs(Path path) {
        this.srcDirs = path;
    }

    public Path getTestClassDirs() {
        return this.testClassDirs;
    }

    public void setTestClassDirs(Path path) {
        this.testClassDirs = path;
    }

    public Path getClassDirs() {
        return this.classDirs;
    }

    public void setClassDirs(Path path) {
        this.classDirs = path;
    }

    public boolean isDownloadAverages() {
        return this.downloadAverages;
    }

    public void setDownloadAverages(boolean downloadAverages) {
        this.downloadAverages = downloadAverages;
    }
}

