/*
 * Decompiled with CFR 0.152.
 */
package org.crap4j;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.crap4j.Crap;
import org.crap4j.CrapProject;
import org.crap4j.MethodComplexity;
import org.crap4j.MethodCoverage;
import org.crap4j.MethodInfo;
import org.crap4j.util.FormatUtil;
import org.crap4j.util.MyStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodCrap
extends MethodInfo
implements Crap {
    private float coverage;
    private MethodComplexity complexity;
    private float crap;
    private static float crapThreshold;

    public MethodCrap(String methodSignature, float coverage, MethodComplexity complexity2) {
        this.validateParams(coverage, complexity2);
        this.matchingMethodSignature = methodSignature;
        this.coverage = coverage;
        this.complexity = complexity2;
        this.crap = this.computeCrap();
    }

    protected float computeCrap() {
        return (float)((double)this.getComplexity() * ((double)this.getComplexity() * Math.pow(1.0 - (double)this.getCoverage(), 3.0)) + (double)this.getComplexity());
    }

    @Override
    public float getCrap() {
        return this.crap;
    }

    @Override
    public int getCrapLoad(float crapThreshold) {
        int crapLoad = 0;
        if (this.getCrap() >= crapThreshold) {
            int complexity = this.getComplexity();
            float coverage = this.getCoverage();
            crapLoad = (int)((double)crapLoad + (double)complexity * (1.0 - (double)coverage));
            crapLoad = (int)((float)crapLoad + (float)complexity / crapThreshold);
        }
        return crapLoad;
    }

    public int getComplexity() {
        return this.complexity.getComplexity();
    }

    @Override
    public float getCoverage() {
        return this.coverage;
    }

    private void validateParams(float coverage, MethodComplexity complexity2) {
        if ((double)coverage < 0.0 || (double)coverage > 1.0 || complexity2 == null || complexity2.getComplexity() < 0) {
            throw new IllegalArgumentException("coverage is 0 or greater and complexity is 0 (really 1) or greater");
        }
    }

    public static List<? extends Crap> combine(List<MethodCoverage> covs, List<MethodComplexity> complexities) {
        ArrayList<MethodCrap> methodCraps = new ArrayList<MethodCrap>();
        Collections.sort(covs);
        Collections.sort(complexities);
        for (MethodComplexity complexity : complexities) {
            MethodCoverage cov = (MethodCoverage)MethodCrap.findSameMethod(covs, complexity);
            float receivedCoverage = 0.0f;
            if (cov != null) {
                receivedCoverage = cov.getCoverage();
            }
            methodCraps.add(new MethodCrap(complexity.getMatchingMethodSignature(), receivedCoverage, complexity));
        }
        return methodCraps;
    }

    private static MethodInfo findSameMethod(List<? extends MethodInfo> methods, MethodInfo method) {
        String methodSignature = method.getMatchingMethodSignature();
        MethodInfo match = null;
        for (MethodInfo methodInfo : methods) {
            if (!methodInfo.matchingMethodSignature.equals(methodSignature)) continue;
            match = methodInfo;
        }
        if (match != null) {
            methods.remove(match);
        }
        return match;
    }

    public String toString() {
        NumberFormat nf = FormatUtil.getNumberFormatter();
        return this.prettyMethodSignature() + " : " + nf.format(this.crap) + " : " + nf.format(this.complexity.getComplexity()) + " : " + nf.format(this.coverage);
    }

    @Override
    public void toXml(MyStringBuilder s) {
        NumberFormat nf = FormatUtil.getNumberFormatter();
        s.start("<method>");
        CrapProject.itemToXml(s, "package", this.complexity.getPackageName());
        CrapProject.itemToXml(s, "className", this.complexity.getClassName());
        CrapProject.itemToXml(s, "methodName", this.escapeXml(this.complexity.getMethodName()));
        CrapProject.itemToXml(s, "methodSignature", this.escapeXml(this.complexity.getSigOrDescriptor()));
        CrapProject.itemToXml(s, "fullMethod", this.escapeXml(this.complexity.prettyMethodSignature()));
        CrapProject.itemToXml(s, "crap", nf.format(this.crap));
        CrapProject.itemToXml(s, "complexity", Integer.toString(this.complexity.getComplexity()));
        CrapProject.itemToXml(s, "coverage", nf.format(this.coverage * 100.0f));
        CrapProject.itemToXml(s, "crapLoad", Integer.toString(this.getCrapLoad(crapThreshold)));
        s.end("</method>");
    }

    public static void setCrapLoadThreshold(float crapThreshold2) {
        crapThreshold = crapThreshold2;
    }

    private String escapeXml(String prettyMethodSignature) {
        return prettyMethodSignature.replace("<", "&lt;").replace(">", "&gt;");
    }

    @Override
    public String prettyMethodSignature() {
        return this.complexity.prettyMethodSignature();
    }
}

