/*
 * Decompiled with CFR 0.152.
 */
package org.crap4j;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.crap4j.util.FileUtil;
import org.crap4j.util.MyStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrapProject {
    private static final String PROJECT_ID_FILE = ".crap4j_project_id";
    private String projectDir;
    private List<String> libClasspaths;
    private List<String> testClassDirs;
    private List<String> classDirs;
    private List<String> sourceDirs;
    private String outputDir;
    private Long projectId;

    public List<String> classDirs() {
        return this.classDirs;
    }

    public List<String> libClasspaths() {
        return this.libClasspaths;
    }

    public List<String> testClassDirs() {
        return this.testClassDirs;
    }

    public String outputDir() {
        return this.outputDir;
    }

    public CrapProject(String projectDir, List<String> libClasspath, List<String> testClassDirs, List<String> projectClassDirs, List<String> sourceDirs, String outputDir) {
        this.projectDir = projectDir;
        this.libClasspaths = this.makeAbsolute(libClasspath);
        this.testClassDirs = this.makeAbsolute(testClassDirs);
        this.classDirs = this.makeAbsolute(projectClassDirs);
        this.sourceDirs = this.makeAbsolute(sourceDirs);
        this.outputDir = outputDir == null || outputDir.equals("") ? (outputDir = projectDir + File.separator + "agitar" + File.separator + "reports" + File.separator + "crap4j") : (FileUtil.isAbsolute(outputDir) ? outputDir : this.makeFilePathAbsoluteWithProject(outputDir));
        FileUtil.ensureDirectory(this.outputDir);
        this.projectId = this.ensureProjectId();
    }

    private Long ensureProjectId() {
        Long projectId = this.loadProjectId();
        if (projectId == null) {
            projectId = this.makeProjectId();
            this.writeProjectId(projectId);
        }
        return projectId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeProjectId(Long projectId2) {
        File f = this.getProjectIdFile();
        DataOutputStream out = null;
        try {
            out = new DataOutputStream(new FileOutputStream(f));
            try {
                out.writeLong(projectId2);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long loadProjectId() {
        Long id = null;
        File f = this.getProjectIdFile();
        if (f.exists()) {
            DataInputStream io = null;
            try {
                io = new DataInputStream(new FileInputStream(f));
                try {
                    id = io.readLong();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (io != null) {
                        try {
                            io.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return id;
    }

    private File getProjectIdFile() {
        File f = new File(this.outputDir(), PROJECT_ID_FILE);
        return f;
    }

    private Long makeProjectId() {
        return System.currentTimeMillis();
    }

    private List<String> makeAbsolute(List<String> sourceDirs2) {
        ArrayList<String> absolutePaths = new ArrayList<String>();
        for (String path : sourceDirs2) {
            if (path == null) continue;
            if (FileUtil.isAbsolute(path)) {
                absolutePaths.add(path);
                continue;
            }
            absolutePaths.add(this.makeFilePathAbsoluteWithProject(path));
        }
        return absolutePaths;
    }

    private String makeFilePathAbsoluteWithProject(String path) {
        return FileUtil.joinPath(this.projectDir, path);
    }

    public String projectDir() {
        return this.projectDir;
    }

    public List<String> sourceDirs() {
        return this.sourceDirs;
    }

    public List<String> allClasspaths() {
        ArrayList<String> all = new ArrayList<String>();
        all.addAll(this.classDirs());
        all.addAll(this.testClassDirs());
        all.addAll(this.libClasspaths());
        return all;
    }

    public List<File> getAllProjectClasses() {
        ArrayList<File> classNames = new ArrayList<File>();
        for (String dirName : this.classDirs) {
            classNames.addAll(this.getClassesIn(dirName));
        }
        return classNames;
    }

    private List<File> getClassesIn(String dirName) {
        ArrayList<File> classNames = new ArrayList<File>();
        classNames.addAll(FileUtil.getAllFilesInDirMatchingPattern(dirName, ".*.class", false));
        return classNames;
    }

    public String getCoverageDir() throws IOException {
        return new File(this.projectDir + File.separator + "agitar" + File.separator + ".results").getCanonicalPath();
    }

    public String getProjectName() {
        return new File(this.projectDir).getName();
    }

    public void toXml(MyStringBuilder s) {
        CrapProject.itemToXml(s, "project", this.projectDir);
        CrapProject.itemToXml(s, "project_id", this.projectId.toString());
        CrapProject.itemToXml(s, "timestamp", SimpleDateFormat.getInstance().format(Calendar.getInstance().getTime()));
        CrapProject.collectionToXml(s, "classDirectories", "classDirectory", this.classDirs);
        CrapProject.collectionToXml(s, "testClassDirectories", "testClassDirectory", this.testClassDirs);
        CrapProject.collectionToXml(s, "sourceDirectories", "sourceDirectory", this.sourceDirs);
        CrapProject.collectionToXml(s, "libClasspaths", "libClasspath", this.libClasspaths);
    }

    public static void collectionToXml(MyStringBuilder s, String collectionName, String itemName, List<String> collection) {
        s.start("<" + collectionName + ">");
        for (String item : collection) {
            CrapProject.itemToXml(s, itemName, item);
        }
        s.end("</" + collectionName + ">");
    }

    public static void itemToXml(MyStringBuilder s, String itemName, String item) {
        s.start("<" + itemName + ">").append(item).end("</" + itemName + ">");
    }

    public File getReportFile() {
        return new File(this.outputDir(), "report.xml");
    }

    public File getReportHtmlFile() {
        return new File(this.outputDir(), "index.html");
    }

    public Long getProjectId() {
        return this.projectId;
    }
}

