/*
 * Decompiled with CFR 0.152.
 */
package org.crap4j;

import com.agitar.org.objectweb.asm.tree.analysis.AnalyzerException;
import java.io.IOException;
import java.util.List;
import org.crap4j.CoverageGeneratorStrategy;
import org.crap4j.Crap;
import org.crap4j.CrapProject;
import org.crap4j.MethodComplexity;
import org.crap4j.MethodCoverage;
import org.crap4j.MethodCrap;
import org.crap4j.SystemCrapStats;
import org.crap4j.benchmark.StatsDownloader;
import org.crap4j.external.MetricsComplexityReader;
import org.crap4j.external.SuperRunnerCoverageReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Crap4jRunner {
    private boolean debug;
    private boolean dontTest;
    private CoverageGeneratorStrategy coverageStrategy;
    private float crapPercentWarningThreshold;
    private float crapPercentCriticalThreshold;
    private float crapThreshold;
    private boolean downloadAverages;
    private String server;

    public Crap4jRunner(boolean debug, boolean dontTest, boolean downloadAverages, CoverageGeneratorStrategy strategy, float crapThreshold, float crapPercentWarningThreshold, float crapPercentCriticalThreshold, String server) {
        this.debug = debug;
        this.dontTest = dontTest;
        this.coverageStrategy = strategy;
        this.crapThreshold = crapThreshold;
        this.crapPercentWarningThreshold = crapPercentWarningThreshold;
        this.crapPercentCriticalThreshold = crapPercentCriticalThreshold;
        this.downloadAverages = downloadAverages;
        this.server = server;
    }

    public void doProject(CrapProject p) throws IOException, AnalyzerException {
        if (this.dontTest) {
            this.readResults(p);
        } else {
            this.generateCoverageDataStatsFor(p);
        }
    }

    public void readResults(CrapProject p) throws IOException, AnalyzerException {
        SystemCrapStats s = new SystemCrapStats(this.buildMethodCrap(this.readCoverage(p), this.readMethodComplexity(p)), "Method Crap Stats", p, this.crapThreshold, this.crapPercentWarningThreshold, this.crapPercentCriticalThreshold, new StatsDownloader(this.server).getAverage(this.downloadAverages), this.server);
        s.writeReport();
        System.out.println(s.toString());
    }

    private List<? extends Crap> buildMethodCrap(List<MethodCoverage> covs, List<MethodComplexity> complexities) {
        return MethodCrap.combine(covs, complexities);
    }

    private List<MethodComplexity> readMethodComplexity(CrapProject p) throws IOException, AnalyzerException {
        return new MetricsComplexityReader(p).readMethodComplexities();
    }

    private List<MethodCoverage> readCoverage(CrapProject p) throws IOException {
        return new SuperRunnerCoverageReader(p).read();
    }

    private void generateCoverageDataStatsFor(CrapProject project) {
        this.coverageStrategy.execute(this, project, this.debug);
    }
}

