/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.org.objectweb.asm.commons;

import com.agitar.org.objectweb.asm.Label;
import com.agitar.org.objectweb.asm.MethodVisitor;
import com.agitar.org.objectweb.asm.Opcodes;
import com.agitar.org.objectweb.asm.tree.AbstractInsnNode;
import com.agitar.org.objectweb.asm.tree.InsnList;
import com.agitar.org.objectweb.asm.tree.InsnNode;
import com.agitar.org.objectweb.asm.tree.JumpInsnNode;
import com.agitar.org.objectweb.asm.tree.LabelNode;
import com.agitar.org.objectweb.asm.tree.LocalVariableNode;
import com.agitar.org.objectweb.asm.tree.LookupSwitchInsnNode;
import com.agitar.org.objectweb.asm.tree.MethodNode;
import com.agitar.org.objectweb.asm.tree.TableSwitchInsnNode;
import com.agitar.org.objectweb.asm.tree.TryCatchBlockNode;
import com.agitar.org.objectweb.asm.util.AbstractVisitor;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JSRInlinerAdapter
extends MethodNode
implements Opcodes {
    private static final boolean LOGGING = false;
    private MethodVisitor mv;
    private boolean seenJSR;
    private int subroutineId = 0;
    private final Map subroutineHeads = new Hashtable();
    private final Subroutine mainSubroutine = new Subroutine(-1);
    private final BitSet dualCitizens = new BitSet();

    public JSRInlinerAdapter(MethodVisitor mv, int access, String name, String desc, String signature, String[] exceptions) {
        super(access, name, desc, signature, exceptions);
        this.mv = mv;
    }

    public void visitJumpInsn(int opcode, Label lbl) {
        super.visitJumpInsn(opcode, lbl);
        if (opcode == 168) {
            this.seenJSR = true;
        }
    }

    public void visitEnd() {
        if (this.seenJSR) {
            this.populateSubroutineHeads();
            this.markSubroutines();
            this.emitCode();
        }
        if (this.mv != null) {
            this.accept(this.mv);
        }
    }

    private void populateSubroutineHeads() {
        int i = 0;
        int c = this.instructions.size();
        while (i < c) {
            LabelNode tar;
            AbstractInsnNode node = this.instructions.get(i);
            if (node.getOpcode() == 168 && !this.subroutineHeads.containsKey(tar = ((JumpInsnNode)node).label)) {
                Subroutine subr = new Subroutine(this.subroutineId++);
                this.subroutineHeads.put(tar, subr);
            }
            ++i;
        }
    }

    private void markSubroutines() {
        BitSet anyvisited = new BitSet();
        this.markSubroutineWalk(this.mainSubroutine, 0, anyvisited);
        Iterator it = this.subroutineHeads.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            LabelNode lab = (LabelNode)entry.getKey();
            Subroutine sub = (Subroutine)entry.getValue();
            int index = this.instructions.indexOf(lab);
            this.markSubroutineWalk(sub, index, anyvisited);
        }
    }

    private void markSubroutineWalk(Subroutine sub, int index, BitSet anyvisited) {
        this.markSubroutineWalkDFS(sub, index, anyvisited);
        boolean loop = true;
        while (loop) {
            loop = false;
            Iterator it = this.tryCatchBlocks.iterator();
            while (it.hasNext()) {
                TryCatchBlockNode trycatch = (TryCatchBlockNode)it.next();
                int handlerindex = this.instructions.indexOf(trycatch.handler);
                if (sub.instructions.get(handlerindex)) continue;
                int startindex = this.instructions.indexOf(trycatch.start);
                int endindex = this.instructions.indexOf(trycatch.end);
                int nextbit = sub.instructions.nextSetBit(startindex);
                if (nextbit == -1 || nextbit >= endindex) continue;
                this.markSubroutineWalkDFS(sub, handlerindex, anyvisited);
                loop = true;
            }
        }
    }

    private void markSubroutineWalkDFS(Subroutine sub, int index, BitSet anyvisited) {
        while (true) {
            LabelNode l;
            int i;
            int destidx;
            AbstractInsnNode node = this.instructions.get(index);
            if (sub.instructions.get(index)) {
                return;
            }
            sub.instructions.set(index);
            if (anyvisited.get(index)) {
                this.dualCitizens.set(index);
            }
            anyvisited.set(index);
            if (node.getType() == 6 && node.getOpcode() != 168) {
                JumpInsnNode jnode = (JumpInsnNode)node;
                destidx = this.instructions.indexOf(jnode.label);
                this.markSubroutineWalkDFS(sub, destidx, anyvisited);
            }
            if (node.getType() == 10) {
                TableSwitchInsnNode tsnode = (TableSwitchInsnNode)node;
                destidx = this.instructions.indexOf(tsnode.dflt);
                this.markSubroutineWalkDFS(sub, destidx, anyvisited);
                i = tsnode.labels.size() - 1;
                while (i >= 0) {
                    l = (LabelNode)tsnode.labels.get(i);
                    destidx = this.instructions.indexOf(l);
                    this.markSubroutineWalkDFS(sub, destidx, anyvisited);
                    --i;
                }
            }
            if (node.getType() == 11) {
                LookupSwitchInsnNode lsnode = (LookupSwitchInsnNode)node;
                destidx = this.instructions.indexOf(lsnode.dflt);
                this.markSubroutineWalkDFS(sub, destidx, anyvisited);
                i = lsnode.labels.size() - 1;
                while (i >= 0) {
                    l = (LabelNode)lsnode.labels.get(i);
                    destidx = this.instructions.indexOf(l);
                    this.markSubroutineWalkDFS(sub, destidx, anyvisited);
                    --i;
                }
            }
            switch (this.instructions.get(index).getOpcode()) {
                case 167: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    return;
                }
            }
            ++index;
        }
    }

    private void emitCode() {
        LinkedList<Instantiation> worklist = new LinkedList<Instantiation>();
        worklist.add(new Instantiation(null, this.mainSubroutine));
        InsnList newInstructions = new InsnList();
        ArrayList newTryCatchBlocks = new ArrayList();
        ArrayList newLocalVariables = new ArrayList();
        while (!worklist.isEmpty()) {
            Instantiation inst = (Instantiation)worklist.removeFirst();
            this.emitSubroutine(inst, worklist, newInstructions, newTryCatchBlocks, newLocalVariables);
        }
        this.instructions = newInstructions;
        this.tryCatchBlocks = newTryCatchBlocks;
        this.localVariables = newLocalVariables;
    }

    private void emitSubroutine(Instantiation instant, List worklist, InsnList newInstructions, List newTryCatchBlocks, List newLocalVariables) {
        LabelNode end;
        LabelNode start;
        LabelNode duplbl = null;
        int i = 0;
        int c = this.instructions.size();
        while (i < c) {
            AbstractInsnNode insn = this.instructions.get(i);
            Instantiation owner = instant.findOwner(i);
            if (insn.getType() == 7) {
                LabelNode ilbl = (LabelNode)insn;
                LabelNode remap = instant.rangeLabel(ilbl);
                if (remap != duplbl) {
                    newInstructions.add(remap);
                    duplbl = remap;
                }
            } else if (owner == instant) {
                if (insn.getOpcode() == 169) {
                    LabelNode retlabel = null;
                    Instantiation p = instant;
                    while (p != null) {
                        if (p.subroutine.ownsInstruction(i)) {
                            retlabel = p.returnLabel;
                        }
                        p = p.previous;
                    }
                    if (retlabel == null) {
                        throw new RuntimeException("Instruction #" + i + " is a RET not owned by any subroutine");
                    }
                    newInstructions.add(new JumpInsnNode(167, retlabel));
                } else if (insn.getOpcode() == 168) {
                    LabelNode lbl = ((JumpInsnNode)insn).label;
                    Subroutine sub = (Subroutine)this.subroutineHeads.get(lbl);
                    Instantiation newinst = new Instantiation(instant, sub);
                    LabelNode startlbl = newinst.gotoLabel(lbl);
                    newInstructions.add(new InsnNode(1));
                    newInstructions.add(new JumpInsnNode(167, startlbl));
                    newInstructions.add(newinst.returnLabel);
                    worklist.add(newinst);
                } else {
                    newInstructions.add(insn.clone(instant));
                }
            }
            ++i;
        }
        Iterator it = this.tryCatchBlocks.iterator();
        while (it.hasNext()) {
            TryCatchBlockNode trycatch = (TryCatchBlockNode)it.next();
            start = instant.rangeLabel(trycatch.start);
            if (start == (end = instant.rangeLabel(trycatch.end))) continue;
            LabelNode handler = instant.gotoLabel(trycatch.handler);
            if (start == null || end == null || handler == null) {
                throw new RuntimeException("Internal error!");
            }
            newTryCatchBlocks.add(new TryCatchBlockNode(start, end, handler, trycatch.type));
        }
        it = this.localVariables.iterator();
        while (it.hasNext()) {
            LocalVariableNode lvnode = (LocalVariableNode)it.next();
            start = instant.rangeLabel(lvnode.start);
            if (start == (end = instant.rangeLabel(lvnode.end))) continue;
            newLocalVariables.add(new LocalVariableNode(lvnode.name, lvnode.desc, lvnode.signature, start, end, lvnode.index));
        }
    }

    private String insnDesc(AbstractInsnNode insn) {
        String opcode = null;
        if (insn.getOpcode() >= 0) {
            opcode = AbstractVisitor.OPCODES[insn.getOpcode()];
        }
        if (insn.getType() == 6) {
            LabelNode lbl = ((JumpInsnNode)insn).label;
            int idx = this.instructions.indexOf(lbl);
            if (idx != -1) {
                return String.valueOf(opcode) + " " + idx;
            }
            return String.valueOf(opcode) + " " + lbl;
        }
        if (opcode != null) {
            return opcode;
        }
        return insn.toString();
    }

    private void logSource() {
        this.log("--------------------------------------------------------");
        this.log("Input source");
        int i = 0;
        while (i < this.instructions.size()) {
            String lnum = Integer.toString(i);
            while (lnum.length() < 3) {
                lnum = "0" + lnum;
            }
            AbstractInsnNode insn = this.instructions.get(i);
            String desc = this.insnDesc(insn);
            this.log(String.valueOf(lnum) + ": " + desc);
            ++i;
        }
        this.log(this.mainSubroutine + ": " + this.mainSubroutine.instructions);
        Iterator it = this.subroutineHeads.values().iterator();
        while (it.hasNext()) {
            Subroutine sub = (Subroutine)it.next();
            this.log(sub + ": " + sub.instructions);
        }
    }

    private void log(String str) {
        System.err.println(str);
    }

    protected static class Subroutine {
        public final int id;
        public final BitSet instructions = new BitSet();

        public Subroutine(int id) {
            this.id = id;
        }

        public void addInstruction(int idx) {
            this.instructions.set(idx);
        }

        public boolean ownsInstruction(int idx) {
            return this.instructions.get(idx);
        }

        public String toString() {
            return "[Subroutine #" + this.id + "]";
        }
    }

    private class Instantiation
    extends AbstractMap {
        final Instantiation previous;
        public final Subroutine subroutine;
        public final Map rangeTable = new HashMap();
        public final LabelNode returnLabel;

        public Instantiation(Instantiation prev, Subroutine sub) {
            this.previous = prev;
            this.subroutine = sub;
            Instantiation p = prev;
            while (p != null) {
                if (p.subroutine == sub) {
                    throw new RuntimeException("Recursive invocation of " + sub);
                }
                p = p.previous;
            }
            this.returnLabel = prev != null ? new LabelNode() : null;
            LabelNode duplbl = null;
            int i = 0;
            int c = JSRInlinerAdapter.this.instructions.size();
            while (i < c) {
                AbstractInsnNode insn = JSRInlinerAdapter.this.instructions.get(i);
                if (insn.getType() == 7) {
                    LabelNode ilbl = (LabelNode)insn;
                    if (duplbl == null) {
                        duplbl = new LabelNode();
                    }
                    this.rangeTable.put(ilbl, duplbl);
                } else if (this.findOwner(i) == this) {
                    duplbl = null;
                }
                ++i;
            }
        }

        public Instantiation findOwner(int i) {
            if (!this.subroutine.ownsInstruction(i)) {
                return null;
            }
            if (!JSRInlinerAdapter.this.dualCitizens.get(i)) {
                return this;
            }
            Instantiation own = this;
            Instantiation p = this.previous;
            while (p != null) {
                if (p.subroutine.ownsInstruction(i)) {
                    own = p;
                }
                p = p.previous;
            }
            return own;
        }

        public LabelNode gotoLabel(LabelNode l) {
            Instantiation owner = this.findOwner(JSRInlinerAdapter.this.instructions.indexOf(l));
            return (LabelNode)owner.rangeTable.get(l);
        }

        public LabelNode rangeLabel(LabelNode l) {
            return (LabelNode)this.rangeTable.get(l);
        }

        public Set entrySet() {
            return null;
        }

        public Object get(Object o) {
            return this.gotoLabel((LabelNode)o);
        }
    }
}

