/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.crapertura.statistics;

import com.schneide.crapertura.coverage.report.MethodCoverage;
import org.crap4j.MethodComplexity;

public class MethodCrapData {
    private final MethodComplexity complexity;
    private final double coverage;
    private final double crap;
    private final int crapLoad;
    private final int crapThreshold;

    public MethodCrapData(MethodComplexity complexity, MethodCoverage coverage, int crapThreshold) {
        this.complexity = complexity;
        this.coverage = coverage.getCoverage();
        this.crap = MethodCrapData.calculateCrap(complexity.getComplexity(), this.coverage);
        this.crapThreshold = crapThreshold;
        this.crapLoad = MethodCrapData.calculateCrapLoad(this.crap, this.complexity.getComplexity(), this.coverage, crapThreshold);
    }

    public String getPackage() {
        return this.complexity.getPackageName();
    }

    public String getClassName() {
        return this.complexity.getClassName();
    }

    public String getMethodName() {
        return this.complexity.getMethodName();
    }

    public String getMethodSignature() {
        return this.complexity.getSigOrDescriptor();
    }

    public String getFullMethod() {
        return this.complexity.prettyMethodSignature();
    }

    public double getCrap() {
        return this.crap;
    }

    public int getCrapLoad() {
        return this.crapLoad;
    }

    public int getComplexity() {
        return this.complexity.getComplexity();
    }

    public double getCoverage() {
        return this.coverage;
    }

    public int getCrapThreshold() {
        return this.crapThreshold;
    }

    public static int calculateCrapLoad(double crap, int complexity, double coverage, double crapThreshold) {
        int crapLoad = 0;
        if (crap >= crapThreshold) {
            crapLoad = (int)((double)crapLoad + (double)complexity * (1.0 - coverage));
            crapLoad = (int)((double)crapLoad + (double)complexity / crapThreshold);
        }
        return crapLoad;
    }

    protected static double calculateCrap(double complexity, double coverage) {
        return (float)(complexity * (complexity * Math.pow(1.0 - coverage, 3.0)) + complexity);
    }
}

