/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.crapertura.statistics;

import com.schneide.crapertura.statistics.MethodCrapData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CrapStatistics {
    private static final double NOT_YET_CALCULATED = -1.0;
    private final Map<Aspect, StatisticAspect> aspectsMap;
    private final int crapThreshold;

    protected CrapStatistics(Iterable<StatisticAspect> aspects, int crapThreshold) {
        this.crapThreshold = crapThreshold;
        this.aspectsMap = new HashMap<Aspect, StatisticAspect>();
        for (StatisticAspect statisticAspect : aspects) {
            this.aspectsMap.put(statisticAspect.getIdentifier(), statisticAspect);
        }
    }

    public static CrapStatistics fromMethodData(Iterable<MethodCrapData> data) {
        ArrayList<StatisticAspect> aspects = new ArrayList<StatisticAspect>();
        aspects.add(new MethodCount());
        aspects.add(new TotalCrap());
        aspects.add(new CrapMethodCount());
        aspects.add(new CrapLoad());
        aspects.add(new Median());
        aspects.add(new StandardDeviation());
        int crapThreshold = 30;
        for (MethodCrapData method : data) {
            crapThreshold = method.getCrapThreshold();
            for (StatisticAspect statisticAspect : aspects) {
                statisticAspect.include(method);
            }
        }
        return new CrapStatistics(aspects, crapThreshold);
    }

    protected Number getResultFor(Aspect aspect) {
        return this.aspectsMap.get((Object)aspect).getResult();
    }

    public double getTotalCrap() {
        return this.getResultFor(Aspect.TOTAL_CRAP).doubleValue();
    }

    public double getCrap() {
        return this.getTotalCrap() / (double)this.getMethodCount();
    }

    public double getMedian() {
        return this.getResultFor(Aspect.MEDIAN).doubleValue();
    }

    public double getAverage() {
        return this.getTotalCrap() / (double)this.getMethodCount();
    }

    public double getStandardDeviation() {
        return this.getResultFor(Aspect.STANDARD_DEVIATION).doubleValue();
    }

    public int getMethodCount() {
        return this.getResultFor(Aspect.METHOD_COUNT).intValue();
    }

    public int getCrapMethodCount() {
        return this.getResultFor(Aspect.CRAP_METHOD_COUNT).intValue();
    }

    public double getCrapMethodPercent() {
        return (double)this.getCrapMethodCount() / (double)this.getMethodCount();
    }

    public int getCrapLoad() {
        return this.getResultFor(Aspect.CRAP_LOAD).intValue();
    }

    public int getCrapThreshold() {
        return this.crapThreshold;
    }

    public double getGlobalAverage() {
        return -1.0;
    }

    public double getGlobalCraploadAverage() {
        return -1.0;
    }

    public double getGlobalCrapMethodAverage() {
        return -1.0;
    }

    public double getGlobalCrapMethodPercent() {
        return -1.0;
    }

    public double getGlobalAverageDiff() {
        return this.getAverage() + 1.0;
    }

    public double getGlobalCraploadAverageDiff() {
        return (double)this.getCrapLoad() + 1.0;
    }

    public double getGlobalCrapMethodAverageDiff() {
        return (double)this.getCrapMethodCount() + 1.0;
    }

    public double getGlobalTotalMethodAverageDiff() {
        return (double)this.getMethodCount() + 1.0;
    }

    protected static class CrapMethodCount
    extends IntegerAdditionAspect {
        public CrapMethodCount() {
            super(Aspect.CRAP_METHOD_COUNT);
        }

        @Override
        public void include(MethodCrapData methodData) {
            if (methodData.getCrapLoad() > 0) {
                this.addToResult(1);
            }
        }
    }

    protected static class MethodCount
    extends IntegerAdditionAspect {
        public MethodCount() {
            super(Aspect.METHOD_COUNT);
        }

        @Override
        public void include(MethodCrapData methodData) {
            this.addToResult(1);
        }
    }

    protected static class CrapLoad
    extends IntegerAdditionAspect {
        public CrapLoad() {
            super(Aspect.CRAP_LOAD);
        }

        @Override
        public void include(MethodCrapData methodData) {
            this.addToResult(methodData.getCrapLoad());
        }
    }

    protected static class TotalCrap
    extends DoubleAdditionAspect {
        public TotalCrap() {
            super(Aspect.TOTAL_CRAP);
        }

        @Override
        public void include(MethodCrapData methodData) {
            this.addToResult(methodData.getCrap());
        }
    }

    protected static abstract class DoubleAdditionAspect
    extends AspectBase {
        private double result = 0.0;

        public DoubleAdditionAspect(Aspect identifier) {
            super(identifier);
        }

        @Override
        public abstract void include(MethodCrapData var1);

        protected void addToResult(double offset) {
            this.result += offset;
        }

        @Override
        public Number getResult() {
            return this.result;
        }
    }

    protected static abstract class IntegerAdditionAspect
    extends AspectBase {
        private int result = 0;

        public IntegerAdditionAspect(Aspect identifier) {
            super(identifier);
        }

        @Override
        public abstract void include(MethodCrapData var1);

        protected void addToResult(int offset) {
            this.result += offset;
        }

        @Override
        public Number getResult() {
            return this.result;
        }
    }

    protected static class StandardDeviation
    extends AspectBase {
        private final org.apache.commons.math.stat.descriptive.moment.StandardDeviation calculator = new org.apache.commons.math.stat.descriptive.moment.StandardDeviation();

        public StandardDeviation() {
            super(Aspect.STANDARD_DEVIATION);
        }

        @Override
        public void include(MethodCrapData methodData) {
            this.calculator.increment(methodData.getCrap());
        }

        @Override
        public Number getResult() {
            return this.calculator.getResult();
        }
    }

    protected static class Median
    extends AspectBase {
        private final List<Double> crapValues = new ArrayList<Double>();

        public Median() {
            super(Aspect.MEDIAN);
        }

        @Override
        public void include(MethodCrapData methodData) {
            this.crapValues.add(methodData.getCrap());
        }

        @Override
        public Number getResult() {
            org.apache.commons.math.stat.descriptive.rank.Median median = new org.apache.commons.math.stat.descriptive.rank.Median();
            double[] values = new double[this.crapValues.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.crapValues.get(i);
            }
            return median.evaluate(values);
        }
    }

    protected static abstract class AspectBase
    implements StatisticAspect {
        private final Aspect identifier;

        public AspectBase(Aspect identifier) {
            this.identifier = identifier;
        }

        @Override
        public Aspect getIdentifier() {
            return this.identifier;
        }
    }

    protected static interface StatisticAspect {
        public Aspect getIdentifier();

        public void include(MethodCrapData var1);

        public Number getResult();
    }

    protected static enum Aspect {
        METHOD_COUNT,
        TOTAL_CRAP,
        CRAP_METHOD_COUNT,
        CRAP_LOAD,
        MEDIAN,
        STANDARD_DEVIATION;

    }
}

