/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.crapertura.complexity;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.crap4j.MethodComplexity;
import org.crap4j.complexity.CyclomaticComplexity;

public class ComplexityCalculator {
    private final CyclomaticComplexity complexity = new CyclomaticComplexity();

    public Collection<MethodComplexity> calculateComplexitiesFor(File ... classesDirectories) throws Exception {
        ArrayList<MethodComplexity> result = new ArrayList<MethodComplexity>();
        for (File directory : classesDirectories) {
            result.addAll(this.calculateComplexitiesFor(directory));
        }
        return result;
    }

    public Collection<MethodComplexity> calculateComplexitiesFor(File classesDirectory) throws Exception {
        ArrayList<MethodComplexity> result = new ArrayList<MethodComplexity>();
        for (File file : classesDirectory.listFiles()) {
            if (file.isDirectory()) {
                result.addAll(this.calculateComplexitiesFor(file));
            }
            if (!file.isFile() || !file.getName().endsWith(".class")) continue;
            List methodComplexities = this.complexity.getMethodComplexitiesFor(file);
            result.addAll(methodComplexities);
        }
        return result;
    }
}

