/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.crapertura.ant;

import com.schneide.crapertura.CrapReportWriter;
import com.schneide.crapertura.complexity.ComplexityCalculator;
import com.schneide.crapertura.coverage.report.CoberturaXMLReportReader;
import com.schneide.crapertura.coverage.report.MethodCoverage;
import com.schneide.crapertura.statistics.MethodCrapData;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.crap4j.Crap;
import org.crap4j.CrapProject;
import org.crap4j.MethodComplexity;
import org.crap4j.MethodCrap;
import org.crap4j.SystemCrapStats;
import org.crap4j.benchmark.GlobalStats;

public class CraperturaTask
extends Task {
    private static final MethodCoverage NO_COVERAGE = new MethodCoverage(0.0, 0.0);
    private File coberturaReportFile;
    private File reportTargetDirectory;
    private File classesDirectory;
    private int crapThreshold = 30;
    private boolean generateHTMLReport = true;

    public void execute() throws BuildException {
        this.failIfAbsent(this.coberturaReportFile, "coberturaReportFile");
        this.failIfAbsent(this.reportTargetDirectory, "targetDirectory");
        this.failIfAbsent(this.classesDirectory, "classesDirectory");
        if (!this.reportTargetDirectory.isDirectory()) {
            this.reportTargetDirectory.mkdirs();
        }
        try {
            this.executeChecked();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected void executeChecked() throws Exception {
        Iterable<CrapReporting> reporting = this.buildReportings();
        MethodCoverageProvider coverageProvider = new MethodCoverageProvider(this.coberturaReportFile);
        for (MethodComplexity methodComplexity : this.fetchMethodComplexities()) {
            MethodCoverage methodCoverage = coverageProvider.getCoverageFor(methodComplexity.getMatchingMethodSignature());
            for (CrapReporting crapReporting : reporting) {
                crapReporting.consider(methodComplexity, methodCoverage);
            }
        }
        for (CrapReporting crapReporting : reporting) {
            crapReporting.writeTo(this.reportTargetDirectory);
        }
    }

    protected Iterable<MethodComplexity> fetchMethodComplexities() throws Exception {
        ComplexityCalculator calculator = new ComplexityCalculator();
        return calculator.calculateComplexitiesFor(this.classesDirectory);
    }

    private Iterable<CrapReporting> buildReportings() {
        ArrayList<CrapReporting> result = new ArrayList<CrapReporting>();
        result.add(new XMLCrapReporting());
        if (this.generateHTMLReport) {
            result.add(new OriginalHTMLCrapReporting());
        }
        return result;
    }

    protected void failIfAbsent(Object instance, String parameterName) {
        if (null != instance) {
            return;
        }
        throw new BuildException("Required parameter " + parameterName + " missing.");
    }

    public void setCoberturaReportFile(File coberturaReportFile) {
        this.coberturaReportFile = coberturaReportFile;
    }

    public void setTargetDirectory(File targetDirectory) {
        this.reportTargetDirectory = targetDirectory;
    }

    public void setClassesDirectory(File classesDirectory) {
        this.classesDirectory = classesDirectory;
    }

    public void setCrapThreshold(int crapThreshold) {
        this.crapThreshold = crapThreshold;
    }

    public void setGenerateHTMLReport(boolean generateReport) {
        this.generateHTMLReport = generateReport;
    }

    protected class MethodCoverageProvider {
        private Map<String, MethodCoverage> map;

        public MethodCoverageProvider(File coberturaFile) throws Exception {
            CoberturaXMLReportReader reader = new CoberturaXMLReportReader();
            this.map = reader.readXMLReport(coberturaFile);
        }

        public MethodCoverage getCoverageFor(String methodSignature) {
            MethodCoverage currentCoverage = NO_COVERAGE;
            if (this.map.containsKey(methodSignature)) {
                currentCoverage = this.map.get(methodSignature);
            }
            return currentCoverage;
        }
    }

    protected class OriginalHTMLCrapReporting
    implements CrapReporting {
        private final List<Crap> crapData = new ArrayList<Crap>();

        @Override
        public void consider(MethodComplexity methodComplexity, MethodCoverage methodCoverage) {
            MethodCrap newOriginalData = new MethodCrap(methodComplexity.getMatchingMethodSignature(), (float)methodCoverage.getCoverage(), methodComplexity);
            this.crapData.add((Crap)newOriginalData);
        }

        @Override
        public void writeTo(File targetDirectory) throws IOException {
            CrapProject crapProject = new CrapProject("TODO projectDir", new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), targetDirectory.getAbsolutePath());
            SystemCrapStats originalReport = new SystemCrapStats(this.crapData, "TODO original report", crapProject, (float)CraperturaTask.this.crapThreshold, 10.0f, 5.0f, GlobalStats.NULL_STATS, "http://127.0.0.1/upload_disabled/");
            originalReport.writeReport();
        }
    }

    protected class XMLCrapReporting
    implements CrapReporting {
        private final List<MethodCrapData> crapData = new ArrayList<MethodCrapData>();

        @Override
        public void consider(MethodComplexity methodComplexity, MethodCoverage methodCoverage) {
            MethodCrapData newData = new MethodCrapData(methodComplexity, methodCoverage, CraperturaTask.this.crapThreshold);
            this.crapData.add(newData);
        }

        @Override
        public void writeTo(File targetFile) throws IOException {
            CrapReportWriter writer = new CrapReportWriter();
            writer.writeReportTo(new File(targetFile, "report.xml"), this.crapData);
        }
    }

    protected static interface CrapReporting {
        public void consider(MethodComplexity var1, MethodCoverage var2);

        public void writeTo(File var1) throws IOException;
    }
}

