/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.crapertura;

import com.schneide.crapertura.statistics.CrapStatistics;
import com.schneide.crapertura.statistics.MethodCrapData;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class CrapReportWriter {
    public void writeReportTo(File targetFile, Iterable<MethodCrapData> data) throws IOException {
        OutputFormat outformat = OutputFormat.createPrettyPrint();
        XMLWriter writer = new XMLWriter((OutputStream)new FileOutputStream(targetFile), outformat);
        writer.write(this.createReportDocument(data));
        writer.flush();
    }

    protected Document createReportDocument(Iterable<MethodCrapData> data) {
        Document document = DocumentFactory.getInstance().createDocument();
        Element rootElement = document.addElement("crap_result");
        rootElement.addElement("project").addText("TODO");
        rootElement.addElement("project_id").addText("TODO");
        rootElement.addElement("timestamp").addText("TODO");
        this.addClassDirectories(rootElement.addElement("classDirectories"));
        this.addTestClassDirectories(rootElement.addElement("testClassDirectories"));
        this.addSourceDirectories(rootElement.addElement("sourceDirectories"));
        this.addLibClasspaths(rootElement.addElement("libClasspaths"));
        this.addStats(rootElement.addElement("stats"), CrapStatistics.fromMethodData(data));
        this.addMethods(rootElement.addElement("methods"), data);
        return document;
    }

    protected void addHistogram(Element histogramElement) {
        HistogramBar[] bars;
        for (HistogramBar histogramBar : bars = new HistogramBar[]{new HistogramBar("one", 0, 0.0), new HistogramBar("two", 0, 0.0), new HistogramBar("four", 0, 0.0), new HistogramBar("eight", 0, 0.0), new HistogramBar("sixteen", 0, 0.0), new HistogramBar("thirtytwo", 0, 0.0), new HistogramBar("sixtyfour", 0, 0.0), new HistogramBar("one28", 0, 0.0), new HistogramBar("two56", 0, 0.0)}) {
            histogramBar.appendToElement(histogramElement);
        }
    }

    protected void addNumberElement(Element root, String elementName, double value) {
        root.addElement(elementName).addText(String.valueOf(value));
    }

    protected void addNumberElement(Element root, String elementName, int value) {
        root.addElement(elementName).addText(String.valueOf(value));
    }

    protected void addStats(Element statsElement, CrapStatistics statistics) {
        statsElement.addElement("name").addText("Method Crap Stats");
        this.addNumberElement(statsElement, "totalCrap", statistics.getTotalCrap());
        this.addNumberElement(statsElement, "crap", statistics.getCrap());
        this.addNumberElement(statsElement, "median", statistics.getMedian());
        this.addNumberElement(statsElement, "average", statistics.getAverage());
        this.addNumberElement(statsElement, "stdDev", statistics.getStandardDeviation());
        this.addNumberElement(statsElement, "methodCount", statistics.getMethodCount());
        this.addNumberElement(statsElement, "crapMethodCount", statistics.getCrapMethodCount());
        this.addNumberElement(statsElement, "crapMethodPercent", statistics.getCrapMethodPercent());
        this.addNumberElement(statsElement, "crapLoad", statistics.getCrapLoad());
        this.addNumberElement(statsElement, "crapThreshold", statistics.getCrapThreshold());
        this.addNumberElement(statsElement, "globalAverage", statistics.getGlobalAverage());
        this.addNumberElement(statsElement, "globalCraploadAverage", statistics.getGlobalCraploadAverage());
        this.addNumberElement(statsElement, "globalCrapMethodAverage", statistics.getGlobalCrapMethodAverage());
        this.addNumberElement(statsElement, "globalTotalMethodAverage", statistics.getGlobalCrapMethodPercent());
        this.addNumberElement(statsElement, "globalAverageDiff", statistics.getGlobalAverageDiff());
        this.addNumberElement(statsElement, "globalCraploadAverageDiff", statistics.getGlobalCraploadAverageDiff());
        this.addNumberElement(statsElement, "globalCrapMethodAverageDiff", statistics.getGlobalCrapMethodAverageDiff());
        this.addNumberElement(statsElement, "globalTotalMethodAverageDiff", statistics.getGlobalTotalMethodAverageDiff());
        statsElement.addElement("shareStatsUrl").addText("http://127.0.0.1/sharingIsDisabled");
        this.addHistogram(statsElement.addElement("histogram"));
    }

    private void addClassDirectories(Element addElement) {
        addElement.addElement("classDirectory").addText("");
    }

    private void addTestClassDirectories(Element addElement) {
        addElement.addElement("testClassDirectory").addText("");
    }

    private void addSourceDirectories(Element addElement) {
        addElement.addElement("sourceDirectory").addText("");
    }

    private void addLibClasspaths(Element addElement) {
        addElement.addElement("libClasspath").addText("");
    }

    protected void addMethods(Element rootElement, Iterable<MethodCrapData> data) {
        for (MethodCrapData method : data) {
            Element methodElement = rootElement.addElement("method");
            methodElement.addElement("package").addText(method.getPackage());
            methodElement.addElement("className").addText(method.getClassName());
            methodElement.addElement("methodName").addText(method.getMethodName());
            methodElement.addElement("methodSignature").addText(method.getMethodSignature());
            methodElement.addElement("fullMethod").addText(method.getFullMethod());
            methodElement.addElement("crap").addText(String.valueOf(method.getCrap()));
            methodElement.addElement("complexity").addText(String.valueOf(method.getComplexity()));
            methodElement.addElement("coverage").addText(String.valueOf(method.getCoverage() * 100.0));
            methodElement.addElement("crapLoad").addText(String.valueOf(method.getCrapLoad()));
        }
    }

    private static class HistogramBar {
        private final String place;
        private final int value;
        private final double height;

        public HistogramBar(String place, int value, double height) {
            this.place = place;
            this.value = value;
            this.height = height;
        }

        public void appendToElement(Element parent) {
            Element element = parent.addElement("hist");
            element.addElement("place").addText(this.place);
            element.addElement("value").addText(String.valueOf(this.value));
            element.addElement("height").addText(String.valueOf(this.height) + "px");
        }
    }
}

