/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.spi;

import java.util.Map;
import javax.measure.Dimension;
import tech.units.indriya.function.AbstractConverter;
import tech.units.indriya.spi.StandardModel;
import tech.units.indriya.unit.UnitDimension;

public abstract class DimensionalModel {
    private static DimensionalModel currentModel = new StandardModel();

    public static DimensionalModel current() {
        return currentModel;
    }

    protected static void setCurrent(DimensionalModel model) {
        currentModel = model;
    }

    protected DimensionalModel() {
    }

    public Dimension getFundamentalDimension(Dimension dimension) {
        Map<? extends Dimension, Integer> dimensions = dimension.getBaseDimensions();
        if (dimensions == null) {
            return dimension;
        }
        Dimension fundamentalProduct = UnitDimension.NONE;
        for (Map.Entry<? extends Dimension, Integer> e2 : dimensions.entrySet()) {
            fundamentalProduct = fundamentalProduct.multiply(this.getFundamentalDimension(e2.getKey())).pow(e2.getValue());
        }
        return fundamentalProduct;
    }

    public AbstractConverter getDimensionalTransform(Dimension dimension) {
        Map<? extends Dimension, Integer> dimensions = dimension.getBaseDimensions();
        if (dimensions == null) {
            return AbstractConverter.IDENTITY;
        }
        AbstractConverter toFundamental = AbstractConverter.IDENTITY;
        for (Map.Entry<? extends Dimension, Integer> e2 : dimensions.entrySet()) {
            AbstractConverter cvtr = this.getDimensionalTransform(e2.getKey());
            if (!cvtr.isLinear()) {
                throw new UnsupportedOperationException("Non-linear dimensional transform");
            }
            int pow = e2.getValue();
            if (pow < 0) {
                pow = -pow;
                cvtr = cvtr.inverse();
            }
            for (int j2 = 0; j2 < pow; ++j2) {
                toFundamental = (AbstractConverter)toFundamental.concatenate(cvtr);
            }
        }
        return toFundamental;
    }
}

