/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.spi;

import java.time.Instant;
import javax.measure.Quantity;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.spi.Measurement;
import tech.uom.lib.common.util.NumberComparator;

abstract class AbstractMeasurement<Q extends Quantity<Q>>
implements Measurement<Q>,
Comparable<Measurement<Q>> {
    private static final long serialVersionUID = 2417644773551236879L;
    private final Quantity<Q> quantity;
    private final Instant instant;

    protected AbstractMeasurement(Quantity<Q> q2, Instant i2) {
        this.quantity = q2;
        this.instant = i2;
    }

    protected AbstractMeasurement(Quantity<Q> q2, long t2) {
        this(q2, Instant.ofEpochMilli(t2));
    }

    protected AbstractMeasurement(Quantity<Q> q2) {
        this(q2, System.currentTimeMillis());
    }

    @Override
    public Quantity<Q> getQuantity() {
        return this.quantity;
    }

    @Override
    public final Instant getInstant() {
        return this.instant;
    }

    @Override
    public final long getTimestamp() {
        return this.instant.toEpochMilli();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        AbstractMeasurement that = (AbstractMeasurement)o2;
        return this.quantity.equals(that.quantity) && this.instant.equals(that.instant);
    }

    public int hashCode() {
        int result = this.quantity.hashCode();
        result = 31 * result + this.instant.hashCode();
        return result;
    }

    public String toString() {
        return "Measurement{quantity=" + this.quantity + ", instant=" + this.instant + '}';
    }

    static final class DefaultComparable<Q extends Quantity<Q>>
    extends AbstractMeasurement<Q> {
        private static final long serialVersionUID = -175450754835481596L;

        protected DefaultComparable(ComparableQuantity q2, Instant i2) {
            super(q2, i2);
        }

        protected DefaultComparable(ComparableQuantity q2, long t2) {
            super(q2, t2);
        }

        protected DefaultComparable(ComparableQuantity q2) {
            super(q2);
        }

        @Override
        public ComparableQuantity<Q> getQuantity() {
            return (ComparableQuantity)super.getQuantity();
        }

        @Override
        public int compareTo(Measurement<Q> m2) {
            if (m2 instanceof DefaultComparable) {
                return this.getQuantity().compareTo(m2.getQuantity()) + this.getInstant().compareTo(m2.getInstant());
            }
            return 0;
        }
    }

    static final class Default<Q extends Quantity<Q>>
    extends AbstractMeasurement<Q> {
        private static final long serialVersionUID = 823899472806334856L;

        protected Default(Quantity q2, Instant i2) {
            super(q2, i2);
        }

        protected Default(Quantity q2, long t2) {
            super(q2, t2);
        }

        protected Default(Quantity q2) {
            super(q2);
        }

        @Override
        public int compareTo(Measurement<Q> m2) {
            if (this.getQuantity().getUnit() instanceof AbstractUnit) {
                return ((AbstractUnit)this.getQuantity().getUnit()).compareTo(m2.getQuantity().getUnit()) + NumberComparator.getInstance().compare(this.getQuantity().getValue(), m2.getQuantity().getValue()) + this.getInstant().compareTo(m2.getInstant());
            }
            return NumberComparator.getInstance().compare(this.getQuantity().getValue(), m2.getQuantity().getValue()) + this.getInstant().compareTo(m2.getInstant());
        }
    }
}

