/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.function;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import tech.units.indriya.function.Calculus;

public final class RationalNumber
extends Number {
    private static final long serialVersionUID = 1L;
    private final Object $lock1 = new Object[0];
    private final Object $lock2 = new Object[0];
    private final int signum;
    private final BigInteger absDividend;
    private final BigInteger absDivisor;
    private final int hashCode;
    private final boolean isInteger;
    private transient BigDecimal divisionResult;
    private transient Long longValue;
    public static char DIVISION_CHARACTER = (char)247;
    public static final RationalNumber ZERO = RationalNumber.ofInteger(BigInteger.ZERO);
    public static final RationalNumber ONE = RationalNumber.ofInteger(BigInteger.ONE);

    public static RationalNumber ofInteger(long number) {
        return RationalNumber.ofInteger(BigInteger.valueOf(number));
    }

    public static RationalNumber ofInteger(BigInteger number) {
        Objects.requireNonNull(number);
        return new RationalNumber(number.signum(), number.abs(), BigInteger.ONE);
    }

    public static RationalNumber of(long dividend, long divisor) {
        return RationalNumber.of(BigInteger.valueOf(dividend), BigInteger.valueOf(divisor));
    }

    public static RationalNumber of(double number) {
        BigDecimal decimalValue = BigDecimal.valueOf(number);
        return RationalNumber.of(decimalValue);
    }

    public static RationalNumber of(BigDecimal decimalValue) {
        Objects.requireNonNull(decimalValue);
        int scale = decimalValue.scale();
        if (scale <= 0) {
            return RationalNumber.ofInteger(decimalValue.toBigIntegerExact());
        }
        BigInteger dividend = decimalValue.unscaledValue();
        BigInteger divisor = BigInteger.TEN.pow(scale);
        return RationalNumber.of(dividend, divisor);
    }

    public static RationalNumber of(BigInteger dividend, BigInteger divisor) {
        int signumDivisor;
        Objects.requireNonNull(dividend);
        Objects.requireNonNull(divisor);
        if (BigInteger.ONE.equals(divisor)) {
            return RationalNumber.ofInteger(dividend);
        }
        if (BigInteger.ZERO.equals(divisor)) {
            throw new IllegalArgumentException("cannot initalize a rational number with divisor equal to ZERO");
        }
        int signumDividend = dividend.signum();
        int signum = signumDividend * (signumDivisor = divisor.signum());
        if (signum == 0) {
            return ZERO;
        }
        BigInteger absDividend = dividend.abs();
        BigInteger absDivisor = divisor.abs();
        BigInteger gcd = absDividend.gcd(absDivisor);
        return new RationalNumber(signum, absDividend.divide(gcd), absDivisor.divide(gcd));
    }

    private RationalNumber(int signum, BigInteger absDividend, BigInteger absDivisor) {
        this.signum = signum;
        this.absDividend = absDividend;
        this.absDivisor = absDivisor;
        this.hashCode = Objects.hash(signum, absDividend, absDivisor);
        this.isInteger = BigInteger.ONE.equals(absDivisor);
    }

    public BigInteger getDividend() {
        return this.signum < 0 ? this.absDividend.negate() : this.absDividend;
    }

    public BigInteger getDivisor() {
        return this.absDivisor;
    }

    public boolean isInteger() {
        return this.isInteger;
    }

    public int signum() {
        return this.signum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal bigDecimalValue() {
        Object object = this.$lock1;
        synchronized (object) {
            if (this.divisionResult == null) {
                this.divisionResult = new BigDecimal(this.absDividend).divide(new BigDecimal(this.absDivisor), Calculus.MATH_CONTEXT);
                if (this.signum < 0) {
                    this.divisionResult = this.divisionResult.negate();
                }
            }
        }
        return this.divisionResult;
    }

    public RationalNumber add(RationalNumber that) {
        BigInteger a2 = this.absDividend;
        BigInteger b2 = this.absDivisor;
        BigInteger c2 = that.absDividend;
        BigInteger d2 = that.absDivisor;
        if (this.signum < 0) {
            a2 = a2.negate();
        }
        if (that.signum < 0) {
            c2 = c2.negate();
        }
        return RationalNumber.of(a2.multiply(d2).add(b2.multiply(c2)), b2.multiply(d2));
    }

    public RationalNumber subtract(RationalNumber that) {
        return this.add(that.negate());
    }

    public RationalNumber multiply(RationalNumber that) {
        int productSignum = this.signum * that.signum;
        if (productSignum == 0) {
            return ZERO;
        }
        BigInteger a2 = this.absDividend;
        BigInteger b2 = this.absDivisor;
        BigInteger c2 = that.absDividend;
        BigInteger d2 = that.absDivisor;
        BigInteger ac2 = a2.multiply(c2);
        BigInteger bd = b2.multiply(d2);
        BigInteger gcd = ac2.gcd(bd);
        return new RationalNumber(productSignum, ac2.divide(gcd), bd.divide(gcd));
    }

    public RationalNumber divide(RationalNumber that) {
        return this.multiply(that.reciprocal());
    }

    public RationalNumber negate() {
        return new RationalNumber(-this.signum, this.absDividend, this.absDivisor);
    }

    public RationalNumber reciprocal() {
        return new RationalNumber(this.signum, this.absDivisor, this.absDividend);
    }

    public RationalNumber pow(int exponent) {
        boolean isExponentEven;
        if (exponent == 0) {
            if (this.signum == 0) {
                throw new ArithmeticException("0^0 is not defined");
            }
            return ONE;
        }
        if (this.signum == 0) {
            return ZERO;
        }
        boolean bl = isExponentEven = (exponent & 1) == 0;
        int newSignum = this.signum < 0 ? (isExponentEven ? 1 : -1) : 1;
        if (exponent > 0) {
            return new RationalNumber(newSignum, this.absDividend.pow(exponent), this.absDivisor.pow(exponent));
        }
        return new RationalNumber(newSignum, this.absDivisor.pow(exponent), this.absDividend.pow(exponent));
    }

    public RationalNumber abs() {
        return this.signum < 0 ? new RationalNumber(1, this.absDividend, this.absDivisor) : this;
    }

    public int compareTo(RationalNumber that) {
        int comp = Integer.compare(this.signum, that.signum);
        if (comp != 0) {
            return comp;
        }
        if (comp == 0 && this.signum == 0) {
            return 0;
        }
        BigInteger a2 = this.absDividend;
        BigInteger b2 = this.absDivisor;
        BigInteger c2 = that.absDividend;
        BigInteger d2 = that.absDivisor;
        BigInteger ad2 = a2.multiply(d2);
        BigInteger bc = b2.multiply(c2);
        int absCompare = ad2.compareTo(bc);
        return this.signum > 0 ? absCompare : -absCompare;
    }

    @Override
    public int intValue() {
        return (int)this.longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long longValue() {
        Object object = this.$lock2;
        synchronized (object) {
            if (this.longValue == null) {
                this.longValue = this.signum() < 0 ? this.absDividend.negate().divide(this.absDivisor).longValue() : this.absDividend.divide(this.absDivisor).longValue();
            }
        }
        return this.longValue;
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public double doubleValue() {
        return this.bigDecimalValue().doubleValue();
    }

    private String layoutChars(boolean useFractionalRepresentation, char divisionCharacter) {
        if (this.signum == 0) {
            return "0";
        }
        if (this.isInteger) {
            return this.getDividend().toString();
        }
        if (useFractionalRepresentation) {
            return this.getDividend().toString() + divisionCharacter + this.absDivisor;
        }
        return String.valueOf(this.bigDecimalValue());
    }

    public String toString() {
        return this.layoutChars(false, DIVISION_CHARACTER);
    }

    public String toRationalString() {
        return this.layoutChars(true, DIVISION_CHARACTER);
    }

    public String toRationalString(char divisionCharacter) {
        return this.layoutChars(true, divisionCharacter);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object x2) {
        if (x2 == this) {
            return true;
        }
        if (!(x2 instanceof RationalNumber)) {
            return false;
        }
        RationalNumber other = (RationalNumber)x2;
        return Objects.equals(this.bigDecimalValue(), other.bigDecimalValue());
    }
}

