/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.streams;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;

public final class LimitedOutputStream
extends OutputStream {
    private final OutputStream delegate;
    private long remaining;

    public LimitedOutputStream(OutputStream delegate, long size) {
        this.delegate = delegate;
        this.remaining = size;
    }

    @Override
    public void write(int b2) throws IOException {
        long remaining = this.remaining;
        if (remaining < 1L) {
            throw LimitedOutputStream.notEnoughSpace();
        }
        this.delegate.write(b2);
        this.remaining = remaining - 1L;
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        long remaining = this.remaining;
        if (remaining < (long)len) {
            throw LimitedOutputStream.notEnoughSpace();
        }
        try {
            this.delegate.write(b2, off, len);
            this.remaining = remaining - (long)len;
        }
        catch (InterruptedIOException e2) {
            this.remaining = remaining - ((long)e2.bytesTransferred & 0xFFFFFFFFL);
            throw e2;
        }
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    private static IOException notEnoughSpace() {
        return new IOException("Not enough space in output stream");
    }
}

