/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.streams;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xnio.Bits;
import org.xnio.Buffers;
import org.xnio._private.Messages;
import org.xnio.channels.Channels;
import org.xnio.channels.StreamSourceChannel;

public class BufferedChannelInputStream
extends InputStream {
    private final StreamSourceChannel channel;
    private final ByteBuffer buffer;
    private volatile int flags;
    private volatile long timeout;
    private static final AtomicIntegerFieldUpdater<BufferedChannelInputStream> flagsUpdater = AtomicIntegerFieldUpdater.newUpdater(BufferedChannelInputStream.class, "flags");
    private static final int FLAG_EOF = 2;
    private static final int FLAG_ENTERED = 1;

    public BufferedChannelInputStream(StreamSourceChannel channel, int bufferSize) {
        if (channel == null) {
            throw Messages.msg.nullParameter("channel");
        }
        if (bufferSize < 1) {
            throw Messages.msg.parameterOutOfRange("bufferSize");
        }
        this.channel = channel;
        this.buffer = ByteBuffer.allocate(bufferSize);
        this.buffer.limit(0);
    }

    public BufferedChannelInputStream(StreamSourceChannel channel, int bufferSize, long timeout, TimeUnit unit) {
        if (channel == null) {
            throw Messages.msg.nullParameter("channel");
        }
        if (unit == null) {
            throw Messages.msg.nullParameter("unit");
        }
        if (bufferSize < 1) {
            throw Messages.msg.parameterOutOfRange("bufferSize");
        }
        if (timeout < 0L) {
            throw Messages.msg.parameterOutOfRange("timeout");
        }
        this.channel = channel;
        this.buffer = ByteBuffer.allocate(bufferSize);
        this.buffer.limit(0);
        long calcTimeout = unit.toNanos(timeout);
        this.timeout = timeout == 0L ? 0L : (calcTimeout < 1L ? 1L : calcTimeout);
    }

    private boolean enter() {
        int old = this.flags;
        do {
            if (!Bits.allAreSet(old, 1)) continue;
            throw Messages.msg.concurrentAccess();
        } while (!flagsUpdater.compareAndSet(this, old, old | 1));
        return Bits.allAreSet(old, 2);
    }

    private void exit(boolean setEof) {
        int newFlags;
        int oldFlags;
        do {
            oldFlags = this.flags;
            newFlags = oldFlags & 0xFFFFFFFE;
            if (!setEof) continue;
            newFlags |= 2;
        } while (!flagsUpdater.compareAndSet(this, oldFlags, newFlags));
    }

    public long getReadTimeout(TimeUnit unit) {
        if (unit == null) {
            throw Messages.msg.nullParameter("unit");
        }
        return unit.convert(this.timeout, TimeUnit.NANOSECONDS);
    }

    public void setReadTimeout(long timeout, TimeUnit unit) {
        if (timeout < 0L) {
            throw Messages.msg.parameterOutOfRange("timeout");
        }
        if (unit == null) {
            throw Messages.msg.nullParameter("unit");
        }
        long calcTimeout = unit.toNanos(timeout);
        this.timeout = timeout == 0L ? 0L : (calcTimeout < 1L ? 1L : calcTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        boolean eof = this.enter();
        try {
            StreamSourceChannel channel = this.channel;
            ByteBuffer buffer = this.buffer;
            if (buffer.hasRemaining()) {
                int n2 = buffer.get() & 0xFF;
                return n2;
            }
            if (eof) {
                int n3 = -1;
                return n3;
            }
            long start = System.nanoTime();
            long elapsed = 0L;
            while (true) {
                int res;
                buffer.clear();
                try {
                    res = channel.read(buffer);
                }
                finally {
                    buffer.flip();
                }
                if (res == -1) {
                    eof = true;
                    int n4 = -1;
                    return n4;
                }
                if (res > 0) {
                    int n5 = buffer.get() & 0xFF;
                    return n5;
                }
                long timeout = this.timeout;
                if (timeout == 0L) {
                    channel.awaitReadable();
                } else {
                    if (timeout < elapsed) {
                        throw Messages.msg.readTimeout();
                    }
                    channel.awaitReadable(timeout - elapsed, TimeUnit.NANOSECONDS);
                }
                elapsed = System.nanoTime() - start;
            }
        }
        finally {
            this.exit(eof);
        }
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        if (len < 1) {
            return 0;
        }
        boolean eof = this.enter();
        try {
            int total = 0;
            ByteBuffer buffer = this.buffer;
            ByteBuffer userBuffer = ByteBuffer.wrap(b2, off, len);
            if (buffer.hasRemaining()) {
                total += Buffers.copy(userBuffer, buffer);
                if (!userBuffer.hasRemaining()) {
                    int n2 = total;
                    return n2;
                }
            }
            assert (!buffer.hasRemaining());
            assert (userBuffer.hasRemaining());
            if (eof) {
                int n3 = total == 0 ? -1 : total;
                return n3;
            }
            StreamSourceChannel channel = this.channel;
            long start = System.nanoTime();
            long elapsed = 0L;
            while (true) {
                int res;
                if ((res = channel.read(userBuffer)) == -1) {
                    eof = true;
                    int n4 = total == 0 ? -1 : total;
                    return n4;
                }
                if ((total += res) > 0) {
                    int n5 = total;
                    return n5;
                }
                long timeout = this.timeout;
                try {
                    if (timeout == 0L) {
                        channel.awaitReadable();
                    } else {
                        if (timeout < elapsed) {
                            throw Messages.msg.readTimeout();
                        }
                        channel.awaitReadable(timeout - elapsed, TimeUnit.NANOSECONDS);
                    }
                }
                catch (InterruptedIOException e2) {
                    e2.bytesTransferred = total;
                    throw e2;
                }
                elapsed = System.nanoTime() - start;
            }
        }
        finally {
            this.exit(eof);
        }
    }

    @Override
    public long skip(long n2) throws IOException {
        if (n2 < 1L) {
            return 0L;
        }
        boolean eof = this.enter();
        try {
            n2 = Math.min(n2, Integer.MAX_VALUE);
            long total = 0L;
            ByteBuffer buffer = this.buffer;
            if (buffer.hasRemaining()) {
                int cnt = (int)Math.min((long)buffer.remaining(), n2);
                Buffers.skip(buffer, cnt);
                total += (long)cnt;
                assert ((n2 -= (long)cnt) == 0L || !buffer.hasRemaining());
                if (n2 == 0L) {
                    long l2 = total;
                    return l2;
                }
            }
            assert (!buffer.hasRemaining());
            if (eof) {
                long cnt = total;
                return cnt;
            }
            long start = System.nanoTime();
            long elapsed = 0L;
            while (true) {
                if (n2 == 0L) {
                    long l3 = total;
                    return l3;
                }
                long res = Channels.drain(this.channel, n2);
                if (res == -1L) {
                    long l4 = total;
                    return l4;
                }
                if (res == 0L) {
                    long timeout = this.timeout;
                    try {
                        if (timeout == 0L) {
                            this.channel.awaitReadable();
                        } else {
                            if (timeout < elapsed) {
                                throw Messages.msg.readTimeout();
                            }
                            this.channel.awaitReadable(timeout - elapsed, TimeUnit.NANOSECONDS);
                        }
                    }
                    catch (InterruptedIOException e2) {
                        assert (total < Integer.MAX_VALUE);
                        e2.bytesTransferred = (int)total;
                        throw e2;
                    }
                    elapsed = System.nanoTime() - start;
                    continue;
                }
                total += res;
                n2 -= res;
            }
        }
        finally {
            this.exit(eof);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        boolean eof = this.enter();
        try {
            ByteBuffer buffer = this.buffer;
            int rem = buffer.remaining();
            if (rem > 0 || eof) {
                int n2 = rem;
                return n2;
            }
            buffer.clear();
            try {
                this.channel.read(buffer);
            }
            catch (IOException e2) {
                throw e2;
            }
            finally {
                buffer.flip();
            }
            int n3 = buffer.remaining();
            return n3;
        }
        finally {
            this.exit(eof);
        }
    }

    @Override
    public void close() throws IOException {
        this.enter();
        try {
            this.buffer.clear().flip();
            this.channel.shutdownReads();
        }
        finally {
            this.exit(true);
        }
    }
}

