/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.wildfly.common.Assert;
import org.wildfly.common.cpu.CacheInfo;
import org.wildfly.common.function.ExceptionBiConsumer;
import org.wildfly.common.function.ExceptionBiFunction;
import org.wildfly.common.function.ExceptionConsumer;
import org.wildfly.common.function.ExceptionFunction;
import org.wildfly.common.function.ExceptionRunnable;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.common.function.Functions;
import org.xnio.Buffers;

public abstract class ByteBufferPool {
    private static final boolean sliceLargeBuffers = Boolean.parseBoolean(System.getProperty("xnio.buffer.slice-large-buffers", "true"));
    private final ConcurrentLinkedQueue<ByteBuffer> masterQueue = new ConcurrentLinkedQueue();
    private final ThreadLocal<Cache> threadLocalCache = ThreadLocal.withInitial(this::getDefaultCache);
    private final Cache defaultCache = new DefaultCache();
    private final int size;
    private final boolean direct;
    public static final int LARGE_SIZE = 0x100000;
    public static final int MEDIUM_SIZE = 8192;
    public static final int SMALL_SIZE = 64;
    static final int CACHE_LINE_SIZE = Math.max(64, CacheInfo.getSmallestDataCacheLineSize());
    public static final ByteBufferPool LARGE_DIRECT = ByteBufferPool.create(0x100000, true);
    public static final ByteBufferPool MEDIUM_DIRECT = sliceLargeBuffers ? ByteBufferPool.subPool(LARGE_DIRECT, 8192) : ByteBufferPool.create(8192, true);
    public static final ByteBufferPool SMALL_DIRECT = ByteBufferPool.subPool(MEDIUM_DIRECT, 64);
    public static final ByteBufferPool LARGE_HEAP = ByteBufferPool.create(0x100000, false);
    public static final ByteBufferPool MEDIUM_HEAP = ByteBufferPool.create(8192, false);
    public static final ByteBufferPool SMALL_HEAP = ByteBufferPool.create(64, false);

    ByteBufferPool(int size, boolean direct) {
        assert (Integer.bitCount(size) == 1);
        assert (size >= 16);
        assert (size <= 0x40000000);
        this.size = size;
        this.direct = direct;
    }

    public ByteBuffer allocate() {
        return this.threadLocalCache.get().allocate();
    }

    public void allocate(ByteBuffer[] array, int offs) {
        this.allocate(array, offs, array.length - offs);
    }

    public void allocate(ByteBuffer[] array, int offs, int len) {
        Assert.checkNotNullParam("array", array);
        Assert.checkArrayBounds(array, offs, len);
        for (int i2 = 0; i2 < len; ++i2) {
            array[offs + i2] = this.allocate();
        }
    }

    public static void free(ByteBuffer buffer) {
        Assert.checkNotNullParam("buffer", buffer);
        int size = buffer.capacity();
        if (Integer.bitCount(size) == 1 && !buffer.isReadOnly()) {
            if (buffer.isDirect()) {
                if (size == 8192) {
                    MEDIUM_DIRECT.doFree(buffer);
                } else if (size == 64) {
                    SMALL_DIRECT.doFree(buffer);
                } else if (size == 0x100000) {
                    LARGE_DIRECT.doFree(buffer);
                }
            } else if (size == 8192) {
                MEDIUM_HEAP.doFree(buffer);
            } else if (size == 64) {
                SMALL_HEAP.doFree(buffer);
            } else if (size == 0x100000) {
                LARGE_HEAP.doFree(buffer);
            }
        }
    }

    public static void free(ByteBuffer[] array, int offs, int len) {
        Assert.checkArrayBounds(array, offs, len);
        for (int i2 = 0; i2 < len; ++i2) {
            ByteBuffer buffer = array[offs + i2];
            if (buffer == null) continue;
            int size = buffer.capacity();
            if (Integer.bitCount(size) == 1 && !buffer.isReadOnly()) {
                if (buffer.isDirect()) {
                    if (!(buffer instanceof MappedByteBuffer)) {
                        if (size == 8192) {
                            MEDIUM_DIRECT.doFree(buffer);
                        } else if (size == 64) {
                            SMALL_DIRECT.doFree(buffer);
                        } else if (size == 0x100000) {
                            LARGE_DIRECT.doFree(buffer);
                        }
                    }
                } else if (size == 8192) {
                    MEDIUM_HEAP.doFree(buffer);
                } else if (size == 64) {
                    SMALL_HEAP.doFree(buffer);
                } else if (size == 0x100000) {
                    LARGE_HEAP.doFree(buffer);
                }
            }
            array[offs + i2] = null;
        }
    }

    public static void zeroAndFree(ByteBuffer buffer) {
        Buffers.zero(buffer);
        ByteBufferPool.free(buffer);
    }

    public boolean isDirect() {
        return this.direct;
    }

    public int getSize() {
        return this.size;
    }

    public void flushCaches() {
        this.threadLocalCache.get().flush();
    }

    public static void flushAllCaches() {
        SMALL_HEAP.flushCaches();
        MEDIUM_HEAP.flushCaches();
        LARGE_HEAP.flushCaches();
        SMALL_DIRECT.flushCaches();
        MEDIUM_DIRECT.flushCaches();
        LARGE_DIRECT.flushCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, U, E extends Exception> void acceptWithCacheEx(int cacheSize, ExceptionBiConsumer<T, U, E> consumer, T param1, U param2) throws E {
        Assert.checkMinimumParameter("cacheSize", 0, cacheSize);
        Assert.checkNotNullParam("consumer", consumer);
        ThreadLocal<Cache> threadLocalCache = this.threadLocalCache;
        Cache parent = threadLocalCache.get();
        if (cacheSize == 0) {
            consumer.accept(param1, param2);
            return;
        }
        if (cacheSize <= 64) {
            Cache cache = cacheSize == 1 ? new OneCache(parent) : (cacheSize == 2 ? new TwoCache(parent) : new MultiCache(parent, cacheSize));
            threadLocalCache.set(cache);
            try {
                consumer.accept(param1, param2);
                return;
            }
            finally {
                threadLocalCache.set(parent);
                cache.destroy();
            }
        }
        MultiCache cache = new MultiCache(parent, 64);
        threadLocalCache.set(cache);
        try {
            this.acceptWithCacheEx(cacheSize - 64, consumer, param1, param2);
            return;
        }
        finally {
            cache.destroy();
        }
    }

    public <T, E extends Exception> void acceptWithCacheEx(int cacheSize, ExceptionConsumer<T, E> consumer, T param) throws E {
        Assert.checkNotNullParam("consumer", consumer);
        this.acceptWithCacheEx(cacheSize, Functions.exceptionConsumerBiConsumer(), consumer, param);
    }

    public <E extends Exception> void runWithCacheEx(int cacheSize, ExceptionRunnable<E> runnable) throws E {
        Assert.checkNotNullParam("runnable", runnable);
        this.acceptWithCacheEx(cacheSize, Functions.exceptionRunnableConsumer(), runnable);
    }

    public void runWithCache(int cacheSize, Runnable runnable) {
        Assert.checkNotNullParam("runnable", runnable);
        this.acceptWithCacheEx(cacheSize, Runnable::run, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, U, R, E extends Exception> R applyWithCacheEx(int cacheSize, ExceptionBiFunction<T, U, R, E> function, T param1, U param2) throws E {
        Assert.checkMinimumParameter("cacheSize", 0, cacheSize);
        Assert.checkNotNullParam("function", function);
        ThreadLocal<Cache> threadLocalCache = this.threadLocalCache;
        Cache parent = threadLocalCache.get();
        if (cacheSize == 0) {
            return function.apply(param1, param2);
        }
        if (cacheSize <= 64) {
            Cache cache = cacheSize == 1 ? new OneCache(parent) : (cacheSize == 2 ? new TwoCache(parent) : new MultiCache(parent, cacheSize));
            threadLocalCache.set(cache);
            try {
                R r2 = function.apply(param1, param2);
                return r2;
            }
            finally {
                threadLocalCache.set(parent);
                cache.destroy();
            }
        }
        MultiCache cache = new MultiCache(parent, 64);
        threadLocalCache.set(cache);
        try {
            R r3 = this.applyWithCacheEx(cacheSize - 64, function, param1, param2);
            return r3;
        }
        finally {
            cache.destroy();
        }
    }

    public <T, R, E extends Exception> R applyWithCacheEx(int cacheSize, ExceptionFunction<T, R, E> function, T param) throws E {
        return this.applyWithCacheEx(cacheSize, Functions.exceptionFunctionBiFunction(), function, param);
    }

    public <R, E extends Exception> R getWithCacheEx(int cacheSize, ExceptionSupplier<R, E> supplier) throws E {
        return this.applyWithCacheEx(cacheSize, Functions.exceptionSupplierFunction(), supplier);
    }

    Cache getDefaultCache() {
        return this.defaultCache;
    }

    ConcurrentLinkedQueue<ByteBuffer> getMasterQueue() {
        return this.masterQueue;
    }

    private ByteBuffer allocateMaster() {
        ByteBuffer byteBuffer = this.masterQueue.poll();
        if (byteBuffer == null) {
            byteBuffer = this.createBuffer();
        }
        return byteBuffer;
    }

    static ByteBufferPool create(int size, boolean direct) {
        assert (Integer.bitCount(size) == 1);
        assert (size >= 16);
        assert (size <= 0x40000000);
        return new ByteBufferPool(size, direct){

            @Override
            ByteBuffer createBuffer() {
                return this.isDirect() ? ByteBuffer.allocateDirect(this.getSize()) : ByteBuffer.allocate(this.getSize());
            }
        };
    }

    static ByteBufferPool subPool(final ByteBufferPool parent, int size) {
        assert (Integer.bitCount(size) == 1);
        assert (Integer.bitCount(parent.getSize()) == 1);
        assert (size >= 16);
        assert (size < parent.getSize());
        assert (parent.getSize() % size == 0);
        return new ByteBufferPool(size, parent.isDirect()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            ByteBuffer createBuffer() {
                2 var1_1 = this;
                synchronized (var1_1) {
                    ByteBuffer appearing = this.getMasterQueue().poll();
                    if (appearing != null) {
                        return appearing;
                    }
                    ByteBuffer parentBuffer = parent.allocate();
                    int size = this.getSize();
                    ByteBuffer result = Buffers.slice(parentBuffer, size);
                    while (parentBuffer.hasRemaining()) {
                        if (size < CACHE_LINE_SIZE) {
                            Buffers.skip(parentBuffer, CACHE_LINE_SIZE - size);
                        }
                        super.doFree(Buffers.slice(parentBuffer, size));
                    }
                    return result;
                }
            }
        };
    }

    abstract ByteBuffer createBuffer();

    final void freeMaster(ByteBuffer buffer) {
        this.masterQueue.add(buffer);
    }

    final void doFree(ByteBuffer buffer) {
        assert (buffer.capacity() == this.size);
        assert (buffer.isDirect() == this.direct);
        buffer.clear();
        this.threadLocalCache.get().free(buffer);
    }

    final class DefaultCache
    implements Cache {
        DefaultCache() {
        }

        @Override
        public void free(ByteBuffer bb) {
            ByteBufferPool.this.freeMaster(bb);
        }

        @Override
        public ByteBuffer allocate() {
            return ByteBufferPool.this.allocateMaster();
        }

        @Override
        public void flushBuffer(ByteBuffer bb) {
            this.free(bb);
        }

        @Override
        public void destroy() {
        }

        @Override
        public void flush() {
        }
    }

    static final class MultiCache
    implements Cache {
        private final Cache parent;
        private final ByteBuffer[] cache;
        private final long mask;
        private long availableBits;

        MultiCache(Cache parent, int size) {
            this.parent = parent;
            assert (0 < size && size <= 64);
            this.cache = new ByteBuffer[size];
            this.availableBits = size == 64 ? -1L : (1L << size) - 1L;
            this.mask = this.availableBits;
        }

        @Override
        public void free(ByteBuffer bb) {
            long posn = Long.lowestOneBit((this.availableBits ^ 0xFFFFFFFFFFFFFFFFL) & this.mask);
            if (posn != 0L) {
                int bit = Long.numberOfTrailingZeros(posn);
                this.availableBits |= posn;
                this.cache[bit] = bb;
            } else {
                this.parent.free(bb);
            }
        }

        @Override
        public void flushBuffer(ByteBuffer bb) {
            this.parent.flushBuffer(bb);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ByteBuffer allocate() {
            long posn = Long.lowestOneBit(this.availableBits);
            if (posn != 0L) {
                int bit = Long.numberOfTrailingZeros(posn);
                this.availableBits &= posn ^ 0xFFFFFFFFFFFFFFFFL;
                try {
                    ByteBuffer byteBuffer = this.cache[bit];
                    return byteBuffer;
                }
                finally {
                    this.cache[bit] = null;
                }
            }
            return this.parent.allocate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void destroy() {
            long bits;
            ByteBuffer[] cache = this.cache;
            Cache parent = this.parent;
            try {
                long posn;
                for (bits = (this.availableBits ^ 0xFFFFFFFFFFFFFFFFL) & this.mask; bits != 0L; bits &= posn ^ 0xFFFFFFFFFFFFFFFFL) {
                    posn = Long.lowestOneBit(bits);
                    int bit = Long.numberOfTrailingZeros(posn);
                    parent.free(cache[bit]);
                    cache[bit] = null;
                }
            }
            finally {
                this.availableBits = bits;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() {
            long bits;
            ByteBuffer[] cache = this.cache;
            Cache parent = this.parent;
            try {
                long posn;
                for (bits = (this.availableBits ^ 0xFFFFFFFFFFFFFFFFL) & this.mask; bits != 0L; bits &= posn ^ 0xFFFFFFFFFFFFFFFFL) {
                    posn = Long.lowestOneBit(bits);
                    int bit = Long.numberOfTrailingZeros(posn);
                    this.flushBuffer(cache[bit]);
                    cache[bit] = null;
                }
            }
            finally {
                this.availableBits = bits;
            }
            parent.flush();
        }
    }

    static final class TwoCache
    implements Cache {
        private final Cache parent;
        private ByteBuffer buffer1;
        private ByteBuffer buffer2;

        TwoCache(Cache parent) {
            this.parent = parent;
        }

        @Override
        public void free(ByteBuffer bb) {
            if (this.buffer1 == null) {
                this.buffer1 = bb;
            } else if (this.buffer2 == null) {
                this.buffer2 = bb;
            } else {
                this.parent.free(bb);
            }
        }

        @Override
        public void flushBuffer(ByteBuffer bb) {
            this.parent.flushBuffer(bb);
        }

        @Override
        public ByteBuffer allocate() {
            if (this.buffer1 != null) {
                try {
                    ByteBuffer byteBuffer = this.buffer1;
                    return byteBuffer;
                }
                finally {
                    this.buffer1 = null;
                }
            }
            if (this.buffer2 != null) {
                try {
                    ByteBuffer byteBuffer = this.buffer2;
                    return byteBuffer;
                }
                finally {
                    this.buffer2 = null;
                }
            }
            return this.parent.allocate();
        }

        @Override
        public void destroy() {
            ByteBuffer buffer2;
            Cache parent = this.parent;
            ByteBuffer buffer1 = this.buffer1;
            if (buffer1 != null) {
                parent.free(buffer1);
                this.buffer1 = null;
            }
            if ((buffer2 = this.buffer2) != null) {
                parent.free(buffer2);
                this.buffer2 = null;
            }
        }

        @Override
        public void flush() {
            ByteBuffer buffer2;
            ByteBuffer buffer1 = this.buffer1;
            if (buffer1 != null) {
                this.flushBuffer(buffer1);
                this.buffer1 = null;
            }
            if ((buffer2 = this.buffer2) != null) {
                this.flushBuffer(buffer2);
                this.buffer2 = null;
            }
            this.parent.flush();
        }
    }

    static final class OneCache
    implements Cache {
        private final Cache parent;
        private ByteBuffer buffer;

        OneCache(Cache parent) {
            this.parent = parent;
        }

        @Override
        public void free(ByteBuffer bb) {
            if (this.buffer == null) {
                this.buffer = bb;
            } else {
                this.parent.free(bb);
            }
        }

        @Override
        public void flushBuffer(ByteBuffer bb) {
            this.parent.flushBuffer(bb);
        }

        @Override
        public ByteBuffer allocate() {
            if (this.buffer != null) {
                try {
                    ByteBuffer byteBuffer = this.buffer;
                    return byteBuffer;
                }
                finally {
                    this.buffer = null;
                }
            }
            return this.parent.allocate();
        }

        @Override
        public void destroy() {
            ByteBuffer buffer = this.buffer;
            if (buffer != null) {
                this.buffer = null;
                this.parent.free(buffer);
            }
        }

        @Override
        public void flush() {
            ByteBuffer buffer = this.buffer;
            if (buffer != null) {
                this.buffer = null;
                this.flushBuffer(buffer);
            }
            this.parent.flush();
        }
    }

    static interface Cache {
        public void free(ByteBuffer var1);

        public void flushBuffer(ByteBuffer var1);

        public ByteBuffer allocate();

        public void destroy();

        public void flush();
    }

    public static final class Set {
        private final ByteBufferPool small;
        private final ByteBufferPool normal;
        private final ByteBufferPool large;
        public static final Set DIRECT = new Set(SMALL_DIRECT, MEDIUM_DIRECT, LARGE_DIRECT);
        public static final Set HEAP = new Set(SMALL_HEAP, MEDIUM_HEAP, LARGE_HEAP);

        Set(ByteBufferPool small, ByteBufferPool normal, ByteBufferPool large) {
            this.small = small;
            this.normal = normal;
            this.large = large;
        }

        public ByteBufferPool getSmall() {
            return this.small;
        }

        public ByteBufferPool getNormal() {
            return this.normal;
        }

        public ByteBufferPool getLarge() {
            return this.large;
        }
    }
}

