/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.selector;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.security.BasicPermission;
import java.security.Permission;
import org.wildfly.common.Assert;

public final class SelectorPermission
extends BasicPermission {
    private static final long serialVersionUID = -7156787601824624014L;
    private static final int ACTION_GET = 1;
    private static final int ACTION_SET = 2;
    private static final int ACTION_CHANGE = 4;
    private final int actions;

    public SelectorPermission(String name, String actions) {
        super(name);
        Assert.checkNotNullParam("name", name);
        Assert.checkNotNullParam("actions", actions);
        String[] actionArray = actions.split("\\s*,\\s*");
        int q2 = 0;
        for (String action : actionArray) {
            if (action.equalsIgnoreCase("get")) {
                q2 |= 1;
                continue;
            }
            if (action.equalsIgnoreCase("set")) {
                q2 |= 2;
                continue;
            }
            if (action.equalsIgnoreCase("change")) {
                q2 |= 4;
                continue;
            }
            if (!action.equals("*")) continue;
            q2 |= 7;
            break;
        }
        this.actions = q2;
    }

    @Override
    public String getActions() {
        int maskedActions = this.actions & 7;
        switch (maskedActions) {
            case 0: {
                return "";
            }
            case 1: {
                return "get";
            }
            case 2: {
                return "set";
            }
            case 3: {
                return "get,set";
            }
            case 4: {
                return "change";
            }
            case 5: {
                return "get,change";
            }
            case 6: {
                return "set,change";
            }
            case 7: {
                return "get,set,change";
            }
        }
        throw Assert.impossibleSwitchCase(maskedActions);
    }

    @Override
    public boolean implies(Permission p2) {
        return p2 instanceof SelectorPermission && this.implies((SelectorPermission)p2);
    }

    public boolean implies(SelectorPermission p2) {
        return p2 != null && (p2.actions & this.actions) == p2.actions && super.implies(p2);
    }

    @Override
    public boolean equals(Object p2) {
        return p2 instanceof SelectorPermission && this.equals((SelectorPermission)p2);
    }

    public boolean equals(SelectorPermission p2) {
        return p2 != null && p2.actions == this.actions && super.equals(p2);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        int actions = this.actions;
        if ((actions & 7) != actions) {
            throw new InvalidObjectException("Invalid permission actions");
        }
    }
}

