/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.ref;

import java.lang.ref.ReferenceQueue;
import org.wildfly.common.ref.Reapable;
import org.wildfly.common.ref.Reaper;
import org.wildfly.common.ref.Reference;
import org.wildfly.common.ref.References;

public class PhantomReference<T, A>
extends java.lang.ref.PhantomReference<T>
implements Reference<T, A>,
Reapable<T, A> {
    private final A attachment;
    private final Reaper<T, A> reaper;

    public PhantomReference(T referent, A attachment, ReferenceQueue<? super T> q2) {
        super(referent, q2);
        this.attachment = attachment;
        this.reaper = null;
    }

    public PhantomReference(T referent, A attachment, Reaper<T, A> reaper) {
        super(referent, References.ReaperThread.REAPER_QUEUE);
        this.reaper = reaper;
        this.attachment = attachment;
    }

    @Override
    public A getAttachment() {
        return this.attachment;
    }

    @Override
    public Reference.Type getType() {
        return Reference.Type.PHANTOM;
    }

    @Override
    public Reaper<T, A> getReaper() {
        return this.reaper;
    }

    public String toString() {
        return "phantom reference";
    }
}

