/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.iteration;

import java.util.NoSuchElementException;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.common.iteration.CodePointIterator;

class Utf8DecodingIterator
extends CodePointIterator {
    private final ByteIterator iter;
    private long offset = 0L;

    Utf8DecodingIterator(ByteIterator iter) {
        this.iter = iter;
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public boolean hasPrevious() {
        return this.offset > 0L;
    }

    private void seekToNext() {
        while (this.iter.hasNext()) {
            int b2 = this.iter.next();
            if ((b2 & 0xC0) == 128) continue;
            this.iter.previous();
            return;
        }
    }

    private void seekToPrev() {
        while (this.iter.hasPrevious()) {
            int b2 = this.iter.previous();
            if ((b2 & 0xC0) == 128) continue;
            return;
        }
    }

    @Override
    public int next() {
        if (!this.iter.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.offset;
        int a2 = this.iter.next();
        if ((a2 & 0x80) == 0) {
            return a2;
        }
        if ((a2 & 0xC0) == 128) {
            this.seekToNext();
            return 65533;
        }
        if (!this.iter.hasNext()) {
            return 65533;
        }
        int b2 = this.iter.next();
        if ((b2 & 0xC0) != 128) {
            this.seekToNext();
            return 65533;
        }
        if ((a2 & 0xE0) == 192) {
            return (a2 & 0x1F) << 6 | b2 & 0x3F;
        }
        if (!this.iter.hasNext()) {
            return 65533;
        }
        int c2 = this.iter.next();
        if ((c2 & 0xC0) != 128) {
            this.seekToNext();
            return 65533;
        }
        if ((a2 & 0xF0) == 224) {
            return (a2 & 0xF) << 12 | (b2 & 0x3F) << 6 | c2 & 0x3F;
        }
        if (!this.iter.hasNext()) {
            return 65533;
        }
        int d2 = this.iter.next();
        if ((d2 & 0xC0) != 128) {
            this.seekToNext();
            return 65533;
        }
        if ((a2 & 0xF8) == 240) {
            return (a2 & 7) << 18 | (b2 & 0x3F) << 12 | (c2 & 0x3F) << 6 | d2 & 0x3F;
        }
        this.seekToNext();
        return 65533;
    }

    @Override
    public int peekNext() throws NoSuchElementException {
        if (!this.iter.hasNext()) {
            throw new NoSuchElementException();
        }
        int a2 = this.iter.peekNext();
        if ((a2 & 0x80) == 0) {
            return a2;
        }
        if ((a2 & 0xC0) == 128) {
            return 65533;
        }
        this.iter.next();
        if (!this.iter.hasNext()) {
            this.iter.previous();
            return 65533;
        }
        int b2 = this.iter.peekNext();
        if ((b2 & 0xC0) != 128) {
            this.iter.previous();
            return 65533;
        }
        if ((a2 & 0xE0) == 192) {
            this.iter.previous();
            return (a2 & 0x1F) << 6 | b2 & 0x3F;
        }
        this.iter.next();
        if (!this.iter.hasNext()) {
            this.iter.previous();
            this.iter.previous();
            return 65533;
        }
        int c2 = this.iter.peekNext();
        if ((c2 & 0xC0) != 128) {
            this.iter.previous();
            this.iter.previous();
            return 65533;
        }
        if ((a2 & 0xF0) == 224) {
            this.iter.previous();
            this.iter.previous();
            return (a2 & 0xF) << 12 | (b2 & 0x3F) << 6 | c2 & 0x3F;
        }
        this.iter.next();
        if (!this.iter.hasNext()) {
            this.iter.previous();
            this.iter.previous();
            this.iter.previous();
            return 65533;
        }
        int d2 = this.iter.peekNext();
        if ((d2 & 0xC0) != 128) {
            this.iter.previous();
            this.iter.previous();
            this.iter.previous();
            return 65533;
        }
        if ((a2 & 0xF8) == 240) {
            this.iter.previous();
            this.iter.previous();
            this.iter.previous();
            return (a2 & 7) << 18 | (b2 & 0x3F) << 12 | (c2 & 0x3F) << 6 | d2 & 0x3F;
        }
        this.iter.previous();
        this.iter.previous();
        this.iter.previous();
        return 65533;
    }

    @Override
    public int previous() {
        if (!this.iter.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.offset;
        int a2 = this.iter.previous();
        if ((a2 & 0x80) == 0) {
            return a2;
        }
        if ((a2 & 0xC0) != 128) {
            this.seekToPrev();
            return 65533;
        }
        int cp = a2 & 0x3F;
        a2 = this.iter.previous();
        if ((a2 & 0xE0) == 192) {
            return (a2 & 0x1F) << 6 | cp;
        }
        if ((a2 & 0xC0) != 128) {
            this.seekToPrev();
            return 65533;
        }
        cp |= (a2 & 0x3F) << 6;
        a2 = this.iter.previous();
        if ((a2 & 0xF0) == 224) {
            return (a2 & 0xF) << 12 | cp;
        }
        if ((a2 & 0xC0) != 128) {
            this.seekToPrev();
            return 65533;
        }
        cp |= (a2 & 0x3F) << 12;
        a2 = this.iter.previous();
        if ((a2 & 0xF8) == 240) {
            return (a2 & 7) << 18 | cp;
        }
        this.seekToPrev();
        return 65533;
    }

    @Override
    public int peekPrevious() throws NoSuchElementException {
        if (!this.iter.hasPrevious()) {
            throw new NoSuchElementException();
        }
        int a2 = this.iter.peekPrevious();
        if ((a2 & 0x80) == 0) {
            return a2;
        }
        if ((a2 & 0xC0) != 128) {
            return 65533;
        }
        int cp = a2 & 0x3F;
        this.iter.previous();
        a2 = this.iter.peekPrevious();
        if ((a2 & 0xE0) == 192) {
            this.iter.next();
            return (a2 & 0x1F) << 6 | cp;
        }
        if ((a2 & 0xC0) != 128) {
            this.iter.next();
            return 65533;
        }
        cp |= (a2 & 0x3F) << 6;
        this.iter.previous();
        a2 = this.iter.peekPrevious();
        if ((a2 & 0xF0) == 224) {
            this.iter.next();
            this.iter.next();
            return (a2 & 0xF) << 12 | cp;
        }
        if ((a2 & 0xC0) != 128) {
            this.iter.next();
            this.iter.next();
            return 65533;
        }
        cp |= (a2 & 0x3F) << 12;
        this.iter.previous();
        a2 = this.iter.peekPrevious();
        if ((a2 & 0xF8) == 240) {
            this.iter.next();
            this.iter.next();
            this.iter.next();
            return (a2 & 7) << 18 | cp;
        }
        this.iter.next();
        this.iter.next();
        this.iter.next();
        return 65533;
    }

    @Override
    public long getIndex() {
        return this.offset;
    }
}

