/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.iteration;

import java.util.NoSuchElementException;
import java.util.function.IntPredicate;
import org.wildfly.common.iteration.CodePointIterator;

final class SkippingCodePointIterator
extends CodePointIterator {
    private final CodePointIterator iter;
    private final IntPredicate predicate;

    SkippingCodePointIterator(CodePointIterator iter, IntPredicate predicate) {
        this.iter = iter;
        this.predicate = predicate;
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext() && !this.skip(this.peekNext());
    }

    @Override
    public boolean hasPrevious() {
        return this.iter.hasPrevious() && !this.skip(this.peekPrevious());
    }

    @Override
    public int next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.iter.next();
    }

    @Override
    public int peekNext() throws NoSuchElementException {
        if (!this.iter.hasNext()) {
            throw new NoSuchElementException();
        }
        int next = this.seekNext(this.iter.peekNext());
        if (!this.skip(next)) {
            return next;
        }
        return next;
    }

    private int seekNext(int next) throws NoSuchElementException {
        if (!this.iter.hasNext()) {
            return next;
        }
        next = this.iter.next();
        if (this.skip(next)) {
            return this.seekNext(next);
        }
        this.iter.previous();
        return next;
    }

    @Override
    public int previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        return this.iter.previous();
    }

    @Override
    public int peekPrevious() throws NoSuchElementException {
        if (!this.iter.hasPrevious()) {
            throw new NoSuchElementException();
        }
        int prev = this.seekPrev(this.iter.peekPrevious());
        if (!this.skip(prev)) {
            return prev;
        }
        return prev;
    }

    private int seekPrev(int prev) throws NoSuchElementException {
        if (!this.iter.hasPrevious()) {
            return prev;
        }
        prev = this.iter.previous();
        if (this.skip(prev)) {
            return this.seekPrev(prev);
        }
        this.iter.next();
        return prev;
    }

    @Override
    public long getIndex() {
        return this.iter.getIndex();
    }

    private boolean skip(int c2) {
        return this.predicate.test(c2);
    }
}

