/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.array;

import java.lang.reflect.Array;
import java.util.Arrays;

public final class Arrays2 {
    private Arrays2() {
    }

    public static boolean equals(byte[] a1, int offs1, byte[] a2, int offs2, int len) {
        if (offs1 < 0 || offs1 + len > a1.length) {
            return false;
        }
        if (offs2 < 0 || offs2 + len > a2.length) {
            return false;
        }
        for (int i2 = 0; i2 < len; ++i2) {
            if (a1[i2 + offs1] == a2[i2 + offs2]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(byte[] a1, int offs1, byte[] a2) {
        return Arrays2.equals(a1, offs1, a2, 0, a2.length);
    }

    public static boolean equals(char[] a1, int offs1, char[] a2, int offs2, int len) {
        if (offs1 + len > a1.length) {
            return false;
        }
        if (offs2 + len > a2.length) {
            return false;
        }
        for (int i2 = 0; i2 < len; ++i2) {
            if (a1[i2 + offs1] == a2[i2 + offs2]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(char[] a1, int offs1, char[] a2) {
        return Arrays2.equals(a1, offs1, a2, 0, a2.length);
    }

    public static boolean equals(char[] a1, int offs1, String a2, int offs2, int len) {
        if (offs1 + len > a1.length) {
            return false;
        }
        if (offs2 + len > a2.length()) {
            return false;
        }
        for (int i2 = 0; i2 < len; ++i2) {
            if (a1[i2 + offs1] == a2.charAt(i2 + offs2)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(char[] a1, int offs1, String a2) {
        return Arrays2.equals(a1, offs1, a2, 0, a2.length());
    }

    public static boolean equals(String a1, int offs1, char[] a2) {
        return Arrays2.equals(a2, 0, a1, offs1, a2.length);
    }

    public static boolean equals(String a1, char[] a2) {
        return Arrays2.equals(a1, 0, a2);
    }

    @SafeVarargs
    public static <T> T[] of(T ... items) {
        return items;
    }

    private static char hex(int v2) {
        return (char)(v2 < 10 ? 48 + v2 : 97 + v2 - 10);
    }

    public static String toString(byte[] bytes) {
        StringBuilder b2 = new StringBuilder(bytes.length * 2);
        for (byte x2 : bytes) {
            b2.append(Arrays2.hex((x2 & 0xF0) >> 4)).append(Arrays2.hex(x2 & 0xF));
        }
        return b2.toString();
    }

    public static int indexOf(byte[] array, int search, int offs, int len) {
        for (int i2 = 0; i2 < len; ++i2) {
            if (array[offs + i2] != (byte)search) continue;
            return offs + i2;
        }
        return -1;
    }

    public static int indexOf(byte[] array, int search, int offs) {
        return Arrays2.indexOf(array, search, offs, array.length - offs);
    }

    public static int indexOf(byte[] array, int search) {
        return Arrays2.indexOf(array, search, 0, array.length);
    }

    public static <E> E[] createArray(Class<E> elementType, int size) {
        return (Object[])Array.newInstance(elementType, size);
    }

    public static <E> E[] compactNulls(E[] original) {
        E item;
        int r2 = 0;
        while ((item = original[r2++]) != null) {
            if (r2 != original.length) continue;
            return original;
        }
        int w2 = r2 - 1;
        do {
            if ((item = original[r2++]) == null) continue;
            original[w2++] = item;
        } while (r2 != original.length);
        return Arrays.copyOf(original, w2);
    }

    public static String objectToString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Object[]) {
            return Arrays.deepToString((Object[])value);
        }
        if (value.getClass().isArray()) {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            for (int i2 = 0; i2 < Array.getLength(value); ++i2) {
                if (i2 != 0) {
                    sb.append(", ");
                }
                sb.append(String.valueOf(Array.get(value, i2)));
            }
            sb.append(']');
            return sb.toString();
        }
        return value.toString();
    }
}

