/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.archive;

import java.io.InputStream;
import java.nio.ByteBuffer;
import org.wildfly.common.archive.Archive;

final class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer[] bufs;
    private final long offset;
    private final long size;
    long pos;
    long mark;

    ByteBufferInputStream(ByteBuffer[] bufs, long offset, long size) {
        this.bufs = bufs;
        this.offset = offset;
        this.size = size;
    }

    @Override
    public int read() {
        return this.pos < this.size ? (int)Archive.getByte(this.bufs, this.offset + this.pos++) : -1;
    }

    @Override
    public int read(byte[] b2) {
        return this.read(b2, 0, b2.length);
    }

    @Override
    public int read(byte[] b2, int off, int len) {
        long rem = this.size - this.pos;
        if (rem == 0L) {
            return -1;
        }
        int realLen = (int)Math.min((long)len, rem);
        if (realLen > 0) {
            Archive.readBytes(this.bufs, this.offset + this.pos, b2, off, realLen);
            return realLen;
        }
        return 0;
    }

    @Override
    public long skip(long n2) {
        long rem = this.size - this.pos;
        long cnt = Math.min(rem, n2);
        if (cnt > 0L) {
            this.pos += cnt;
            return cnt;
        }
        return 0L;
    }

    @Override
    public int available() {
        return (int)Math.min(Integer.MAX_VALUE, this.size - this.pos);
    }

    @Override
    public void close() {
    }

    @Override
    public void mark(int readLimit) {
        this.mark = this.pos;
    }

    @Override
    public void reset() {
        this.pos = this.mark;
    }

    @Override
    public boolean markSupported() {
        return true;
    }
}

