/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.tz;

import org.joda.time.DateTimeZone;

public class CachedDateTimeZone
extends DateTimeZone {
    private static final long serialVersionUID = 5472298452022250685L;
    private static final int cInfoCacheMask;
    private final DateTimeZone iZone;
    private final transient Info[] iInfoCache = new Info[cInfoCacheMask + 1];

    public static CachedDateTimeZone forZone(DateTimeZone dateTimeZone) {
        if (dateTimeZone instanceof CachedDateTimeZone) {
            return (CachedDateTimeZone)dateTimeZone;
        }
        return new CachedDateTimeZone(dateTimeZone);
    }

    private CachedDateTimeZone(DateTimeZone dateTimeZone) {
        super(dateTimeZone.getID());
        this.iZone = dateTimeZone;
    }

    public DateTimeZone getUncachedZone() {
        return this.iZone;
    }

    public String getNameKey(long l2) {
        return this.getInfo(l2).getNameKey(l2);
    }

    public int getOffset(long l2) {
        return this.getInfo(l2).getOffset(l2);
    }

    public int getStandardOffset(long l2) {
        return this.getInfo(l2).getStandardOffset(l2);
    }

    public boolean isFixed() {
        return this.iZone.isFixed();
    }

    public long nextTransition(long l2) {
        return this.iZone.nextTransition(l2);
    }

    public long previousTransition(long l2) {
        return this.iZone.previousTransition(l2);
    }

    public int hashCode() {
        return this.iZone.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CachedDateTimeZone) {
            return this.iZone.equals(((CachedDateTimeZone)object).iZone);
        }
        return false;
    }

    private Info getInfo(long l2) {
        Info[] infoArray = this.iInfoCache;
        int n2 = (int)(l2 >> 32);
        int n3 = n2 & cInfoCacheMask;
        Info info = infoArray[n3];
        if (info == null || (int)(info.iPeriodStart >> 32) != n2) {
            infoArray[n3] = info = this.createInfo(l2);
        }
        return info;
    }

    private Info createInfo(long l2) {
        long l3;
        long l4 = l2 & 0xFFFFFFFF00000000L;
        Info info = new Info(this.iZone, l4);
        long l5 = l4 | 0xFFFFFFFFL;
        Info info2 = info;
        while ((l3 = this.iZone.nextTransition(l4)) != l4 && l3 <= l5) {
            l4 = l3;
            info2 = info2.iNextInfo = new Info(this.iZone, l4);
        }
        return info;
    }

    static {
        int n2;
        Integer n3;
        try {
            n3 = Integer.getInteger("org.joda.time.tz.CachedDateTimeZone.size");
        }
        catch (SecurityException securityException) {
            n3 = null;
        }
        if (n3 == null) {
            n2 = 512;
        } else {
            n2 = n3;
            --n2;
            int n4 = 0;
            while (n2 > 0) {
                ++n4;
                n2 >>= 1;
            }
            n2 = 1 << n4;
        }
        cInfoCacheMask = n2 - 1;
    }

    private static final class Info {
        public final long iPeriodStart;
        public final DateTimeZone iZoneRef;
        Info iNextInfo;
        private String iNameKey;
        private int iOffset = Integer.MIN_VALUE;
        private int iStandardOffset = Integer.MIN_VALUE;

        Info(DateTimeZone dateTimeZone, long l2) {
            this.iPeriodStart = l2;
            this.iZoneRef = dateTimeZone;
        }

        public String getNameKey(long l2) {
            if (this.iNextInfo == null || l2 < this.iNextInfo.iPeriodStart) {
                if (this.iNameKey == null) {
                    this.iNameKey = this.iZoneRef.getNameKey(this.iPeriodStart);
                }
                return this.iNameKey;
            }
            return this.iNextInfo.getNameKey(l2);
        }

        public int getOffset(long l2) {
            if (this.iNextInfo == null || l2 < this.iNextInfo.iPeriodStart) {
                if (this.iOffset == Integer.MIN_VALUE) {
                    this.iOffset = this.iZoneRef.getOffset(this.iPeriodStart);
                }
                return this.iOffset;
            }
            return this.iNextInfo.getOffset(l2);
        }

        public int getStandardOffset(long l2) {
            if (this.iNextInfo == null || l2 < this.iNextInfo.iPeriodStart) {
                if (this.iStandardOffset == Integer.MIN_VALUE) {
                    this.iStandardOffset = this.iZoneRef.getStandardOffset(this.iPeriodStart);
                }
                return this.iStandardOffset;
            }
            return this.iNextInfo.getStandardOffset(l2);
        }
    }
}

