/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.io;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Map;

public class SerialUtilities {
    private SerialUtilities() {
    }

    public static boolean isSerializable(Class c2) {
        return Serializable.class.isAssignableFrom(c2);
    }

    public static Paint readPaint(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        if (stream == null) {
            throw new IllegalArgumentException("Null 'stream' argument.");
        }
        Paint result = null;
        boolean isNull = stream.readBoolean();
        if (!isNull) {
            Class c2 = (Class)stream.readObject();
            if (SerialUtilities.isSerializable(c2)) {
                result = (Paint)stream.readObject();
            } else if (c2.equals(GradientPaint.class)) {
                float x1 = stream.readFloat();
                float y1 = stream.readFloat();
                Color c1 = (Color)stream.readObject();
                float x2 = stream.readFloat();
                float y2 = stream.readFloat();
                Color c22 = (Color)stream.readObject();
                boolean isCyclic = stream.readBoolean();
                result = new GradientPaint(x1, y1, c1, x2, y2, c22, isCyclic);
            }
        }
        return result;
    }

    public static void writePaint(Paint paint, ObjectOutputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Null 'stream' argument.");
        }
        if (paint != null) {
            stream.writeBoolean(false);
            stream.writeObject(paint.getClass());
            if (paint instanceof Serializable) {
                stream.writeObject(paint);
            } else if (paint instanceof GradientPaint) {
                GradientPaint gp = (GradientPaint)paint;
                stream.writeFloat((float)gp.getPoint1().getX());
                stream.writeFloat((float)gp.getPoint1().getY());
                stream.writeObject(gp.getColor1());
                stream.writeFloat((float)gp.getPoint2().getX());
                stream.writeFloat((float)gp.getPoint2().getY());
                stream.writeObject(gp.getColor2());
                stream.writeBoolean(gp.isCyclic());
            }
        } else {
            stream.writeBoolean(true);
        }
    }

    public static Stroke readStroke(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        if (stream == null) {
            throw new IllegalArgumentException("Null 'stream' argument.");
        }
        Stroke result = null;
        boolean isNull = stream.readBoolean();
        if (!isNull) {
            Class c2 = (Class)stream.readObject();
            if (c2.equals(BasicStroke.class)) {
                float width = stream.readFloat();
                int cap = stream.readInt();
                int join = stream.readInt();
                float miterLimit = stream.readFloat();
                float[] dash = (float[])stream.readObject();
                float dashPhase = stream.readFloat();
                result = new BasicStroke(width, cap, join, miterLimit, dash, dashPhase);
            } else {
                result = (Stroke)stream.readObject();
            }
        }
        return result;
    }

    public static void writeStroke(Stroke stroke, ObjectOutputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Null 'stream' argument.");
        }
        if (stroke != null) {
            stream.writeBoolean(false);
            if (stroke instanceof BasicStroke) {
                BasicStroke s2 = (BasicStroke)stroke;
                stream.writeObject(BasicStroke.class);
                stream.writeFloat(s2.getLineWidth());
                stream.writeInt(s2.getEndCap());
                stream.writeInt(s2.getLineJoin());
                stream.writeFloat(s2.getMiterLimit());
                stream.writeObject(s2.getDashArray());
                stream.writeFloat(s2.getDashPhase());
            } else {
                stream.writeObject(stroke.getClass());
                stream.writeObject(stroke);
            }
        } else {
            stream.writeBoolean(true);
        }
    }

    public static Composite readComposite(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        if (stream == null) {
            throw new IllegalArgumentException("Null 'stream' argument.");
        }
        Composite result = null;
        boolean isNull = stream.readBoolean();
        if (!isNull) {
            Class c2 = (Class)stream.readObject();
            if (SerialUtilities.isSerializable(c2)) {
                result = (Composite)stream.readObject();
            } else if (c2.equals(AlphaComposite.class)) {
                int rule = stream.readInt();
                float alpha = stream.readFloat();
                result = AlphaComposite.getInstance(rule, alpha);
            }
        }
        return result;
    }

    public static void writeComposite(Composite composite, ObjectOutputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Null 'stream' argument.");
        }
        if (composite != null) {
            stream.writeBoolean(false);
            stream.writeObject(composite.getClass());
            if (composite instanceof Serializable) {
                stream.writeObject(composite);
            } else if (composite instanceof AlphaComposite) {
                AlphaComposite ac2 = (AlphaComposite)composite;
                stream.writeInt(ac2.getRule());
                stream.writeFloat(ac2.getAlpha());
            }
        } else {
            stream.writeBoolean(true);
        }
    }

    public static Shape readShape(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        if (stream == null) {
            throw new IllegalArgumentException("Null 'stream' argument.");
        }
        Shape result = null;
        boolean isNull = stream.readBoolean();
        if (!isNull) {
            Class c2 = (Class)stream.readObject();
            if (c2.equals(Line2D.class)) {
                double x1 = stream.readDouble();
                double y1 = stream.readDouble();
                double x2 = stream.readDouble();
                double y2 = stream.readDouble();
                result = new Line2D.Double(x1, y1, x2, y2);
            } else if (c2.equals(Rectangle2D.class)) {
                double x2 = stream.readDouble();
                double y2 = stream.readDouble();
                double w2 = stream.readDouble();
                double h2 = stream.readDouble();
                result = new Rectangle2D.Double(x2, y2, w2, h2);
            } else if (c2.equals(Ellipse2D.class)) {
                double x3 = stream.readDouble();
                double y3 = stream.readDouble();
                double w3 = stream.readDouble();
                double h3 = stream.readDouble();
                result = new Ellipse2D.Double(x3, y3, w3, h3);
            } else if (c2.equals(Arc2D.class)) {
                double x4 = stream.readDouble();
                double y4 = stream.readDouble();
                double w4 = stream.readDouble();
                double h4 = stream.readDouble();
                double as = stream.readDouble();
                double ae2 = stream.readDouble();
                int at = stream.readInt();
                result = new Arc2D.Double(x4, y4, w4, h4, as, ae2, at);
            } else if (c2.equals(GeneralPath.class)) {
                GeneralPath gp = new GeneralPath();
                float[] args = new float[6];
                boolean hasNext = stream.readBoolean();
                while (!hasNext) {
                    int type = stream.readInt();
                    for (int i2 = 0; i2 < 6; ++i2) {
                        args[i2] = stream.readFloat();
                    }
                    switch (type) {
                        case 0: {
                            gp.moveTo(args[0], args[1]);
                            break;
                        }
                        case 1: {
                            gp.lineTo(args[0], args[1]);
                            break;
                        }
                        case 3: {
                            gp.curveTo(args[0], args[1], args[2], args[3], args[4], args[5]);
                            break;
                        }
                        case 2: {
                            gp.quadTo(args[0], args[1], args[2], args[3]);
                            break;
                        }
                        case 4: {
                            gp.closePath();
                            break;
                        }
                        default: {
                            throw new RuntimeException("JFreeChart - No path exists");
                        }
                    }
                    gp.setWindingRule(stream.readInt());
                    hasNext = stream.readBoolean();
                }
                result = gp;
            } else {
                result = (Shape)stream.readObject();
            }
        }
        return result;
    }

    public static void writeShape(Shape shape, ObjectOutputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Null 'stream' argument.");
        }
        if (shape != null) {
            stream.writeBoolean(false);
            if (shape instanceof Line2D) {
                Line2D line = (Line2D)shape;
                stream.writeObject(Line2D.class);
                stream.writeDouble(line.getX1());
                stream.writeDouble(line.getY1());
                stream.writeDouble(line.getX2());
                stream.writeDouble(line.getY2());
            } else if (shape instanceof Rectangle2D) {
                Rectangle2D rectangle = (Rectangle2D)shape;
                stream.writeObject(Rectangle2D.class);
                stream.writeDouble(rectangle.getX());
                stream.writeDouble(rectangle.getY());
                stream.writeDouble(rectangle.getWidth());
                stream.writeDouble(rectangle.getHeight());
            } else if (shape instanceof Ellipse2D) {
                Ellipse2D ellipse = (Ellipse2D)shape;
                stream.writeObject(Ellipse2D.class);
                stream.writeDouble(ellipse.getX());
                stream.writeDouble(ellipse.getY());
                stream.writeDouble(ellipse.getWidth());
                stream.writeDouble(ellipse.getHeight());
            } else if (shape instanceof Arc2D) {
                Arc2D arc = (Arc2D)shape;
                stream.writeObject(Arc2D.class);
                stream.writeDouble(arc.getX());
                stream.writeDouble(arc.getY());
                stream.writeDouble(arc.getWidth());
                stream.writeDouble(arc.getHeight());
                stream.writeDouble(arc.getAngleStart());
                stream.writeDouble(arc.getAngleExtent());
                stream.writeInt(arc.getArcType());
            } else if (shape instanceof GeneralPath) {
                stream.writeObject(GeneralPath.class);
                PathIterator pi = shape.getPathIterator(null);
                float[] args = new float[6];
                stream.writeBoolean(pi.isDone());
                while (!pi.isDone()) {
                    int type = pi.currentSegment(args);
                    stream.writeInt(type);
                    for (int i2 = 0; i2 < 6; ++i2) {
                        stream.writeFloat(args[i2]);
                    }
                    stream.writeInt(pi.getWindingRule());
                    pi.next();
                    stream.writeBoolean(pi.isDone());
                }
            } else {
                stream.writeObject(shape.getClass());
                stream.writeObject(shape);
            }
        } else {
            stream.writeBoolean(true);
        }
    }

    public static Point2D readPoint2D(ObjectInputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Null 'stream' argument.");
        }
        Point2D.Double result = null;
        boolean isNull = stream.readBoolean();
        if (!isNull) {
            double x2 = stream.readDouble();
            double y2 = stream.readDouble();
            result = new Point2D.Double(x2, y2);
        }
        return result;
    }

    public static void writePoint2D(Point2D p2, ObjectOutputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Null 'stream' argument.");
        }
        if (p2 != null) {
            stream.writeBoolean(false);
            stream.writeDouble(p2.getX());
            stream.writeDouble(p2.getY());
        } else {
            stream.writeBoolean(true);
        }
    }

    public static AttributedString readAttributedString(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        if (stream == null) {
            throw new IllegalArgumentException("Null 'stream' argument.");
        }
        AttributedString result = null;
        boolean isNull = stream.readBoolean();
        if (!isNull) {
            String plainStr = (String)stream.readObject();
            result = new AttributedString(plainStr);
            char c2 = stream.readChar();
            int start = 0;
            while (c2 != '\uffff') {
                int limit = stream.readInt();
                Map atts = (Map)stream.readObject();
                result.addAttributes(atts, start, limit);
                start = limit;
                c2 = stream.readChar();
            }
        }
        return result;
    }

    public static void writeAttributedString(AttributedString as, ObjectOutputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Null 'stream' argument.");
        }
        if (as != null) {
            stream.writeBoolean(false);
            AttributedCharacterIterator aci = as.getIterator();
            StringBuffer plainStr = new StringBuffer();
            char current = aci.first();
            while (current != '\uffff') {
                plainStr = plainStr.append(current);
                current = aci.next();
            }
            stream.writeObject(plainStr.toString());
            current = aci.first();
            int begin = aci.getBeginIndex();
            while (current != '\uffff') {
                stream.writeChar(current);
                int limit = aci.getRunLimit();
                stream.writeInt(limit - begin);
                HashMap<AttributedCharacterIterator.Attribute, Object> atts = new HashMap<AttributedCharacterIterator.Attribute, Object>(aci.getAttributes());
                stream.writeObject(atts);
                current = aci.setIndex(limit);
            }
            stream.writeChar(65535);
        } else {
            stream.writeBoolean(true);
        }
    }
}

