/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.general.Series;
import org.jfree.data.general.SeriesException;
import org.jfree.data.xy.XYDataItem;
import org.jfree.util.ObjectUtilities;

public class XYSeries
extends Series
implements Cloneable,
Serializable {
    static final long serialVersionUID = -5908509288197150436L;
    protected List data;
    private int maximumItemCount = Integer.MAX_VALUE;
    private boolean autoSort;
    private boolean allowDuplicateXValues;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;

    public XYSeries(Comparable key) {
        this(key, true, true);
    }

    public XYSeries(Comparable key, boolean autoSort) {
        this(key, autoSort, true);
    }

    public XYSeries(Comparable key, boolean autoSort, boolean allowDuplicateXValues) {
        super(key);
        this.data = new ArrayList();
        this.autoSort = autoSort;
        this.allowDuplicateXValues = allowDuplicateXValues;
        this.minX = Double.NaN;
        this.maxX = Double.NaN;
        this.minY = Double.NaN;
        this.maxY = Double.NaN;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxY() {
        return this.maxY;
    }

    private void updateBoundsForAddedItem(XYDataItem item) {
        double x2 = item.getXValue();
        this.minX = this.minIgnoreNaN(this.minX, x2);
        this.maxX = this.maxIgnoreNaN(this.maxX, x2);
        if (item.getY() != null) {
            double y2 = item.getYValue();
            this.minY = this.minIgnoreNaN(this.minY, y2);
            this.maxY = this.maxIgnoreNaN(this.maxY, y2);
        }
    }

    private void updateBoundsForRemovedItem(XYDataItem item) {
        double y2;
        boolean itemContributesToXBounds = false;
        boolean itemContributesToYBounds = false;
        double x2 = item.getXValue();
        if (!Double.isNaN(x2) && (x2 <= this.minX || x2 >= this.maxX)) {
            itemContributesToXBounds = true;
        }
        if (item.getY() != null && !Double.isNaN(y2 = item.getYValue()) && (y2 <= this.minY || y2 >= this.maxY)) {
            itemContributesToYBounds = true;
        }
        if (itemContributesToYBounds) {
            this.findBoundsByIteration();
        } else if (itemContributesToXBounds) {
            if (this.getAutoSort()) {
                this.minX = this.getX(0).doubleValue();
                this.maxX = this.getX(this.getItemCount() - 1).doubleValue();
            } else {
                this.findBoundsByIteration();
            }
        }
    }

    private void findBoundsByIteration() {
        this.minX = Double.NaN;
        this.maxX = Double.NaN;
        this.minY = Double.NaN;
        this.maxY = Double.NaN;
        for (XYDataItem item : this.data) {
            this.updateBoundsForAddedItem(item);
        }
    }

    public boolean getAutoSort() {
        return this.autoSort;
    }

    public boolean getAllowDuplicateXValues() {
        return this.allowDuplicateXValues;
    }

    @Override
    public int getItemCount() {
        return this.data.size();
    }

    public List getItems() {
        return Collections.unmodifiableList(this.data);
    }

    public int getMaximumItemCount() {
        return this.maximumItemCount;
    }

    public void setMaximumItemCount(int maximum) {
        this.maximumItemCount = maximum;
        int remove = this.data.size() - maximum;
        if (remove > 0) {
            this.data.subList(0, remove).clear();
            this.findBoundsByIteration();
            this.fireSeriesChanged();
        }
    }

    public void add(XYDataItem item) {
        this.add(item, true);
    }

    public void add(double x2, double y2) {
        this.add(new Double(x2), (Number)new Double(y2), true);
    }

    public void add(double x2, double y2, boolean notify) {
        this.add(new Double(x2), (Number)new Double(y2), notify);
    }

    public void add(double x2, Number y2) {
        this.add(new Double(x2), y2);
    }

    public void add(double x2, Number y2, boolean notify) {
        this.add(new Double(x2), y2, notify);
    }

    public void add(Number x2, Number y2) {
        this.add(x2, y2, true);
    }

    public void add(Number x2, Number y2, boolean notify) {
        XYDataItem item = new XYDataItem(x2, y2);
        this.add(item, notify);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void add(XYDataItem item, boolean notify) {
        int index;
        ParamChecks.nullNotPermitted(item, "item");
        item = (XYDataItem)item.clone();
        if (this.autoSort) {
            index = Collections.binarySearch(this.data, item);
            if (index < 0) {
                this.data.add(-index - 1, item);
            } else {
                if (!this.allowDuplicateXValues) throw new SeriesException("X-value already exists.");
                int size = this.data.size();
                while (index < size && item.compareTo(this.data.get(index)) == 0) {
                    ++index;
                }
                if (index < this.data.size()) {
                    this.data.add(index, item);
                } else {
                    this.data.add(item);
                }
            }
        } else {
            if (!this.allowDuplicateXValues && (index = this.indexOf(item.getX())) >= 0) {
                throw new SeriesException("X-value already exists.");
            }
            this.data.add(item);
        }
        this.updateBoundsForAddedItem(item);
        if (this.getItemCount() > this.maximumItemCount) {
            XYDataItem removed = (XYDataItem)this.data.remove(0);
            this.updateBoundsForRemovedItem(removed);
        }
        if (!notify) return;
        this.fireSeriesChanged();
    }

    public void delete(int start, int end) {
        this.data.subList(start, end + 1).clear();
        this.findBoundsByIteration();
        this.fireSeriesChanged();
    }

    public XYDataItem remove(int index) {
        XYDataItem removed = (XYDataItem)this.data.remove(index);
        this.updateBoundsForRemovedItem(removed);
        this.fireSeriesChanged();
        return removed;
    }

    public XYDataItem remove(Number x2) {
        return this.remove(this.indexOf(x2));
    }

    public void clear() {
        if (this.data.size() > 0) {
            this.data.clear();
            this.minX = Double.NaN;
            this.maxX = Double.NaN;
            this.minY = Double.NaN;
            this.maxY = Double.NaN;
            this.fireSeriesChanged();
        }
    }

    public XYDataItem getDataItem(int index) {
        XYDataItem item = (XYDataItem)this.data.get(index);
        return (XYDataItem)item.clone();
    }

    XYDataItem getRawDataItem(int index) {
        return (XYDataItem)this.data.get(index);
    }

    public Number getX(int index) {
        return this.getRawDataItem(index).getX();
    }

    public Number getY(int index) {
        return this.getRawDataItem(index).getY();
    }

    public void update(int index, Number y2) {
        XYDataItem item = this.getRawDataItem(index);
        boolean iterate = false;
        double oldY = item.getYValue();
        if (!Double.isNaN(oldY)) {
            iterate = oldY <= this.minY || oldY >= this.maxY;
        }
        item.setY(y2);
        if (iterate) {
            this.findBoundsByIteration();
        } else if (y2 != null) {
            double yy = y2.doubleValue();
            this.minY = this.minIgnoreNaN(this.minY, yy);
            this.maxY = this.maxIgnoreNaN(this.maxY, yy);
        }
        this.fireSeriesChanged();
    }

    private double minIgnoreNaN(double a2, double b2) {
        if (Double.isNaN(a2)) {
            return b2;
        }
        if (Double.isNaN(b2)) {
            return a2;
        }
        return Math.min(a2, b2);
    }

    private double maxIgnoreNaN(double a2, double b2) {
        if (Double.isNaN(a2)) {
            return b2;
        }
        if (Double.isNaN(b2)) {
            return a2;
        }
        return Math.max(a2, b2);
    }

    public void updateByIndex(int index, Number y2) {
        this.update(index, y2);
    }

    public void update(Number x2, Number y2) {
        int index = this.indexOf(x2);
        if (index < 0) {
            throw new SeriesException("No observation for x = " + x2);
        }
        this.updateByIndex(index, y2);
    }

    public XYDataItem addOrUpdate(double x2, double y2) {
        return this.addOrUpdate(new Double(x2), new Double(y2));
    }

    public XYDataItem addOrUpdate(Number x2, Number y2) {
        return this.addOrUpdate(new XYDataItem(x2, y2));
    }

    public XYDataItem addOrUpdate(XYDataItem item) {
        ParamChecks.nullNotPermitted(item, "item");
        if (this.allowDuplicateXValues) {
            this.add(item);
            return null;
        }
        XYDataItem overwritten = null;
        int index = this.indexOf(item.getX());
        if (index >= 0) {
            XYDataItem existing = (XYDataItem)this.data.get(index);
            overwritten = (XYDataItem)existing.clone();
            boolean iterate = false;
            double oldY = existing.getYValue();
            if (!Double.isNaN(oldY)) {
                iterate = oldY <= this.minY || oldY >= this.maxY;
            }
            existing.setY(item.getY());
            if (iterate) {
                this.findBoundsByIteration();
            } else if (item.getY() != null) {
                double yy = item.getY().doubleValue();
                this.minY = this.minIgnoreNaN(this.minY, yy);
                this.maxY = this.maxIgnoreNaN(this.maxY, yy);
            }
        } else {
            item = (XYDataItem)item.clone();
            if (this.autoSort) {
                this.data.add(-index - 1, item);
            } else {
                this.data.add(item);
            }
            this.updateBoundsForAddedItem(item);
            if (this.getItemCount() > this.maximumItemCount) {
                XYDataItem removed = (XYDataItem)this.data.remove(0);
                this.updateBoundsForRemovedItem(removed);
            }
        }
        this.fireSeriesChanged();
        return overwritten;
    }

    public int indexOf(Number x2) {
        if (this.autoSort) {
            return Collections.binarySearch(this.data, new XYDataItem(x2, null));
        }
        for (int i2 = 0; i2 < this.data.size(); ++i2) {
            XYDataItem item = (XYDataItem)this.data.get(i2);
            if (!item.getX().equals(x2)) continue;
            return i2;
        }
        return -1;
    }

    public double[][] toArray() {
        int itemCount = this.getItemCount();
        double[][] result = new double[2][itemCount];
        for (int i2 = 0; i2 < itemCount; ++i2) {
            result[0][i2] = this.getX(i2).doubleValue();
            Number y2 = this.getY(i2);
            result[1][i2] = y2 != null ? y2.doubleValue() : Double.NaN;
        }
        return result;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        XYSeries clone = (XYSeries)super.clone();
        clone.data = (List)ObjectUtilities.deepClone(this.data);
        return clone;
    }

    public XYSeries createCopy(int start, int end) throws CloneNotSupportedException {
        XYSeries copy = (XYSeries)super.clone();
        copy.data = new ArrayList();
        if (this.data.size() > 0) {
            for (int index = start; index <= end; ++index) {
                XYDataItem item = (XYDataItem)this.data.get(index);
                XYDataItem clone = (XYDataItem)item.clone();
                try {
                    copy.add(clone);
                    continue;
                }
                catch (SeriesException e2) {
                    throw new RuntimeException("Unable to add cloned data item.", e2);
                }
            }
        }
        return copy;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XYSeries)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        XYSeries that = (XYSeries)obj;
        if (this.maximumItemCount != that.maximumItemCount) {
            return false;
        }
        if (this.autoSort != that.autoSort) {
            return false;
        }
        if (this.allowDuplicateXValues != that.allowDuplicateXValues) {
            return false;
        }
        return ObjectUtilities.equal(this.data, that.data);
    }

    @Override
    public int hashCode() {
        XYDataItem item;
        int result = super.hashCode();
        int count = this.getItemCount();
        if (count > 0) {
            item = this.getRawDataItem(0);
            result = 29 * result + item.hashCode();
        }
        if (count > 1) {
            item = this.getRawDataItem(count - 1);
            result = 29 * result + item.hashCode();
        }
        if (count > 2) {
            item = this.getRawDataItem(count / 2);
            result = 29 * result + item.hashCode();
        }
        result = 29 * result + this.maximumItemCount;
        result = 29 * result + (this.autoSort ? 1 : 0);
        result = 29 * result + (this.allowDuplicateXValues ? 1 : 0);
        return result;
    }
}

