/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import org.jfree.chart.util.ParamChecks;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class MovingAverage {
    public static TimeSeriesCollection createMovingAverage(TimeSeriesCollection source, String suffix, int periodCount, int skip) {
        ParamChecks.nullNotPermitted(source, "source");
        if (periodCount < 1) {
            throw new IllegalArgumentException("periodCount must be greater than or equal to 1.");
        }
        TimeSeriesCollection result = new TimeSeriesCollection();
        for (int i2 = 0; i2 < source.getSeriesCount(); ++i2) {
            TimeSeries sourceSeries = source.getSeries(i2);
            TimeSeries maSeries = MovingAverage.createMovingAverage(sourceSeries, sourceSeries.getKey() + suffix, periodCount, skip);
            result.addSeries(maSeries);
        }
        return result;
    }

    public static TimeSeries createMovingAverage(TimeSeries source, String name, int periodCount, int skip) {
        ParamChecks.nullNotPermitted(source, "source");
        if (periodCount < 1) {
            throw new IllegalArgumentException("periodCount must be greater than or equal to 1.");
        }
        TimeSeries result = new TimeSeries((Comparable)((Object)name));
        if (source.getItemCount() > 0) {
            long firstSerial = source.getTimePeriod(0).getSerialIndex() + (long)skip;
            for (int i2 = source.getItemCount() - 1; i2 >= 0; --i2) {
                RegularTimePeriod period = source.getTimePeriod(i2);
                long serial = period.getSerialIndex();
                if (serial < firstSerial) continue;
                int n2 = 0;
                double sum = 0.0;
                long serialLimit = period.getSerialIndex() - (long)periodCount;
                boolean finished = false;
                for (int offset = 0; offset < periodCount && !finished; ++offset) {
                    if (i2 - offset < 0) continue;
                    TimeSeriesDataItem item = source.getRawDataItem(i2 - offset);
                    RegularTimePeriod p2 = item.getPeriod();
                    Number v2 = item.getValue();
                    long currentIndex = p2.getSerialIndex();
                    if (currentIndex > serialLimit) {
                        if (v2 == null) continue;
                        sum += v2.doubleValue();
                        ++n2;
                        continue;
                    }
                    finished = true;
                }
                if (n2 > 0) {
                    result.add(period, sum / (double)n2);
                    continue;
                }
                result.add(period, null);
            }
        }
        return result;
    }

    public static TimeSeries createPointMovingAverage(TimeSeries source, String name, int pointCount) {
        ParamChecks.nullNotPermitted(source, "source");
        if (pointCount < 2) {
            throw new IllegalArgumentException("periodCount must be greater than or equal to 2.");
        }
        TimeSeries result = new TimeSeries((Comparable)((Object)name));
        double rollingSumForPeriod = 0.0;
        for (int i2 = 0; i2 < source.getItemCount(); ++i2) {
            TimeSeriesDataItem current = source.getRawDataItem(i2);
            RegularTimePeriod period = current.getPeriod();
            rollingSumForPeriod += current.getValue().doubleValue();
            if (i2 > pointCount - 1) {
                TimeSeriesDataItem startOfMovingAvg = source.getRawDataItem(i2 - pointCount);
                result.add(period, (rollingSumForPeriod -= startOfMovingAvg.getValue().doubleValue()) / (double)pointCount);
                continue;
            }
            if (i2 != pointCount - 1) continue;
            result.add(period, rollingSumForPeriod / (double)pointCount);
        }
        return result;
    }

    public static XYDataset createMovingAverage(XYDataset source, String suffix, long period, long skip) {
        return MovingAverage.createMovingAverage(source, suffix, (double)period, (double)skip);
    }

    public static XYDataset createMovingAverage(XYDataset source, String suffix, double period, double skip) {
        ParamChecks.nullNotPermitted(source, "source");
        XYSeriesCollection result = new XYSeriesCollection();
        for (int i2 = 0; i2 < source.getSeriesCount(); ++i2) {
            XYSeries s2 = MovingAverage.createMovingAverage(source, i2, source.getSeriesKey(i2) + suffix, period, skip);
            result.addSeries(s2);
        }
        return result;
    }

    public static XYSeries createMovingAverage(XYDataset source, int series, String name, double period, double skip) {
        ParamChecks.nullNotPermitted(source, "source");
        if (period < Double.MIN_VALUE) {
            throw new IllegalArgumentException("period must be positive.");
        }
        if (skip < 0.0) {
            throw new IllegalArgumentException("skip must be >= 0.0.");
        }
        XYSeries result = new XYSeries((Comparable)((Object)name));
        if (source.getItemCount(series) > 0) {
            double first = source.getXValue(series, 0) + skip;
            for (int i2 = source.getItemCount(series) - 1; i2 >= 0; --i2) {
                double x2 = source.getXValue(series, i2);
                if (!(x2 >= first)) continue;
                int n2 = 0;
                double sum = 0.0;
                double limit = x2 - period;
                int offset = 0;
                boolean finished = false;
                while (!finished) {
                    if (i2 - offset >= 0) {
                        double xx = source.getXValue(series, i2 - offset);
                        Number yy = source.getY(series, i2 - offset);
                        if (xx > limit) {
                            if (yy != null) {
                                sum += yy.doubleValue();
                                ++n2;
                            }
                        } else {
                            finished = true;
                        }
                    } else {
                        finished = true;
                    }
                    ++offset;
                }
                if (n2 > 0) {
                    result.add(x2, sum / (double)n2);
                    continue;
                }
                result.add(x2, (Number)null);
            }
        }
        return result;
    }
}

