/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.CyclicNumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.DomainOrder;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.DatasetGroup;
import org.jfree.data.xy.XYDataset;

public class CyclicXYItemRenderer
extends StandardXYItemRenderer
implements Serializable {
    private static final long serialVersionUID = 4035912243303764892L;

    public CyclicXYItemRenderer() {
    }

    public CyclicXYItemRenderer(int type) {
        super(type);
    }

    public CyclicXYItemRenderer(int type, XYToolTipGenerator labelGenerator) {
        super(type, labelGenerator);
    }

    public CyclicXYItemRenderer(int type, XYToolTipGenerator labelGenerator, XYURLGenerator urlGenerator) {
        super(type, labelGenerator, urlGenerator);
    }

    @Override
    public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        double[] ny;
        double[] nx;
        if (!this.getPlotLines() || !(domainAxis instanceof CyclicNumberAxis) && !(rangeAxis instanceof CyclicNumberAxis) || item <= 0) {
            super.drawItem(g2, state, dataArea, info, plot, domainAxis, rangeAxis, dataset, series, item, crosshairState, pass);
            return;
        }
        double xn = dataset.getXValue(series, item - 1);
        double yn = dataset.getYValue(series, item - 1);
        if (Double.isNaN(yn)) {
            super.drawItem(g2, state, dataArea, info, plot, domainAxis, rangeAxis, dataset, series, item, crosshairState, pass);
            return;
        }
        double[] x2 = new double[2];
        double[] y2 = new double[2];
        x2[0] = xn;
        y2[0] = yn;
        xn = dataset.getXValue(series, item);
        yn = dataset.getYValue(series, item);
        if (Double.isNaN(yn)) {
            return;
        }
        x2[1] = xn;
        y2[1] = yn;
        double xcycleBound = Double.NaN;
        double ycycleBound = Double.NaN;
        boolean xBoundMapping = false;
        boolean yBoundMapping = false;
        CyclicNumberAxis cnax = null;
        CyclicNumberAxis cnay = null;
        if (domainAxis instanceof CyclicNumberAxis) {
            cnax = (CyclicNumberAxis)domainAxis;
            xcycleBound = cnax.getCycleBound();
            xBoundMapping = cnax.isBoundMappedToLastCycle();
            if (x2[0] != x2[1] && (xcycleBound >= x2[0] && xcycleBound <= x2[1] || xcycleBound >= x2[1] && xcycleBound <= x2[0])) {
                nx = new double[3];
                ny = new double[3];
                nx[0] = x2[0];
                nx[2] = x2[1];
                ny[0] = y2[0];
                ny[2] = y2[1];
                nx[1] = xcycleBound;
                ny[1] = (y2[1] - y2[0]) * (xcycleBound - x2[0]) / (x2[1] - x2[0]) + y2[0];
                x2 = nx;
                y2 = ny;
            }
        }
        if (rangeAxis instanceof CyclicNumberAxis) {
            cnay = (CyclicNumberAxis)rangeAxis;
            ycycleBound = cnay.getCycleBound();
            yBoundMapping = cnay.isBoundMappedToLastCycle();
            if (y2[0] != y2[1] && (ycycleBound >= y2[0] && ycycleBound <= y2[1] || ycycleBound >= y2[1] && ycycleBound <= y2[0])) {
                nx = new double[x2.length + 1];
                ny = new double[y2.length + 1];
                nx[0] = x2[0];
                nx[2] = x2[1];
                ny[0] = y2[0];
                ny[2] = y2[1];
                ny[1] = ycycleBound;
                nx[1] = (x2[1] - x2[0]) * (ycycleBound - y2[0]) / (y2[1] - y2[0]) + x2[0];
                if (x2.length == 3) {
                    nx[3] = x2[2];
                    ny[3] = y2[2];
                }
                x2 = nx;
                y2 = ny;
            } else if (x2.length == 3 && y2[1] != y2[2] && (ycycleBound >= y2[1] && ycycleBound <= y2[2] || ycycleBound >= y2[2] && ycycleBound <= y2[1])) {
                nx = new double[4];
                ny = new double[4];
                nx[0] = x2[0];
                nx[1] = x2[1];
                nx[3] = x2[2];
                ny[0] = y2[0];
                ny[1] = y2[1];
                ny[3] = y2[2];
                ny[2] = ycycleBound;
                nx[2] = (x2[2] - x2[1]) * (ycycleBound - y2[1]) / (y2[2] - y2[1]) + x2[1];
                x2 = nx;
                y2 = ny;
            }
        }
        if (x2.length == 2) {
            super.drawItem(g2, state, dataArea, info, plot, domainAxis, rangeAxis, dataset, series, item, crosshairState, pass);
            return;
        }
        OverwriteDataSet newset = new OverwriteDataSet(x2, y2, dataset);
        if (cnax != null) {
            if (xcycleBound == x2[0]) {
                cnax.setBoundMappedToLastCycle(x2[1] <= xcycleBound);
            }
            if (xcycleBound == x2[1]) {
                cnax.setBoundMappedToLastCycle(x2[0] <= xcycleBound);
            }
        }
        if (cnay != null) {
            if (ycycleBound == y2[0]) {
                cnay.setBoundMappedToLastCycle(y2[1] <= ycycleBound);
            }
            if (ycycleBound == y2[1]) {
                cnay.setBoundMappedToLastCycle(y2[0] <= ycycleBound);
            }
        }
        super.drawItem(g2, state, dataArea, info, plot, domainAxis, rangeAxis, newset, series, 1, crosshairState, pass);
        if (cnax != null) {
            if (xcycleBound == x2[1]) {
                cnax.setBoundMappedToLastCycle(x2[2] <= xcycleBound);
            }
            if (xcycleBound == x2[2]) {
                cnax.setBoundMappedToLastCycle(x2[1] <= xcycleBound);
            }
        }
        if (cnay != null) {
            if (ycycleBound == y2[1]) {
                cnay.setBoundMappedToLastCycle(y2[2] <= ycycleBound);
            }
            if (ycycleBound == y2[2]) {
                cnay.setBoundMappedToLastCycle(y2[1] <= ycycleBound);
            }
        }
        super.drawItem(g2, state, dataArea, info, plot, domainAxis, rangeAxis, newset, series, 2, crosshairState, pass);
        if (x2.length == 4) {
            if (cnax != null) {
                if (xcycleBound == x2[2]) {
                    cnax.setBoundMappedToLastCycle(x2[3] <= xcycleBound);
                }
                if (xcycleBound == x2[3]) {
                    cnax.setBoundMappedToLastCycle(x2[2] <= xcycleBound);
                }
            }
            if (cnay != null) {
                if (ycycleBound == y2[2]) {
                    cnay.setBoundMappedToLastCycle(y2[3] <= ycycleBound);
                }
                if (ycycleBound == y2[3]) {
                    cnay.setBoundMappedToLastCycle(y2[2] <= ycycleBound);
                }
            }
            super.drawItem(g2, state, dataArea, info, plot, domainAxis, rangeAxis, newset, series, 3, crosshairState, pass);
        }
        if (cnax != null) {
            cnax.setBoundMappedToLastCycle(xBoundMapping);
        }
        if (cnay != null) {
            cnay.setBoundMappedToLastCycle(yBoundMapping);
        }
    }

    protected static class OverwriteDataSet
    implements XYDataset {
        protected XYDataset delegateSet;
        Double[] x;
        Double[] y;

        public OverwriteDataSet(double[] x2, double[] y2, XYDataset delegateSet) {
            this.delegateSet = delegateSet;
            this.x = new Double[x2.length];
            this.y = new Double[y2.length];
            for (int i2 = 0; i2 < x2.length; ++i2) {
                this.x[i2] = new Double(x2[i2]);
                this.y[i2] = new Double(y2[i2]);
            }
        }

        @Override
        public DomainOrder getDomainOrder() {
            return DomainOrder.NONE;
        }

        @Override
        public int getItemCount(int series) {
            return this.x.length;
        }

        @Override
        public Number getX(int series, int item) {
            return this.x[item];
        }

        @Override
        public double getXValue(int series, int item) {
            double result = Double.NaN;
            Number xx = this.getX(series, item);
            if (xx != null) {
                result = xx.doubleValue();
            }
            return result;
        }

        @Override
        public Number getY(int series, int item) {
            return this.y[item];
        }

        @Override
        public double getYValue(int series, int item) {
            double result = Double.NaN;
            Number yy = this.getY(series, item);
            if (yy != null) {
                result = yy.doubleValue();
            }
            return result;
        }

        @Override
        public int getSeriesCount() {
            return this.delegateSet.getSeriesCount();
        }

        @Override
        public Comparable getSeriesKey(int series) {
            return this.delegateSet.getSeriesKey(series);
        }

        @Override
        public int indexOf(Comparable seriesName) {
            return this.delegateSet.indexOf(seriesName);
        }

        @Override
        public void addChangeListener(DatasetChangeListener listener) {
        }

        @Override
        public void removeChangeListener(DatasetChangeListener listener) {
        }

        @Override
        public DatasetGroup getGroup() {
            return this.delegateSet.getGroup();
        }

        @Override
        public void setGroup(DatasetGroup group) {
        }
    }
}

