/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.PlotChangeListener;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.util.ParamChecks;
import org.jfree.chart.util.ShadowGenerator;
import org.jfree.data.Range;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.ObjectUtilities;

public class CombinedRangeCategoryPlot
extends CategoryPlot
implements PlotChangeListener {
    private static final long serialVersionUID = 7260210007554504515L;
    private List subplots = new ArrayList();
    private double gap = 5.0;
    private transient Rectangle2D[] subplotArea;

    public CombinedRangeCategoryPlot() {
        this(new NumberAxis());
    }

    public CombinedRangeCategoryPlot(ValueAxis rangeAxis) {
        super(null, null, rangeAxis, null);
    }

    public double getGap() {
        return this.gap;
    }

    public void setGap(double gap) {
        this.gap = gap;
        this.fireChangeEvent();
    }

    public void add(CategoryPlot subplot) {
        this.add(subplot, 1);
    }

    public void add(CategoryPlot subplot, int weight) {
        ParamChecks.nullNotPermitted(subplot, "subplot");
        if (weight <= 0) {
            throw new IllegalArgumentException("Require weight >= 1.");
        }
        subplot.setParent(this);
        subplot.setWeight(weight);
        subplot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        subplot.setRangeAxis(null);
        subplot.setOrientation(this.getOrientation());
        subplot.addChangeListener(this);
        this.subplots.add(subplot);
        ValueAxis axis = this.getRangeAxis();
        if (axis != null) {
            axis.configure();
        }
        this.fireChangeEvent();
    }

    public void remove(CategoryPlot subplot) {
        ParamChecks.nullNotPermitted(subplot, "subplot");
        int position = -1;
        int size = this.subplots.size();
        for (int i2 = 0; position == -1 && i2 < size; ++i2) {
            if (this.subplots.get(i2) != subplot) continue;
            position = i2;
        }
        if (position != -1) {
            ValueAxis range2;
            this.subplots.remove(position);
            subplot.setParent(null);
            subplot.removeChangeListener(this);
            ValueAxis range = this.getRangeAxis();
            if (range != null) {
                range.configure();
            }
            if ((range2 = this.getRangeAxis(1)) != null) {
                range2.configure();
            }
            this.fireChangeEvent();
        }
    }

    public List getSubplots() {
        if (this.subplots != null) {
            return Collections.unmodifiableList(this.subplots);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    protected AxisSpace calculateAxisSpace(Graphics2D g2, Rectangle2D plotArea) {
        AxisSpace space = new AxisSpace();
        PlotOrientation orientation = this.getOrientation();
        AxisSpace fixed = this.getFixedRangeAxisSpace();
        if (fixed != null) {
            if (orientation == PlotOrientation.VERTICAL) {
                space.setLeft(fixed.getLeft());
                space.setRight(fixed.getRight());
            } else if (orientation == PlotOrientation.HORIZONTAL) {
                space.setTop(fixed.getTop());
                space.setBottom(fixed.getBottom());
            }
        } else {
            ValueAxis valueAxis = this.getRangeAxis();
            RectangleEdge valueEdge = Plot.resolveRangeAxisLocation(this.getRangeAxisLocation(), orientation);
            if (valueAxis != null) {
                space = valueAxis.reserveSpace(g2, this, plotArea, valueEdge, space);
            }
        }
        Rectangle2D adjustedPlotArea = space.shrink(plotArea, null);
        int n2 = this.subplots.size();
        int totalWeight = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            CategoryPlot sub = (CategoryPlot)this.subplots.get(i2);
            totalWeight += sub.getWeight();
        }
        this.subplotArea = new Rectangle2D[n2];
        double x2 = adjustedPlotArea.getX();
        double y2 = adjustedPlotArea.getY();
        double usableSize = 0.0;
        if (orientation == PlotOrientation.VERTICAL) {
            usableSize = adjustedPlotArea.getWidth() - this.gap * (double)(n2 - 1);
        } else if (orientation == PlotOrientation.HORIZONTAL) {
            usableSize = adjustedPlotArea.getHeight() - this.gap * (double)(n2 - 1);
        }
        for (int i3 = 0; i3 < n2; ++i3) {
            CategoryPlot plot = (CategoryPlot)this.subplots.get(i3);
            if (orientation == PlotOrientation.VERTICAL) {
                double w2 = usableSize * (double)plot.getWeight() / (double)totalWeight;
                this.subplotArea[i3] = new Rectangle2D.Double(x2, y2, w2, adjustedPlotArea.getHeight());
                x2 = x2 + w2 + this.gap;
            } else if (orientation == PlotOrientation.HORIZONTAL) {
                double h2 = usableSize * (double)plot.getWeight() / (double)totalWeight;
                this.subplotArea[i3] = new Rectangle2D.Double(x2, y2, adjustedPlotArea.getWidth(), h2);
                y2 = y2 + h2 + this.gap;
            }
            AxisSpace subSpace = plot.calculateDomainAxisSpace(g2, this.subplotArea[i3], null);
            space.ensureAtLeast(subSpace);
        }
        return space;
    }

    @Override
    public void draw(Graphics2D g2, Rectangle2D area, Point2D anchor, PlotState parentState, PlotRenderingInfo info) {
        if (info != null) {
            info.setPlotArea(area);
        }
        RectangleInsets insets = this.getInsets();
        insets.trim(area);
        AxisSpace space = this.calculateAxisSpace(g2, area);
        Rectangle2D dataArea = space.shrink(area, null);
        this.setFixedDomainAxisSpaceForSubplots(space);
        ValueAxis axis = this.getRangeAxis();
        RectangleEdge rangeEdge = this.getRangeAxisEdge();
        double cursor = RectangleEdge.coordinate(dataArea, rangeEdge);
        AxisState state = axis.draw(g2, cursor, area, dataArea, rangeEdge, info);
        if (parentState == null) {
            parentState = new PlotState();
        }
        parentState.getSharedAxisStates().put(axis, state);
        for (int i2 = 0; i2 < this.subplots.size(); ++i2) {
            CategoryPlot plot = (CategoryPlot)this.subplots.get(i2);
            PlotRenderingInfo subplotInfo = null;
            if (info != null) {
                subplotInfo = new PlotRenderingInfo(info.getOwner());
                info.addSubplotInfo(subplotInfo);
            }
            Point2D subAnchor = null;
            if (anchor != null && this.subplotArea[i2].contains(anchor)) {
                subAnchor = anchor;
            }
            plot.draw(g2, this.subplotArea[i2], subAnchor, parentState, subplotInfo);
        }
        if (info != null) {
            info.setDataArea(dataArea);
        }
    }

    @Override
    public void setOrientation(PlotOrientation orientation) {
        super.setOrientation(orientation);
        for (CategoryPlot plot : this.subplots) {
            plot.setOrientation(orientation);
        }
    }

    @Override
    public void setShadowGenerator(ShadowGenerator generator) {
        this.setNotify(false);
        super.setShadowGenerator(generator);
        for (CategoryPlot plot : this.subplots) {
            plot.setShadowGenerator(generator);
        }
        this.setNotify(true);
    }

    @Override
    public Range getDataRange(ValueAxis axis) {
        Range result = null;
        if (this.subplots != null) {
            for (CategoryPlot subplot : this.subplots) {
                result = Range.combine(result, subplot.getDataRange(axis));
            }
        }
        return result;
    }

    @Override
    public LegendItemCollection getLegendItems() {
        LegendItemCollection result = this.getFixedLegendItems();
        if (result == null) {
            result = new LegendItemCollection();
            if (this.subplots != null) {
                for (CategoryPlot plot : this.subplots) {
                    LegendItemCollection more = plot.getLegendItems();
                    result.addAll(more);
                }
            }
        }
        return result;
    }

    protected void setFixedDomainAxisSpaceForSubplots(AxisSpace space) {
        for (CategoryPlot plot : this.subplots) {
            plot.setFixedDomainAxisSpace(space, false);
        }
    }

    @Override
    public void handleClick(int x2, int y2, PlotRenderingInfo info) {
        Rectangle2D dataArea = info.getDataArea();
        if (dataArea.contains(x2, y2)) {
            for (int i2 = 0; i2 < this.subplots.size(); ++i2) {
                CategoryPlot subplot = (CategoryPlot)this.subplots.get(i2);
                PlotRenderingInfo subplotInfo = info.getSubplotInfo(i2);
                subplot.handleClick(x2, y2, subplotInfo);
            }
        }
    }

    @Override
    public void plotChanged(PlotChangeEvent event) {
        this.notifyListeners(event);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CombinedRangeCategoryPlot)) {
            return false;
        }
        CombinedRangeCategoryPlot that = (CombinedRangeCategoryPlot)obj;
        if (this.gap != that.gap) {
            return false;
        }
        if (!ObjectUtilities.equal(this.subplots, that.subplots)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CombinedRangeCategoryPlot result = (CombinedRangeCategoryPlot)super.clone();
        result.subplots = (List)ObjectUtilities.deepClone(this.subplots);
        for (Plot child : result.subplots) {
            child.setParent(result);
        }
        ValueAxis rangeAxis = result.getRangeAxis();
        if (rangeAxis != null) {
            rangeAxis.configure();
        }
        return result;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        ValueAxis rangeAxis = this.getRangeAxis();
        if (rangeAxis != null) {
            rangeAxis.configure();
        }
    }
}

