/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.panel;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.panel.AbstractOverlay;
import org.jfree.chart.panel.Overlay;
import org.jfree.chart.plot.Crosshair;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.util.ParamChecks;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class CrosshairOverlay
extends AbstractOverlay
implements Overlay,
PropertyChangeListener,
PublicCloneable,
Cloneable,
Serializable {
    private List xCrosshairs = new ArrayList();
    private List yCrosshairs = new ArrayList();

    public void addDomainCrosshair(Crosshair crosshair) {
        ParamChecks.nullNotPermitted(crosshair, "crosshair");
        this.xCrosshairs.add(crosshair);
        crosshair.addPropertyChangeListener(this);
        this.fireOverlayChanged();
    }

    public void removeDomainCrosshair(Crosshair crosshair) {
        ParamChecks.nullNotPermitted(crosshair, "crosshair");
        if (this.xCrosshairs.remove(crosshair)) {
            crosshair.removePropertyChangeListener(this);
            this.fireOverlayChanged();
        }
    }

    public void clearDomainCrosshairs() {
        if (this.xCrosshairs.isEmpty()) {
            return;
        }
        List crosshairs = this.getDomainCrosshairs();
        for (int i2 = 0; i2 < crosshairs.size(); ++i2) {
            Crosshair c2 = (Crosshair)crosshairs.get(i2);
            this.xCrosshairs.remove(c2);
            c2.removePropertyChangeListener(this);
        }
        this.fireOverlayChanged();
    }

    public List getDomainCrosshairs() {
        return new ArrayList(this.xCrosshairs);
    }

    public void addRangeCrosshair(Crosshair crosshair) {
        ParamChecks.nullNotPermitted(crosshair, "crosshair");
        this.yCrosshairs.add(crosshair);
        crosshair.addPropertyChangeListener(this);
        this.fireOverlayChanged();
    }

    public void removeRangeCrosshair(Crosshair crosshair) {
        ParamChecks.nullNotPermitted(crosshair, "crosshair");
        if (this.yCrosshairs.remove(crosshair)) {
            crosshair.removePropertyChangeListener(this);
            this.fireOverlayChanged();
        }
    }

    public void clearRangeCrosshairs() {
        if (this.yCrosshairs.isEmpty()) {
            return;
        }
        List crosshairs = this.getRangeCrosshairs();
        for (int i2 = 0; i2 < crosshairs.size(); ++i2) {
            Crosshair c2 = (Crosshair)crosshairs.get(i2);
            this.yCrosshairs.remove(c2);
            c2.removePropertyChangeListener(this);
        }
        this.fireOverlayChanged();
    }

    public List getRangeCrosshairs() {
        return new ArrayList(this.yCrosshairs);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e2) {
        this.fireOverlayChanged();
    }

    @Override
    public void paintOverlay(Graphics2D g2, ChartPanel chartPanel) {
        Shape savedClip = g2.getClip();
        Rectangle2D dataArea = chartPanel.getScreenDataArea();
        g2.clip(dataArea);
        JFreeChart chart = chartPanel.getChart();
        XYPlot plot = (XYPlot)chart.getPlot();
        ValueAxis xAxis = plot.getDomainAxis();
        RectangleEdge xAxisEdge = plot.getDomainAxisEdge();
        for (Crosshair ch : this.xCrosshairs) {
            if (!ch.isVisible()) continue;
            double x2 = ch.getValue();
            double xx = xAxis.valueToJava2D(x2, dataArea, xAxisEdge);
            if (plot.getOrientation() == PlotOrientation.VERTICAL) {
                this.drawVerticalCrosshair(g2, dataArea, xx, ch);
                continue;
            }
            this.drawHorizontalCrosshair(g2, dataArea, xx, ch);
        }
        ValueAxis yAxis = plot.getRangeAxis();
        RectangleEdge yAxisEdge = plot.getRangeAxisEdge();
        for (Crosshair ch : this.yCrosshairs) {
            if (!ch.isVisible()) continue;
            double y2 = ch.getValue();
            double yy = yAxis.valueToJava2D(y2, dataArea, yAxisEdge);
            if (plot.getOrientation() == PlotOrientation.VERTICAL) {
                this.drawHorizontalCrosshair(g2, dataArea, yy, ch);
                continue;
            }
            this.drawVerticalCrosshair(g2, dataArea, yy, ch);
        }
        g2.setClip(savedClip);
    }

    protected void drawHorizontalCrosshair(Graphics2D g2, Rectangle2D dataArea, double y2, Crosshair crosshair) {
        if (y2 >= dataArea.getMinY() && y2 <= dataArea.getMaxY()) {
            Line2D.Double line = new Line2D.Double(dataArea.getMinX(), y2, dataArea.getMaxX(), y2);
            Paint savedPaint = g2.getPaint();
            Stroke savedStroke = g2.getStroke();
            g2.setPaint(crosshair.getPaint());
            g2.setStroke(crosshair.getStroke());
            g2.draw(line);
            if (crosshair.isLabelVisible()) {
                TextAnchor alignPt;
                float yy;
                RectangleAnchor anchor;
                Point2D pt;
                float xx;
                String label = crosshair.getLabelGenerator().generateLabel(crosshair);
                Shape hotspot = TextUtilities.calculateRotatedStringBounds(label, g2, xx = (float)(pt = this.calculateLabelPoint(line, anchor = crosshair.getLabelAnchor(), 5.0, 5.0)).getX(), yy = (float)pt.getY(), alignPt = this.textAlignPtForLabelAnchorH(anchor), 0.0, TextAnchor.CENTER);
                if (!dataArea.contains(hotspot.getBounds2D())) {
                    anchor = this.flipAnchorV(anchor);
                    pt = this.calculateLabelPoint(line, anchor, 5.0, 5.0);
                    xx = (float)pt.getX();
                    yy = (float)pt.getY();
                    alignPt = this.textAlignPtForLabelAnchorH(anchor);
                    hotspot = TextUtilities.calculateRotatedStringBounds(label, g2, xx, yy, alignPt, 0.0, TextAnchor.CENTER);
                }
                g2.setPaint(crosshair.getLabelBackgroundPaint());
                g2.fill(hotspot);
                g2.setPaint(crosshair.getLabelOutlinePaint());
                g2.draw(hotspot);
                TextUtilities.drawAlignedString(label, g2, xx, yy, alignPt);
            }
            g2.setPaint(savedPaint);
            g2.setStroke(savedStroke);
        }
    }

    protected void drawVerticalCrosshair(Graphics2D g2, Rectangle2D dataArea, double x2, Crosshair crosshair) {
        if (x2 >= dataArea.getMinX() && x2 <= dataArea.getMaxX()) {
            Line2D.Double line = new Line2D.Double(x2, dataArea.getMinY(), x2, dataArea.getMaxY());
            Paint savedPaint = g2.getPaint();
            Stroke savedStroke = g2.getStroke();
            g2.setPaint(crosshair.getPaint());
            g2.setStroke(crosshair.getStroke());
            g2.draw(line);
            if (crosshair.isLabelVisible()) {
                TextAnchor alignPt;
                float yy;
                RectangleAnchor anchor;
                Point2D pt;
                float xx;
                String label = crosshair.getLabelGenerator().generateLabel(crosshair);
                Shape hotspot = TextUtilities.calculateRotatedStringBounds(label, g2, xx = (float)(pt = this.calculateLabelPoint(line, anchor = crosshair.getLabelAnchor(), 5.0, 5.0)).getX(), yy = (float)pt.getY(), alignPt = this.textAlignPtForLabelAnchorV(anchor), 0.0, TextAnchor.CENTER);
                if (!dataArea.contains(hotspot.getBounds2D())) {
                    anchor = this.flipAnchorH(anchor);
                    pt = this.calculateLabelPoint(line, anchor, 5.0, 5.0);
                    xx = (float)pt.getX();
                    yy = (float)pt.getY();
                    alignPt = this.textAlignPtForLabelAnchorV(anchor);
                    hotspot = TextUtilities.calculateRotatedStringBounds(label, g2, xx, yy, alignPt, 0.0, TextAnchor.CENTER);
                }
                g2.setPaint(crosshair.getLabelBackgroundPaint());
                g2.fill(hotspot);
                g2.setPaint(crosshair.getLabelOutlinePaint());
                g2.draw(hotspot);
                TextUtilities.drawAlignedString(label, g2, xx, yy, alignPt);
            }
            g2.setPaint(savedPaint);
            g2.setStroke(savedStroke);
        }
    }

    private Point2D calculateLabelPoint(Line2D line, RectangleAnchor anchor, double deltaX, double deltaY) {
        double y2;
        double x2;
        boolean left = anchor == RectangleAnchor.BOTTOM_LEFT || anchor == RectangleAnchor.LEFT || anchor == RectangleAnchor.TOP_LEFT;
        boolean right = anchor == RectangleAnchor.BOTTOM_RIGHT || anchor == RectangleAnchor.RIGHT || anchor == RectangleAnchor.TOP_RIGHT;
        boolean top = anchor == RectangleAnchor.TOP_LEFT || anchor == RectangleAnchor.TOP || anchor == RectangleAnchor.TOP_RIGHT;
        boolean bottom = anchor == RectangleAnchor.BOTTOM_LEFT || anchor == RectangleAnchor.BOTTOM || anchor == RectangleAnchor.BOTTOM_RIGHT;
        Rectangle rect = line.getBounds();
        if (line.getX1() == line.getX2()) {
            x2 = line.getX1();
            y2 = (line.getY1() + line.getY2()) / 2.0;
            if (left) {
                x2 -= deltaX;
            }
            if (right) {
                x2 += deltaX;
            }
            if (top) {
                y2 = Math.min(line.getY1(), line.getY2()) + deltaY;
            }
            if (bottom) {
                y2 = Math.max(line.getY1(), line.getY2()) - deltaY;
            }
        } else {
            x2 = (line.getX1() + line.getX2()) / 2.0;
            y2 = line.getY1();
            if (left) {
                x2 = Math.min(line.getX1(), line.getX2()) + deltaX;
            }
            if (right) {
                x2 = Math.max(line.getX1(), line.getX2()) - deltaX;
            }
            if (top) {
                y2 -= deltaY;
            }
            if (bottom) {
                y2 += deltaY;
            }
        }
        return new Point2D.Double(x2, y2);
    }

    private TextAnchor textAlignPtForLabelAnchorV(RectangleAnchor anchor) {
        TextAnchor result = TextAnchor.CENTER;
        if (anchor.equals(RectangleAnchor.TOP_LEFT)) {
            result = TextAnchor.TOP_RIGHT;
        } else if (anchor.equals(RectangleAnchor.TOP)) {
            result = TextAnchor.TOP_CENTER;
        } else if (anchor.equals(RectangleAnchor.TOP_RIGHT)) {
            result = TextAnchor.TOP_LEFT;
        } else if (anchor.equals(RectangleAnchor.LEFT)) {
            result = TextAnchor.HALF_ASCENT_RIGHT;
        } else if (anchor.equals(RectangleAnchor.RIGHT)) {
            result = TextAnchor.HALF_ASCENT_LEFT;
        } else if (anchor.equals(RectangleAnchor.BOTTOM_LEFT)) {
            result = TextAnchor.BOTTOM_RIGHT;
        } else if (anchor.equals(RectangleAnchor.BOTTOM)) {
            result = TextAnchor.BOTTOM_CENTER;
        } else if (anchor.equals(RectangleAnchor.BOTTOM_RIGHT)) {
            result = TextAnchor.BOTTOM_LEFT;
        }
        return result;
    }

    private TextAnchor textAlignPtForLabelAnchorH(RectangleAnchor anchor) {
        TextAnchor result = TextAnchor.CENTER;
        if (anchor.equals(RectangleAnchor.TOP_LEFT)) {
            result = TextAnchor.BOTTOM_LEFT;
        } else if (anchor.equals(RectangleAnchor.TOP)) {
            result = TextAnchor.BOTTOM_CENTER;
        } else if (anchor.equals(RectangleAnchor.TOP_RIGHT)) {
            result = TextAnchor.BOTTOM_RIGHT;
        } else if (anchor.equals(RectangleAnchor.LEFT)) {
            result = TextAnchor.HALF_ASCENT_LEFT;
        } else if (anchor.equals(RectangleAnchor.RIGHT)) {
            result = TextAnchor.HALF_ASCENT_RIGHT;
        } else if (anchor.equals(RectangleAnchor.BOTTOM_LEFT)) {
            result = TextAnchor.TOP_LEFT;
        } else if (anchor.equals(RectangleAnchor.BOTTOM)) {
            result = TextAnchor.TOP_CENTER;
        } else if (anchor.equals(RectangleAnchor.BOTTOM_RIGHT)) {
            result = TextAnchor.TOP_RIGHT;
        }
        return result;
    }

    private RectangleAnchor flipAnchorH(RectangleAnchor anchor) {
        RectangleAnchor result = anchor;
        if (anchor.equals(RectangleAnchor.TOP_LEFT)) {
            result = RectangleAnchor.TOP_RIGHT;
        } else if (anchor.equals(RectangleAnchor.TOP_RIGHT)) {
            result = RectangleAnchor.TOP_LEFT;
        } else if (anchor.equals(RectangleAnchor.LEFT)) {
            result = RectangleAnchor.RIGHT;
        } else if (anchor.equals(RectangleAnchor.RIGHT)) {
            result = RectangleAnchor.LEFT;
        } else if (anchor.equals(RectangleAnchor.BOTTOM_LEFT)) {
            result = RectangleAnchor.BOTTOM_RIGHT;
        } else if (anchor.equals(RectangleAnchor.BOTTOM_RIGHT)) {
            result = RectangleAnchor.BOTTOM_LEFT;
        }
        return result;
    }

    private RectangleAnchor flipAnchorV(RectangleAnchor anchor) {
        RectangleAnchor result = anchor;
        if (anchor.equals(RectangleAnchor.TOP_LEFT)) {
            result = RectangleAnchor.BOTTOM_LEFT;
        } else if (anchor.equals(RectangleAnchor.TOP_RIGHT)) {
            result = RectangleAnchor.BOTTOM_RIGHT;
        } else if (anchor.equals(RectangleAnchor.TOP)) {
            result = RectangleAnchor.BOTTOM;
        } else if (anchor.equals(RectangleAnchor.BOTTOM)) {
            result = RectangleAnchor.TOP;
        } else if (anchor.equals(RectangleAnchor.BOTTOM_LEFT)) {
            result = RectangleAnchor.TOP_LEFT;
        } else if (anchor.equals(RectangleAnchor.BOTTOM_RIGHT)) {
            result = RectangleAnchor.TOP_RIGHT;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CrosshairOverlay)) {
            return false;
        }
        CrosshairOverlay that = (CrosshairOverlay)obj;
        if (!this.xCrosshairs.equals(that.xCrosshairs)) {
            return false;
        }
        return this.yCrosshairs.equals(that.yCrosshairs);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CrosshairOverlay clone = (CrosshairOverlay)super.clone();
        clone.xCrosshairs = (List)ObjectUtilities.deepClone(this.xCrosshairs);
        clone.yCrosshairs = (List)ObjectUtilities.deepClone(this.yCrosshairs);
        return clone;
    }
}

