/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.io.Serializable;
import org.jfree.chart.util.ParamChecks;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ObjectUtilities;

public abstract class Tick
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 6668230383875149773L;
    private String text;
    private TextAnchor textAnchor;
    private TextAnchor rotationAnchor;
    private double angle;

    public Tick(String text, TextAnchor textAnchor, TextAnchor rotationAnchor, double angle) {
        ParamChecks.nullNotPermitted(textAnchor, "textAnchor");
        ParamChecks.nullNotPermitted(rotationAnchor, "rotationAnchor");
        this.text = text;
        this.textAnchor = textAnchor;
        this.rotationAnchor = rotationAnchor;
        this.angle = angle;
    }

    public String getText() {
        return this.text;
    }

    public TextAnchor getTextAnchor() {
        return this.textAnchor;
    }

    public TextAnchor getRotationAnchor() {
        return this.rotationAnchor;
    }

    public double getAngle() {
        return this.angle;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Tick) {
            Tick t2 = (Tick)obj;
            if (!ObjectUtilities.equal(this.text, t2.text)) {
                return false;
            }
            if (!ObjectUtilities.equal(this.textAnchor, t2.textAnchor)) {
                return false;
            }
            if (!ObjectUtilities.equal(this.rotationAnchor, t2.rotationAnchor)) {
                return false;
            }
            return this.angle == t2.angle;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        Tick clone = (Tick)super.clone();
        return clone;
    }

    public String toString() {
        return this.text;
    }
}

