/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import org.jfree.chart.util.ParamChecks;

public class CompassFormat
extends NumberFormat {
    public final String[] directions;

    public CompassFormat() {
        this("N", "E", "S", "W");
    }

    public CompassFormat(String n2, String e2, String s2, String w2) {
        this(new String[]{n2, n2 + n2 + e2, n2 + e2, e2 + n2 + e2, e2, e2 + s2 + e2, s2 + e2, s2 + s2 + e2, s2, s2 + s2 + w2, s2 + w2, w2 + s2 + w2, w2, w2 + n2 + w2, n2 + w2, n2 + n2 + w2});
    }

    public CompassFormat(String[] directions) {
        ParamChecks.nullNotPermitted(directions, "directions");
        if (directions.length != 16) {
            throw new IllegalArgumentException("The 'directions' array must contain exactly 16 elements");
        }
        this.directions = directions;
    }

    public String getDirectionCode(double direction) {
        if ((direction %= 360.0) < 0.0) {
            direction += 360.0;
        }
        int index = ((int)Math.floor(direction / 11.25) + 1) / 2;
        return this.directions[index];
    }

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        return toAppendTo.append(this.getDirectionCode(number));
    }

    @Override
    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        return toAppendTo.append(this.getDirectionCode(number));
    }

    @Override
    public Number parse(String source, ParsePosition parsePosition) {
        return null;
    }
}

