/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.base.modules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jfree.base.modules.Module;
import org.jfree.base.modules.ModuleInfo;
import org.jfree.base.modules.PackageState;
import org.jfree.util.Log;

public final class PackageSorter {
    private PackageSorter() {
    }

    public static void sort(List modules) {
        int i2;
        HashMap<String, SortModule> moduleMap = new HashMap<String, SortModule>();
        ArrayList<PackageState> errorModules = new ArrayList<PackageState>();
        ArrayList<SortModule> weightModules = new ArrayList<SortModule>();
        for (int i3 = 0; i3 < modules.size(); ++i3) {
            PackageState state = (PackageState)modules.get(i3);
            if (state.getState() == -2) {
                errorModules.add(state);
                continue;
            }
            SortModule mod = new SortModule(state);
            weightModules.add(mod);
            moduleMap.put(state.getModule().getModuleClass(), mod);
        }
        Object[] weigths = weightModules.toArray(new SortModule[weightModules.size()]);
        for (int i4 = 0; i4 < weigths.length; ++i4) {
            SortModule sortMod = weigths[i4];
            sortMod.setDependSubsystems(PackageSorter.collectSubsystemModules(sortMod.getState().getModule(), moduleMap));
        }
        boolean doneWork = true;
        while (doneWork) {
            doneWork = false;
            for (int i5 = 0; i5 < weigths.length; ++i5) {
                Object mod = weigths[i5];
                int position = PackageSorter.searchModulePosition((SortModule)mod, moduleMap);
                if (position == ((SortModule)mod).getPosition()) continue;
                ((SortModule)mod).setPosition(position);
                doneWork = true;
            }
        }
        Arrays.sort(weigths);
        modules.clear();
        for (i2 = 0; i2 < weigths.length; ++i2) {
            modules.add(((SortModule)weigths[i2]).getState());
        }
        for (i2 = 0; i2 < errorModules.size(); ++i2) {
            modules.add(errorModules.get(i2));
        }
    }

    private static int searchModulePosition(SortModule smodule, HashMap moduleMap) {
        SortModule reqMod;
        String moduleName;
        int modPos;
        Module module = smodule.getState().getModule();
        int position = 0;
        ModuleInfo[] modInfo = module.getOptionalModules();
        for (modPos = 0; modPos < modInfo.length; ++modPos) {
            moduleName = modInfo[modPos].getModuleClass();
            reqMod = (SortModule)moduleMap.get(moduleName);
            if (reqMod == null || reqMod.getPosition() < position) continue;
            position = reqMod.getPosition() + 1;
        }
        modInfo = module.getRequiredModules();
        for (modPos = 0; modPos < modInfo.length; ++modPos) {
            moduleName = modInfo[modPos].getModuleClass();
            reqMod = (SortModule)moduleMap.get(moduleName);
            if (reqMod == null) {
                Log.warn("Invalid state: Required dependency of '" + moduleName + "' had an error.");
                continue;
            }
            if (reqMod.getPosition() < position) continue;
            position = reqMod.getPosition() + 1;
        }
        String subSystem = module.getSubSystem();
        for (SortModule mod : moduleMap.values()) {
            Module subSysMod;
            if (mod.getState().getModule() == module || subSystem.equals((subSysMod = mod.getState().getModule()).getSubSystem()) || !smodule.getDependSubsystems().contains(subSysMod.getSubSystem()) || PackageSorter.isBaseModule(subSysMod, module) || mod.getPosition() < position) continue;
            position = mod.getPosition() + 1;
        }
        return position;
    }

    private static boolean isBaseModule(Module mod, ModuleInfo mi) {
        int i2;
        ModuleInfo[] info = mod.getRequiredModules();
        for (i2 = 0; i2 < info.length; ++i2) {
            if (!info[i2].getModuleClass().equals(mi.getModuleClass())) continue;
            return true;
        }
        info = mod.getOptionalModules();
        for (i2 = 0; i2 < info.length; ++i2) {
            if (!info[i2].getModuleClass().equals(mi.getModuleClass())) continue;
            return true;
        }
        return false;
    }

    private static ArrayList collectSubsystemModules(Module childMod, HashMap moduleMap) {
        Object dependentModule;
        int i2;
        ArrayList<String> collector = new ArrayList<String>();
        ModuleInfo[] info = childMod.getRequiredModules();
        for (i2 = 0; i2 < info.length; ++i2) {
            dependentModule = (SortModule)moduleMap.get(info[i2].getModuleClass());
            if (dependentModule == null) {
                Log.warn(new Log.SimpleMessage("A dependent module was not found in the list of known modules.", info[i2].getModuleClass()));
                continue;
            }
            collector.add(((SortModule)dependentModule).getState().getModule().getSubSystem());
        }
        info = childMod.getOptionalModules();
        for (i2 = 0; i2 < info.length; ++i2) {
            dependentModule = (Module)moduleMap.get(info[i2].getModuleClass());
            if (dependentModule == null) {
                Log.warn("A dependent module was not found in the list of known modules.");
                continue;
            }
            collector.add(dependentModule.getSubSystem());
        }
        return collector;
    }

    private static class SortModule
    implements Comparable {
        private int position = -1;
        private final PackageState state;
        private ArrayList dependSubsystems;

        public SortModule(PackageState state) {
            this.state = state;
        }

        public ArrayList getDependSubsystems() {
            return this.dependSubsystems;
        }

        public void setDependSubsystems(ArrayList dependSubsystems) {
            this.dependSubsystems = dependSubsystems;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int position) {
            this.position = position;
        }

        public PackageState getState() {
            return this.state;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SortModule: ");
            buffer.append(this.position);
            buffer.append(" ");
            buffer.append(this.state.getModule().getName());
            buffer.append(" ");
            buffer.append(this.state.getModule().getModuleClass());
            return buffer.toString();
        }

        public int compareTo(Object o2) {
            SortModule otherModule = (SortModule)o2;
            if (this.position > otherModule.position) {
                return 1;
            }
            if (this.position < otherModule.position) {
                return -1;
            }
            return 0;
        }
    }
}

