/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.qteslarnd1;

import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.pqc.crypto.qteslarnd1.QTESLASecurityCategory;
import org.bouncycastle.util.Arrays;

public final class QTESLAPrivateKeyParameters
extends AsymmetricKeyParameter {
    private int securityCategory;
    private byte[] privateKey;

    public QTESLAPrivateKeyParameters(int n2, byte[] byArray) {
        super(true);
        if (byArray.length != QTESLASecurityCategory.getPrivateSize(n2)) {
            throw new IllegalArgumentException("invalid key size for security category");
        }
        this.securityCategory = n2;
        this.privateKey = Arrays.clone(byArray);
    }

    public int getSecurityCategory() {
        return this.securityCategory;
    }

    public byte[] getSecret() {
        return Arrays.clone(this.privateKey);
    }
}

