/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.qteslarnd1;

import java.security.SecureRandom;
import org.bouncycastle.pqc.crypto.qteslarnd1.CommonFunction;
import org.bouncycastle.pqc.crypto.qteslarnd1.HashUtils;
import org.bouncycastle.pqc.crypto.qteslarnd1.Pack;
import org.bouncycastle.pqc.crypto.qteslarnd1.Polynomial;
import org.bouncycastle.pqc.crypto.qteslarnd1.PolynomialHeuristic;
import org.bouncycastle.pqc.crypto.qteslarnd1.PolynomialProvablySecure;
import org.bouncycastle.pqc.crypto.qteslarnd1.Sample;

public class QTESLA {
    private static void hashFunction(byte[] byArray, int n2, int[] nArray, byte[] byArray2, int n3, int n4, int n5, int n6) {
        byte[] byArray3 = new byte[n4 + 64];
        for (int i2 = 0; i2 < n4; ++i2) {
            int n7 = n6 / 2 - nArray[i2] >> 31;
            nArray[i2] = nArray[i2] - n6 & n7 | nArray[i2] & ~n7;
            int n8 = nArray[i2] & (1 << n5) - 1;
            n7 = (1 << n5 - 1) - n8 >> 31;
            n8 = n8 - (1 << n5) & n7 | n8 & ~n7;
            byArray3[i2] = (byte)(nArray[i2] - n8 >> n5);
        }
        System.arraycopy(byArray2, n3, byArray3, n4, 64);
        if (n6 == 4205569) {
            HashUtils.secureHashAlgorithmKECCAK128(byArray, n2, 32, byArray3, 0, n4 + 64);
        }
        if (n6 == 4206593 || n6 == 8404993) {
            HashUtils.secureHashAlgorithmKECCAK256(byArray, n2, 32, byArray3, 0, n4 + 64);
        }
    }

    private static void hashFunction(byte[] byArray, int n2, long[] lArray, byte[] byArray2, int n3, int n4, int n5, int n6, int n7) {
        byte[] byArray3 = new byte[n4 * n5 + 64];
        for (int i2 = 0; i2 < n5; ++i2) {
            int n8 = n4 * i2;
            for (int i3 = 0; i3 < n4; ++i3) {
                long l2 = lArray[n8];
                long l3 = (long)(n7 / 2) - l2 >> 63;
                l2 = l2 - (long)n7 & l3 | l2 & (l3 ^ 0xFFFFFFFFFFFFFFFFL);
                long l4 = l2 & (long)((1 << n6) - 1);
                l3 = (long)(1 << n6 - 1) - l4 >> 63;
                l4 = l4 - (long)(1 << n6) & l3 | l4 & (l3 ^ 0xFFFFFFFFFFFFFFFFL);
                byArray3[n8++] = (byte)(l2 - l4 >> n6);
            }
        }
        System.arraycopy(byArray2, n3, byArray3, n4 * n5, 64);
        if (n7 == 485978113) {
            HashUtils.secureHashAlgorithmKECCAK128(byArray, n2, 32, byArray3, 0, n4 * n5 + 64);
        }
        if (n7 == 1129725953) {
            HashUtils.secureHashAlgorithmKECCAK256(byArray, n2, 32, byArray3, 0, n4 * n5 + 64);
        }
    }

    private static int absolute(int n2) {
        return (n2 >> 31 ^ n2) - (n2 >> 31);
    }

    private static long absolute(long l2) {
        return (l2 >> 63 ^ l2) - (l2 >> 63);
    }

    private static boolean testRejection(int[] nArray, int n2, int n3, int n4) {
        for (int i2 = 0; i2 < n2; ++i2) {
            if (QTESLA.absolute(nArray[i2]) <= n3 - n4) continue;
            return true;
        }
        return false;
    }

    private static boolean testRejection(long[] lArray, int n2, int n3, int n4) {
        for (int i2 = 0; i2 < n2; ++i2) {
            if (QTESLA.absolute(lArray[i2]) <= (long)(n3 - n4)) continue;
            return true;
        }
        return false;
    }

    private static boolean testZ(int[] nArray, int n2, int n3, int n4) {
        for (int i2 = 0; i2 < n2; ++i2) {
            if (nArray[i2] >= -(n3 - n4) && nArray[i2] <= n3 - n4) continue;
            return true;
        }
        return false;
    }

    private static boolean testZ(long[] lArray, int n2, int n3, int n4) {
        for (int i2 = 0; i2 < n2; ++i2) {
            if (lArray[i2] >= (long)(-(n3 - n4)) && lArray[i2] <= (long)(n3 - n4)) continue;
            return true;
        }
        return false;
    }

    private static boolean testV(int[] nArray, int n2, int n3, int n4, int n5) {
        for (int i2 = 0; i2 < n2; ++i2) {
            int n6 = n4 / 2 - nArray[i2] >> 31;
            int n7 = nArray[i2] - n4 & n6 | nArray[i2] & ~n6;
            int n8 = ~(QTESLA.absolute(n7) - (n4 / 2 - n5)) >>> 31;
            int n9 = n7;
            n7 = n7 + (1 << n3 - 1) - 1 >> n3;
            int n10 = ~(QTESLA.absolute(n7 = n9 - (n7 << n3)) - ((1 << n3 - 1) - n5)) >>> 31;
            if ((n8 | n10) != 1) continue;
            return true;
        }
        return false;
    }

    private static boolean testV(long[] lArray, int n2, int n3, int n4, int n5, int n6) {
        for (int i2 = 0; i2 < n3; ++i2) {
            long l2 = (long)(n5 / 2) - lArray[n2 + i2] >> 63;
            long l3 = lArray[n2 + i2] - (long)n5 & l2 | lArray[n2 + i2] & (l2 ^ 0xFFFFFFFFFFFFFFFFL);
            long l4 = (QTESLA.absolute(l3) - (long)(n5 / 2 - n6) ^ 0xFFFFFFFFFFFFFFFFL) >>> 63;
            long l5 = l3;
            l3 = (int)(l3 + (long)(1 << n4 - 1) - 1L >> n4);
            long l6 = (QTESLA.absolute(l3 = l5 - (l3 << n4)) - (long)((1 << n4 - 1) - n6) ^ 0xFFFFFFFFFFFFFFFFL) >>> 63;
            if ((l4 | l6) != 1L) continue;
            return true;
        }
        return false;
    }

    private static boolean checkPolynomial(int[] nArray, int n2, int n3, int n4) {
        int n5;
        int n6 = 0;
        int n7 = n3;
        int[] nArray2 = new int[n3];
        for (n5 = 0; n5 < n3; ++n5) {
            nArray2[n5] = QTESLA.absolute(nArray[n5]);
        }
        for (n5 = 0; n5 < n4; ++n5) {
            for (int i2 = 0; i2 < n7 - 1; ++i2) {
                int n8 = nArray2[i2 + 1] - nArray2[i2] >> 31;
                int n9 = nArray2[i2 + 1] & n8 | nArray2[i2] & ~n8;
                nArray2[i2 + 1] = nArray2[i2] & n8 | nArray2[i2 + 1] & ~n8;
                nArray2[i2] = n9;
            }
            n6 += nArray2[n7 - 1];
            --n7;
        }
        return n6 > n2;
    }

    private static boolean checkPolynomial(long[] lArray, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = 0;
        int n8 = n4;
        short[] sArray = new short[n4];
        for (n6 = 0; n6 < n4; ++n6) {
            sArray[n6] = (short)QTESLA.absolute(lArray[n2 + n6]);
        }
        for (n6 = 0; n6 < n5; ++n6) {
            for (int i2 = 0; i2 < n8 - 1; ++i2) {
                short s2 = (short)(sArray[i2 + 1] - sArray[i2] >> 15);
                short s3 = (short)(sArray[i2 + 1] & s2 | sArray[i2] & ~s2);
                sArray[i2 + 1] = (short)(sArray[i2] & s2 | sArray[i2 + 1] & ~s2);
                sArray[i2] = s3;
            }
            n7 += sArray[n8 - 1];
            --n8;
        }
        return n7 > n3;
    }

    private static int generateKeyPair(byte[] byArray, byte[] byArray2, SecureRandom secureRandom, int n2, int n3, int n4, long l2, int n5, int n6, int n7, double d2, int[] nArray, int n8, int n9) {
        int n10 = 0;
        byte[] byArray3 = new byte[32];
        byte[] byArray4 = new byte[128];
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        int[] nArray4 = new int[n2];
        int[] nArray5 = new int[n2];
        secureRandom.nextBytes(byArray3);
        if (n4 == 4205569) {
            HashUtils.secureHashAlgorithmKECCAK128(byArray4, 0, 128, byArray3, 0, 32);
        }
        if (n4 == 4206593 || n4 == 8404993) {
            HashUtils.secureHashAlgorithmKECCAK256(byArray4, 0, 128, byArray3, 0, 32);
        }
        do {
            if (n4 == 4205569) {
                Sample.polynomialGaussSamplerI(nArray3, 0, byArray4, 0, ++n10);
            }
            if (n4 == 4206593) {
                Sample.polynomialGaussSamplerIII(nArray3, 0, byArray4, 0, ++n10, n2, d2, Sample.EXPONENTIAL_DISTRIBUTION_III_SIZE);
            }
            if (n4 != 8404993) continue;
            Sample.polynomialGaussSamplerIII(nArray3, 0, byArray4, 0, ++n10, n2, d2, Sample.EXPONENTIAL_DISTRIBUTION_III_SPEED);
        } while (QTESLA.checkPolynomial(nArray3, n8, n2, n3));
        do {
            if (n4 == 4205569) {
                Sample.polynomialGaussSamplerI(nArray2, 0, byArray4, 32, ++n10);
            }
            if (n4 == 4206593) {
                Sample.polynomialGaussSamplerIII(nArray2, 0, byArray4, 32, ++n10, n2, d2, Sample.EXPONENTIAL_DISTRIBUTION_III_SIZE);
            }
            if (n4 != 8404993) continue;
            Sample.polynomialGaussSamplerIII(nArray2, 0, byArray4, 32, ++n10, n2, d2, Sample.EXPONENTIAL_DISTRIBUTION_III_SPEED);
        } while (QTESLA.checkPolynomial(nArray2, n9, n2, n3));
        Polynomial.polynomialUniform(nArray4, byArray4, 64, n2, n4, l2, n5, n6, n7);
        Polynomial.polynomialMultiplication(nArray5, nArray4, nArray2, n2, n4, l2, nArray);
        Polynomial.polynomialAdditionCorrection(nArray5, nArray5, nArray3, n2, n4);
        if (n4 == 4205569) {
            Pack.encodePrivateKeyI(byArray2, nArray2, nArray3, byArray4, 64);
            Pack.encodePublicKey(byArray, nArray5, byArray4, 64, 512, 23);
        }
        if (n4 == 4206593) {
            Pack.encodePrivateKeyIIISize(byArray2, nArray2, nArray3, byArray4, 64);
            Pack.encodePublicKey(byArray, nArray5, byArray4, 64, 1024, 23);
        }
        if (n4 == 8404993) {
            Pack.encodePrivateKeyIIISpeed(byArray2, nArray2, nArray3, byArray4, 64);
            Pack.encodePublicKeyIIISpeed(byArray, nArray5, byArray4, 64);
        }
        return 0;
    }

    public static int generateKeyPairI(byte[] byArray, byte[] byArray2, SecureRandom secureRandom) {
        return QTESLA.generateKeyPair(byArray, byArray2, secureRandom, 512, 30, 4205569, 3098553343L, 23, 19, 113307, 27.0, PolynomialHeuristic.ZETA_I, 1586, 1586);
    }

    public static int generateKeyPairIIISize(byte[] byArray, byte[] byArray2, SecureRandom secureRandom) {
        return QTESLA.generateKeyPair(byArray, byArray2, secureRandom, 1024, 48, 4206593, 4148178943L, 23, 38, 1217638, 9.0, PolynomialHeuristic.ZETA_III_SIZE, 910, 910);
    }

    public static int generateKeyPairIIISpeed(byte[] byArray, byte[] byArray2, SecureRandom secureRandom) {
        return QTESLA.generateKeyPair(byArray, byArray2, secureRandom, 1024, 48, 8404993, 4034936831L, 24, 38, 237839, 12.0, PolynomialHeuristic.ZETA_III_SPEED, 1147, 1233);
    }

    private static int generateKeyPair(byte[] byArray, byte[] byArray2, SecureRandom secureRandom, int n2, int n3, int n4, int n5, long l2, int n6, int n7, int n8, double d2, long[] lArray, int n9, int n10) {
        int n11;
        int n12 = 0;
        byte[] byArray3 = new byte[32];
        byte[] byArray4 = new byte[32 * (n3 + 3)];
        long[] lArray2 = new long[n2];
        long[] lArray3 = new long[n2];
        long[] lArray4 = new long[n2 * n3];
        long[] lArray5 = new long[n2 * n3];
        long[] lArray6 = new long[n2 * n3];
        secureRandom.nextBytes(byArray3);
        if (n5 == 485978113) {
            HashUtils.secureHashAlgorithmKECCAK128(byArray4, 0, 32 * (n3 + 3), byArray3, 0, 32);
        }
        if (n5 == 1129725953) {
            HashUtils.secureHashAlgorithmKECCAK256(byArray4, 0, 32 * (n3 + 3), byArray3, 0, 32);
        }
        for (n11 = 0; n11 < n3; ++n11) {
            do {
                if (n5 == 485978113) {
                    Sample.polynomialGaussSamplerIP(lArray4, n2 * n11, byArray4, 32 * n11, ++n12);
                }
                if (n5 != 1129725953) continue;
                Sample.polynomialGaussSamplerIIIP(lArray4, n2 * n11, byArray4, 32 * n11, ++n12);
            } while (QTESLA.checkPolynomial(lArray4, n2 * n11, n9, n2, n4));
        }
        do {
            if (n5 == 485978113) {
                Sample.polynomialGaussSamplerIP(lArray2, 0, byArray4, 32 * n3, ++n12);
            }
            if (n5 != 1129725953) continue;
            Sample.polynomialGaussSamplerIIIP(lArray2, 0, byArray4, 32 * n3, ++n12);
        } while (QTESLA.checkPolynomial(lArray2, 0, n10, n2, n4));
        Polynomial.polynomialUniform(lArray5, byArray4, 32 * (n3 + 1), n2, n3, n5, l2, n6, n7, n8);
        Polynomial.polynomialNumberTheoreticTransform(lArray3, lArray2, n2);
        for (n11 = 0; n11 < n3; ++n11) {
            Polynomial.polynomialMultiplication(lArray6, n2 * n11, lArray5, n2 * n11, lArray3, 0, n2, n5, l2);
            Polynomial.polynomialAddition(lArray6, n2 * n11, lArray6, n2 * n11, lArray4, n2 * n11, n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                long l3 = (long)n5 - lArray6[n2 * n11 + i2] >> 63;
                int n13 = n2 * n11 + i2;
                lArray6[n13] = lArray6[n13] - ((long)n5 & l3);
            }
        }
        Pack.packPrivateKey(byArray2, lArray2, lArray4, byArray4, 32 * (n3 + 1), n2, n3);
        if (n5 == 485978113) {
            Pack.encodePublicKeyIP(byArray, lArray6, byArray4, 32 * (n3 + 1));
        }
        if (n5 == 1129725953) {
            Pack.encodePublicKeyIIIP(byArray, lArray6, byArray4, 32 * (n3 + 1));
        }
        return 0;
    }

    public static int generateKeyPairIP(byte[] byArray, byte[] byArray2, SecureRandom secureRandom) {
        return QTESLA.generateKeyPair(byArray, byArray2, secureRandom, 1024, 4, 25, 485978113, 3421990911L, 29, 108, 472064468, 10.0, PolynomialProvablySecure.ZETA_I_P, 554, 554);
    }

    public static int generateKeyPairIIIP(byte[] byArray, byte[] byArray2, SecureRandom secureRandom) {
        return QTESLA.generateKeyPair(byArray, byArray2, secureRandom, 2048, 5, 40, 1129725953, 861290495L, 31, 180, 851423148, 10.0, PolynomialProvablySecure.ZETA_III_P, 901, 901);
    }

    private static int signing(byte[] byArray, byte[] byArray2, int n2, int n3, byte[] byArray3, SecureRandom secureRandom, int n4, int n5, int n6, long l2, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int[] nArray) {
        byte[] byArray4 = new byte[32];
        byte[] byArray5 = new byte[32];
        byte[] byArray6 = new byte[128];
        byte[] byArray7 = new byte[64];
        byte[] byArray8 = new byte[32];
        int[] nArray2 = new int[n5];
        short[] sArray = new short[n5];
        short[] sArray2 = new short[n4];
        short[] sArray3 = new short[n4];
        int[] nArray3 = new int[n4];
        int[] nArray4 = new int[n4];
        int[] nArray5 = new int[n4];
        int[] nArray6 = new int[n4];
        int[] nArray7 = new int[n4];
        int[] nArray8 = new int[n4];
        int n17 = 0;
        if (n6 == 4205569) {
            Pack.decodePrivateKeyI(byArray7, sArray2, sArray3, byArray3);
        }
        if (n6 == 4206593) {
            Pack.decodePrivateKeyIIISize(byArray7, sArray2, sArray3, byArray3);
        }
        if (n6 == 8404993) {
            Pack.decodePrivateKeyIIISpeed(byArray7, sArray2, sArray3, byArray3);
        }
        secureRandom.nextBytes(byArray8);
        System.arraycopy(byArray8, 0, byArray6, 32, 32);
        System.arraycopy(byArray7, 32, byArray6, 0, 32);
        if (n6 == 4205569) {
            HashUtils.secureHashAlgorithmKECCAK128(byArray6, 64, 64, byArray2, 0, n3);
            HashUtils.secureHashAlgorithmKECCAK128(byArray5, 0, 32, byArray6, 0, 128);
        }
        if (n6 == 4206593 || n6 == 8404993) {
            HashUtils.secureHashAlgorithmKECCAK256(byArray6, 64, 64, byArray2, 0, n3);
            HashUtils.secureHashAlgorithmKECCAK256(byArray5, 0, 32, byArray6, 0, 128);
        }
        Polynomial.polynomialUniform(nArray3, byArray7, 0, n4, n6, l2, n7, n13, n14);
        while (true) {
            Sample.sampleY(nArray5, byArray5, 0, ++n17, n4, n6, n8, n9);
            Polynomial.polynomialMultiplication(nArray4, nArray3, nArray5, n4, n6, l2, nArray);
            QTESLA.hashFunction(byArray4, 0, nArray4, byArray6, 64, n4, n10, n6);
            Sample.encodeC(nArray2, sArray, byArray4, 0, n4, n5);
            Polynomial.sparsePolynomialMultiplication16(nArray7, sArray2, nArray2, sArray, n4, n5);
            Polynomial.polynomialAddition(nArray6, nArray5, nArray7, n4);
            if (QTESLA.testRejection(nArray6, n4, n8, n11)) continue;
            Polynomial.sparsePolynomialMultiplication16(nArray8, sArray3, nArray2, sArray, n4, n5);
            Polynomial.polynomialSubtractionCorrection(nArray4, nArray4, nArray8, n4, n6);
            if (!QTESLA.testV(nArray4, n4, n10, n6, n12)) break;
        }
        if (n6 == 4205569) {
            Pack.encodeSignature(byArray, 0, byArray4, 0, nArray6, n4, n10);
        }
        if (n6 == 4206593) {
            Pack.encodeSignature(byArray, 0, byArray4, 0, nArray6, n4, n10);
        }
        if (n6 == 8404993) {
            Pack.encodeSignatureIIISpeed(byArray, 0, byArray4, 0, nArray6);
        }
        return 0;
    }

    static int signingI(byte[] byArray, byte[] byArray2, int n2, int n3, byte[] byArray3, SecureRandom secureRandom) {
        return QTESLA.signing(byArray, byArray2, n2, n3, byArray3, secureRandom, 512, 30, 4205569, 3098553343L, 23, 1048575, 20, 21, 1586, 1586, 19, 113307, 1021, 32, PolynomialHeuristic.ZETA_I);
    }

    static int signingIIISize(byte[] byArray, byte[] byArray2, int n2, int n3, byte[] byArray3, SecureRandom secureRandom) {
        return QTESLA.signing(byArray, byArray2, n2, n3, byArray3, secureRandom, 1024, 48, 4206593, 4148178943L, 23, 1048575, 20, 21, 910, 910, 38, 1217638, 1021, 32, PolynomialHeuristic.ZETA_III_SIZE);
    }

    static int signingIIISpeed(byte[] byArray, byte[] byArray2, int n2, int n3, byte[] byArray3, SecureRandom secureRandom) {
        return QTESLA.signing(byArray, byArray2, n2, n3, byArray3, secureRandom, 1024, 48, 8404993, 4034936831L, 24, 0x1FFFFF, 21, 22, 1233, 1147, 38, 237839, 511, 32, PolynomialHeuristic.ZETA_III_SPEED);
    }

    private static int signing(byte[] byArray, byte[] byArray2, int n2, int n3, byte[] byArray3, SecureRandom secureRandom, int n4, int n5, int n6, int n7, long l2, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17, int n18) {
        byte[] byArray4 = new byte[32];
        byte[] byArray5 = new byte[32];
        byte[] byArray6 = new byte[128];
        byte[] byArray7 = new byte[32];
        int[] nArray = new int[n6];
        short[] sArray = new short[n6];
        long[] lArray = new long[n4 * n5];
        long[] lArray2 = new long[n4 * n5];
        long[] lArray3 = new long[n4];
        long[] lArray4 = new long[n4];
        long[] lArray5 = new long[n4];
        long[] lArray6 = new long[n4];
        long[] lArray7 = new long[n4 * n5];
        boolean bl = false;
        int n19 = 0;
        secureRandom.nextBytes(byArray7);
        System.arraycopy(byArray7, 0, byArray6, 32, 32);
        System.arraycopy(byArray3, n16 - 32, byArray6, 0, 32);
        if (n7 == 485978113) {
            HashUtils.secureHashAlgorithmKECCAK128(byArray6, 64, 64, byArray2, 0, n3);
            HashUtils.secureHashAlgorithmKECCAK128(byArray5, 0, 32, byArray6, 0, 128);
        }
        if (n7 == 1129725953) {
            HashUtils.secureHashAlgorithmKECCAK256(byArray6, 64, 64, byArray2, 0, n3);
            HashUtils.secureHashAlgorithmKECCAK256(byArray5, 0, 32, byArray6, 0, 128);
        }
        Polynomial.polynomialUniform(lArray, byArray3, n16 - 64, n4, n5, n7, l2, n8, n14, n15);
        while (true) {
            int n20;
            Sample.sampleY(lArray3, byArray5, 0, ++n19, n4, n7, n9, n10);
            Polynomial.polynomialNumberTheoreticTransform(lArray4, lArray3, n4);
            for (n20 = 0; n20 < n5; ++n20) {
                Polynomial.polynomialMultiplication(lArray2, n4 * n20, lArray, n4 * n20, lArray4, 0, n4, n7, l2);
            }
            QTESLA.hashFunction(byArray4, 0, lArray2, byArray6, 64, n4, n5, n11, n7);
            Sample.encodeC(nArray, sArray, byArray4, 0, n4, n6);
            Polynomial.sparsePolynomialMultiplication8(lArray6, 0, byArray3, 0, nArray, sArray, n4, n6);
            Polynomial.polynomialAddition(lArray5, 0, lArray3, 0, lArray6, 0, n4);
            if (QTESLA.testRejection(lArray5, n4, n9, n12)) continue;
            for (n20 = 0; n20 < n5; ++n20) {
                Polynomial.sparsePolynomialMultiplication8(lArray7, n4 * n20, byArray3, n4 * (n20 + 1), nArray, sArray, n4, n6);
                Polynomial.polynomialSubtraction(lArray2, n4 * n20, lArray2, n4 * n20, lArray7, n4 * n20, n4, n7, n17, n18);
                bl = QTESLA.testV(lArray2, n4 * n20, n4, n11, n7, n13);
                if (bl) break;
            }
            if (!bl) break;
        }
        if (n7 == 485978113) {
            Pack.encodeSignatureIP(byArray, 0, byArray4, 0, lArray5);
        }
        if (n7 == 1129725953) {
            Pack.encodeSignatureIIIP(byArray, 0, byArray4, 0, lArray5);
        }
        return 0;
    }

    public static int signingIP(byte[] byArray, byte[] byArray2, int n2, int n3, byte[] byArray3, SecureRandom secureRandom) {
        return QTESLA.signing(byArray, byArray2, n2, n3, byArray3, secureRandom, 1024, 4, 25, 485978113, 3421990911L, 29, 0x1FFFFF, 21, 22, 554, 554, 108, 472064468, 5184, 1, 29);
    }

    public static int signingIIIP(byte[] byArray, byte[] byArray2, int n2, int n3, byte[] byArray3, SecureRandom secureRandom) {
        return QTESLA.signing(byArray, byArray2, n2, n3, byArray3, secureRandom, 2048, 5, 40, 1129725953, 861290495L, 31, 0x7FFFFF, 23, 24, 901, 901, 180, 851423148, 12352, 15, 34);
    }

    private static int verifying(byte[] byArray, byte[] byArray2, int n2, int n3, byte[] byArray3, int n4, int n5, int n6, long l2, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int[] nArray) {
        byte[] byArray4 = new byte[32];
        byte[] byArray5 = new byte[32];
        byte[] byArray6 = new byte[32];
        byte[] byArray7 = new byte[64];
        int[] nArray2 = new int[n4];
        int[] nArray3 = new int[n5];
        short[] sArray = new short[n5];
        int[] nArray4 = new int[n4];
        int[] nArray5 = new int[n4];
        int[] nArray6 = new int[n4];
        int[] nArray7 = new int[n4];
        if (n3 < n12) {
            return -1;
        }
        if (n6 == 4205569 || n6 == 4206593) {
            Pack.decodeSignature(byArray4, nArray5, byArray2, n2, n4, n9);
        }
        if (n6 == 8404993) {
            Pack.decodeSignatureIIISpeed(byArray4, nArray5, byArray2, n2);
        }
        if (QTESLA.testZ(nArray5, n4, n8, n10)) {
            return -2;
        }
        if (n6 == 4205569 || n6 == 4206593) {
            Pack.decodePublicKey(nArray2, byArray6, 0, byArray3, n4, n7);
        }
        if (n6 == 8404993) {
            Pack.decodePublicKeyIIISpeed(nArray2, byArray6, 0, byArray3);
        }
        Polynomial.polynomialUniform(nArray7, byArray6, 0, n4, n6, l2, n7, n13, n14);
        Sample.encodeC(nArray3, sArray, byArray4, 0, n4, n5);
        Polynomial.sparsePolynomialMultiplication32(nArray6, nArray2, nArray3, sArray, n4, n5);
        Polynomial.polynomialMultiplication(nArray4, nArray7, nArray5, n4, n6, l2, nArray);
        Polynomial.polynomialSubtractionMontgomery(nArray4, nArray4, nArray6, n4, n6, l2, n11);
        if (n6 == 4205569) {
            HashUtils.secureHashAlgorithmKECCAK128(byArray7, 0, 64, byArray, 0, byArray.length);
        }
        if (n6 == 4206593 || n6 == 8404993) {
            HashUtils.secureHashAlgorithmKECCAK256(byArray7, 0, 64, byArray, 0, byArray.length);
        }
        QTESLA.hashFunction(byArray5, 0, nArray4, byArray7, 0, n4, n9, n6);
        if (!CommonFunction.memoryEqual(byArray4, 0, byArray5, 0, 32)) {
            return -3;
        }
        return 0;
    }

    static int verifyingI(byte[] byArray, byte[] byArray2, int n2, int n3, byte[] byArray3) {
        return QTESLA.verifying(byArray, byArray2, n2, n3, byArray3, 512, 30, 4205569, 3098553343L, 23, 1048575, 21, 1586, 1081347, 1376, 19, 113307, 1021, 32, PolynomialHeuristic.ZETA_I);
    }

    static int verifyingIIISize(byte[] byArray, byte[] byArray2, int n2, int n3, byte[] byArray3) {
        return QTESLA.verifying(byArray, byArray2, n2, n3, byArray3, 1024, 48, 4206593, 4148178943L, 23, 1048575, 21, 910, 35843, 2720, 38, 1217638, 1021, 32, PolynomialHeuristic.ZETA_III_SIZE);
    }

    static int verifyingIIISpeed(byte[] byArray, byte[] byArray2, int n2, int n3, byte[] byArray3) {
        return QTESLA.verifying(byArray, byArray2, n2, n3, byArray3, 1024, 48, 8404993, 4034936831L, 24, 0x1FFFFF, 22, 1233, 15873, 2848, 38, 237839, 511, 32, PolynomialHeuristic.ZETA_III_SPEED);
    }

    private static int verifying(byte[] byArray, byte[] byArray2, int n2, int n3, byte[] byArray3, int n4, int n5, int n6, int n7, long l2, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, long[] lArray) {
        byte[] byArray4 = new byte[32];
        byte[] byArray5 = new byte[32];
        byte[] byArray6 = new byte[32];
        byte[] byArray7 = new byte[64];
        int[] nArray = new int[n4 * n5];
        int[] nArray2 = new int[n6];
        short[] sArray = new short[n6];
        long[] lArray2 = new long[n4 * n5];
        long[] lArray3 = new long[n4];
        long[] lArray4 = new long[n4];
        long[] lArray5 = new long[n4 * n5];
        long[] lArray6 = new long[n4 * n5];
        if (n3 < n12) {
            return -1;
        }
        if (n7 == 485978113) {
            Pack.decodeSignatureIP(byArray4, lArray3, byArray2, n2);
        }
        if (n7 == 1129725953) {
            Pack.decodeSignatureIIIP(byArray4, lArray3, byArray2, n2);
        }
        if (QTESLA.testZ(lArray3, n4, n9, n11)) {
            return -2;
        }
        if (n7 == 485978113) {
            Pack.decodePublicKeyIP(nArray, byArray6, 0, byArray3);
        }
        if (n7 == 1129725953) {
            Pack.decodePublicKeyIIIP(nArray, byArray6, 0, byArray3);
        }
        Polynomial.polynomialUniform(lArray6, byArray6, 0, n4, n5, n7, l2, n8, n13, n14);
        Sample.encodeC(nArray2, sArray, byArray4, 0, n4, n6);
        Polynomial.polynomialNumberTheoreticTransform(lArray4, lArray3, n4);
        for (int i2 = 0; i2 < n5; ++i2) {
            Polynomial.polynomialMultiplication(lArray2, n4 * i2, lArray6, n4 * i2, lArray4, 0, n4, n7, l2);
            Polynomial.sparsePolynomialMultiplication32(lArray5, n4 * i2, nArray, n4 * i2, nArray2, sArray, n4, n6, n7, n15, n16);
            Polynomial.polynomialSubtraction(lArray2, n4 * i2, lArray2, n4 * i2, lArray5, n4 * i2, n4, n7, n15, n16);
        }
        if (n7 == 485978113) {
            HashUtils.secureHashAlgorithmKECCAK128(byArray7, 0, 64, byArray, 0, byArray.length);
        }
        if (n7 == 1129725953) {
            HashUtils.secureHashAlgorithmKECCAK256(byArray7, 0, 64, byArray, 0, byArray.length);
        }
        QTESLA.hashFunction(byArray5, 0, lArray2, byArray7, 0, n4, n5, n10, n7);
        if (!CommonFunction.memoryEqual(byArray4, 0, byArray5, 0, 32)) {
            return -3;
        }
        return 0;
    }

    static int verifyingPI(byte[] byArray, byte[] byArray2, int n2, int n3, byte[] byArray3) {
        return QTESLA.verifying(byArray, byArray2, n2, n3, byArray3, 1024, 4, 25, 485978113, 3421990911L, 29, 0x1FFFFF, 22, 554, 2848, 108, 472064468, 1, 29, PolynomialProvablySecure.ZETA_I_P);
    }

    static int verifyingPIII(byte[] byArray, byte[] byArray2, int n2, int n3, byte[] byArray3) {
        return QTESLA.verifying(byArray, byArray2, n2, n3, byArray3, 2048, 5, 40, 1129725953, 861290495L, 31, 0x7FFFFF, 24, 901, 6176, 180, 851423148, 15, 34, PolynomialProvablySecure.ZETA_III_P);
    }
}

