/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.IOException;
import org.bouncycastle.crypto.tls.AbstractTlsClient;
import org.bouncycastle.crypto.tls.DefaultTlsCipherFactory;
import org.bouncycastle.crypto.tls.DefaultTlsDHVerifier;
import org.bouncycastle.crypto.tls.TlsCipherFactory;
import org.bouncycastle.crypto.tls.TlsDHEKeyExchange;
import org.bouncycastle.crypto.tls.TlsDHKeyExchange;
import org.bouncycastle.crypto.tls.TlsDHVerifier;
import org.bouncycastle.crypto.tls.TlsECDHEKeyExchange;
import org.bouncycastle.crypto.tls.TlsECDHKeyExchange;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsKeyExchange;
import org.bouncycastle.crypto.tls.TlsRSAKeyExchange;
import org.bouncycastle.crypto.tls.TlsUtils;

public abstract class DefaultTlsClient
extends AbstractTlsClient {
    protected TlsDHVerifier dhVerifier;

    public DefaultTlsClient() {
        this(new DefaultTlsCipherFactory());
    }

    public DefaultTlsClient(TlsCipherFactory tlsCipherFactory) {
        this(tlsCipherFactory, new DefaultTlsDHVerifier());
    }

    public DefaultTlsClient(TlsCipherFactory tlsCipherFactory, TlsDHVerifier tlsDHVerifier) {
        super(tlsCipherFactory);
        this.dhVerifier = tlsDHVerifier;
    }

    public int[] getCipherSuites() {
        return new int[]{49195, 49187, 49161, 49199, 49191, 49171, 156, 60, 47};
    }

    public TlsKeyExchange getKeyExchange() throws IOException {
        int n2 = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (n2) {
            case 7: 
            case 9: 
            case 11: {
                return this.createDHKeyExchange(n2);
            }
            case 3: 
            case 5: {
                return this.createDHEKeyExchange(n2);
            }
            case 16: 
            case 18: 
            case 20: {
                return this.createECDHKeyExchange(n2);
            }
            case 17: 
            case 19: {
                return this.createECDHEKeyExchange(n2);
            }
            case 1: {
                return this.createRSAKeyExchange();
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createDHKeyExchange(int n2) {
        return new TlsDHKeyExchange(n2, this.supportedSignatureAlgorithms, this.dhVerifier, null);
    }

    protected TlsKeyExchange createDHEKeyExchange(int n2) {
        return new TlsDHEKeyExchange(n2, this.supportedSignatureAlgorithms, this.dhVerifier, null);
    }

    protected TlsKeyExchange createECDHKeyExchange(int n2) {
        return new TlsECDHKeyExchange(n2, this.supportedSignatureAlgorithms, this.namedCurves, this.clientECPointFormats, this.serverECPointFormats);
    }

    protected TlsKeyExchange createECDHEKeyExchange(int n2) {
        return new TlsECDHEKeyExchange(n2, this.supportedSignatureAlgorithms, this.namedCurves, this.clientECPointFormats, this.serverECPointFormats);
    }

    protected TlsKeyExchange createRSAKeyExchange() {
        return new TlsRSAKeyExchange(this.supportedSignatureAlgorithms);
    }
}

