/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.measurement;

import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.interactive.measurement.PDMeasureDictionary;
import org.apache.pdfbox.pdmodel.interactive.measurement.PDNumberFormatDictionary;

public class PDRectlinearMeasureDictionary
extends PDMeasureDictionary {
    public static final String SUBTYPE = "RL";

    public PDRectlinearMeasureDictionary() {
        this.setSubtype(SUBTYPE);
    }

    public PDRectlinearMeasureDictionary(COSDictionary dictionary) {
        super(dictionary);
    }

    public String getScaleRatio() {
        return this.getCOSObject().getString(COSName.R);
    }

    public void setScaleRatio(String scaleRatio) {
        this.getCOSObject().setString(COSName.R, scaleRatio);
    }

    public PDNumberFormatDictionary[] getChangeXs() {
        COSArray x2 = (COSArray)this.getCOSObject().getDictionaryObject("X");
        if (x2 != null) {
            PDNumberFormatDictionary[] retval = new PDNumberFormatDictionary[x2.size()];
            for (int i2 = 0; i2 < x2.size(); ++i2) {
                COSDictionary dic = (COSDictionary)x2.get(i2);
                retval[i2] = new PDNumberFormatDictionary(dic);
            }
            return retval;
        }
        return null;
    }

    public void setChangeXs(PDNumberFormatDictionary[] changeXs) {
        COSArray array = new COSArray();
        for (PDNumberFormatDictionary changeX : changeXs) {
            array.add(changeX);
        }
        this.getCOSObject().setItem("X", (COSBase)array);
    }

    public PDNumberFormatDictionary[] getChangeYs() {
        COSArray y2 = (COSArray)this.getCOSObject().getDictionaryObject("Y");
        if (y2 != null) {
            PDNumberFormatDictionary[] retval = new PDNumberFormatDictionary[y2.size()];
            for (int i2 = 0; i2 < y2.size(); ++i2) {
                COSDictionary dic = (COSDictionary)y2.get(i2);
                retval[i2] = new PDNumberFormatDictionary(dic);
            }
            return retval;
        }
        return null;
    }

    public void setChangeYs(PDNumberFormatDictionary[] changeYs) {
        COSArray array = new COSArray();
        for (PDNumberFormatDictionary changeY : changeYs) {
            array.add(changeY);
        }
        this.getCOSObject().setItem("Y", (COSBase)array);
    }

    public PDNumberFormatDictionary[] getDistances() {
        COSArray d2 = (COSArray)this.getCOSObject().getDictionaryObject("D");
        if (d2 != null) {
            PDNumberFormatDictionary[] retval = new PDNumberFormatDictionary[d2.size()];
            for (int i2 = 0; i2 < d2.size(); ++i2) {
                COSDictionary dic = (COSDictionary)d2.get(i2);
                retval[i2] = new PDNumberFormatDictionary(dic);
            }
            return retval;
        }
        return null;
    }

    public void setDistances(PDNumberFormatDictionary[] distances) {
        COSArray array = new COSArray();
        for (PDNumberFormatDictionary distance : distances) {
            array.add(distance);
        }
        this.getCOSObject().setItem("D", (COSBase)array);
    }

    public PDNumberFormatDictionary[] getAreas() {
        COSArray a2 = (COSArray)this.getCOSObject().getDictionaryObject(COSName.A);
        if (a2 != null) {
            PDNumberFormatDictionary[] retval = new PDNumberFormatDictionary[a2.size()];
            for (int i2 = 0; i2 < a2.size(); ++i2) {
                COSDictionary dic = (COSDictionary)a2.get(i2);
                retval[i2] = new PDNumberFormatDictionary(dic);
            }
            return retval;
        }
        return null;
    }

    public void setAreas(PDNumberFormatDictionary[] areas) {
        COSArray array = new COSArray();
        for (PDNumberFormatDictionary area : areas) {
            array.add(area);
        }
        this.getCOSObject().setItem(COSName.A, (COSBase)array);
    }

    public PDNumberFormatDictionary[] getAngles() {
        COSArray t2 = (COSArray)this.getCOSObject().getDictionaryObject("T");
        if (t2 != null) {
            PDNumberFormatDictionary[] retval = new PDNumberFormatDictionary[t2.size()];
            for (int i2 = 0; i2 < t2.size(); ++i2) {
                COSDictionary dic = (COSDictionary)t2.get(i2);
                retval[i2] = new PDNumberFormatDictionary(dic);
            }
            return retval;
        }
        return null;
    }

    public void setAngles(PDNumberFormatDictionary[] angles) {
        COSArray array = new COSArray();
        for (PDNumberFormatDictionary angle : angles) {
            array.add(angle);
        }
        this.getCOSObject().setItem("T", (COSBase)array);
    }

    public PDNumberFormatDictionary[] getLineSloaps() {
        COSArray s2 = (COSArray)this.getCOSObject().getDictionaryObject("S");
        if (s2 != null) {
            PDNumberFormatDictionary[] retval = new PDNumberFormatDictionary[s2.size()];
            for (int i2 = 0; i2 < s2.size(); ++i2) {
                COSDictionary dic = (COSDictionary)s2.get(i2);
                retval[i2] = new PDNumberFormatDictionary(dic);
            }
            return retval;
        }
        return null;
    }

    public void setLineSloaps(PDNumberFormatDictionary[] lineSloaps) {
        COSArray array = new COSArray();
        for (PDNumberFormatDictionary lineSloap : lineSloaps) {
            array.add(lineSloap);
        }
        this.getCOSObject().setItem("S", (COSBase)array);
    }

    public float[] getCoordSystemOrigin() {
        COSArray o2 = (COSArray)this.getCOSObject().getDictionaryObject("O");
        if (o2 != null) {
            return o2.toFloatArray();
        }
        return null;
    }

    public void setCoordSystemOrigin(float[] coordSystemOrigin) {
        COSArray array = new COSArray();
        array.setFloatArray(coordSystemOrigin);
        this.getCOSObject().setItem("O", (COSBase)array);
    }

    public float getCYX() {
        return this.getCOSObject().getFloat("CYX");
    }

    public void setCYX(float cyx) {
        this.getCOSObject().setFloat("CYX", cyx);
    }
}

