/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.annotation.handlers;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDAppearanceContentStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationMarkup;
import org.apache.pdfbox.pdmodel.interactive.annotation.handlers.AnnotationBorder;
import org.apache.pdfbox.pdmodel.interactive.annotation.handlers.PDAbstractAppearanceHandler;

public class PDInkAppearanceHandler
extends PDAbstractAppearanceHandler {
    private static final Log LOG = LogFactory.getLog(PDInkAppearanceHandler.class);

    public PDInkAppearanceHandler(PDAnnotation annotation) {
        super(annotation);
    }

    public PDInkAppearanceHandler(PDAnnotation annotation, PDDocument document) {
        super(annotation, document);
    }

    @Override
    public void generateAppearanceStreams() {
        this.generateNormalAppearance();
        this.generateRolloverAppearance();
        this.generateDownAppearance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateNormalAppearance() {
        PDAnnotationMarkup ink = (PDAnnotationMarkup)this.getAnnotation();
        PDColor color = ink.getColor();
        if (color == null || color.getComponents().length == 0) {
            return;
        }
        AnnotationBorder ab2 = AnnotationBorder.getAnnotationBorder(ink, ink.getBorderStyle());
        if (Float.compare(ab2.width, 0.0f) == 0) {
            return;
        }
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float maxX = Float.MIN_VALUE;
        float maxY = Float.MIN_VALUE;
        for (float[] pathArray : ink.getInkList()) {
            int nPoints = pathArray.length / 2;
            for (int i2 = 0; i2 < nPoints; ++i2) {
                float x2 = pathArray[i2 * 2];
                float y2 = pathArray[i2 * 2 + 1];
                minX = Math.min(minX, x2);
                minY = Math.min(minY, y2);
                maxX = Math.max(maxX, x2);
                maxY = Math.max(maxY, y2);
            }
        }
        PDRectangle rect = ink.getRectangle();
        rect.setLowerLeftX(Math.min(minX - ab2.width * 2.0f, rect.getLowerLeftX()));
        rect.setLowerLeftY(Math.min(minY - ab2.width * 2.0f, rect.getLowerLeftY()));
        rect.setUpperRightX(Math.max(maxX + ab2.width * 2.0f, rect.getUpperRightX()));
        rect.setUpperRightY(Math.max(maxY + ab2.width * 2.0f, rect.getUpperRightY()));
        ink.setRectangle(rect);
        PDAppearanceContentStream cs = null;
        try {
            cs = this.getNormalAppearanceAsContentStream();
            this.setOpacity(cs, ink.getConstantOpacity());
            cs.setStrokingColor(color);
            if (ab2.dashArray != null) {
                cs.setLineDashPattern(ab2.dashArray, 0.0f);
            }
            cs.setLineWidth(ab2.width);
            for (float[] pathArray : ink.getInkList()) {
                int nPoints = pathArray.length / 2;
                for (int i3 = 0; i3 < nPoints; ++i3) {
                    float x3 = pathArray[i3 * 2];
                    float y3 = pathArray[i3 * 2 + 1];
                    if (i3 == 0) {
                        cs.moveTo(x3, y3);
                        continue;
                    }
                    cs.lineTo(x3, y3);
                }
                cs.stroke();
            }
        }
        catch (IOException ex) {
            LOG.error(ex);
        }
        finally {
            IOUtils.closeQuietly(cs);
        }
    }

    @Override
    public void generateRolloverAppearance() {
    }

    @Override
    public void generateDownAppearance() {
    }
}

