/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.common.function;

import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.PDRange;
import org.apache.pdfbox.pdmodel.common.function.PDFunction;

public class PDFunctionType3
extends PDFunction {
    private COSArray functions = null;
    private COSArray encode = null;
    private COSArray bounds = null;
    private PDFunction[] functionsArray = null;
    private float[] boundsValues = null;

    public PDFunctionType3(COSBase functionStream) {
        super(functionStream);
    }

    @Override
    public int getFunctionType() {
        return 3;
    }

    @Override
    public float[] eval(float[] input) throws IOException {
        PDFunction function = null;
        float x2 = input[0];
        PDRange domain = this.getDomainForInput(0);
        x2 = this.clipToRange(x2, domain.getMin(), domain.getMax());
        if (this.functionsArray == null) {
            COSArray ar = this.getFunctions();
            this.functionsArray = new PDFunction[ar.size()];
            for (int i2 = 0; i2 < ar.size(); ++i2) {
                this.functionsArray[i2] = PDFunction.create(ar.getObject(i2));
            }
        }
        if (this.functionsArray.length == 1) {
            function = this.functionsArray[0];
            PDRange encRange = this.getEncodeForParameter(0);
            x2 = this.interpolate(x2, domain.getMin(), domain.getMax(), encRange.getMin(), encRange.getMax());
        } else {
            if (this.boundsValues == null) {
                this.boundsValues = this.getBounds().toFloatArray();
            }
            int boundsSize = this.boundsValues.length;
            float[] partitionValues = new float[boundsSize + 2];
            int partitionValuesSize = partitionValues.length;
            partitionValues[0] = domain.getMin();
            partitionValues[partitionValuesSize - 1] = domain.getMax();
            System.arraycopy(this.boundsValues, 0, partitionValues, 1, boundsSize);
            for (int i3 = 0; i3 < partitionValuesSize - 1; ++i3) {
                if (!(x2 >= partitionValues[i3]) || !(x2 < partitionValues[i3 + 1]) && (i3 != partitionValuesSize - 2 || x2 != partitionValues[i3 + 1])) continue;
                function = this.functionsArray[i3];
                PDRange encRange = this.getEncodeForParameter(i3);
                x2 = this.interpolate(x2, partitionValues[i3], partitionValues[i3 + 1], encRange.getMin(), encRange.getMax());
                break;
            }
            if (function == null) {
                throw new IOException("partition not found in type 3 function");
            }
        }
        float[] functionValues = new float[]{x2};
        float[] functionResult = function.eval(functionValues);
        return this.clipToRange(functionResult);
    }

    public COSArray getFunctions() {
        if (this.functions == null) {
            this.functions = (COSArray)this.getCOSObject().getDictionaryObject(COSName.FUNCTIONS);
        }
        return this.functions;
    }

    public COSArray getBounds() {
        if (this.bounds == null) {
            this.bounds = (COSArray)this.getCOSObject().getDictionaryObject(COSName.BOUNDS);
        }
        return this.bounds;
    }

    public COSArray getEncode() {
        if (this.encode == null) {
            this.encode = (COSArray)this.getCOSObject().getDictionaryObject(COSName.ENCODE);
        }
        return this.encode;
    }

    private PDRange getEncodeForParameter(int n2) {
        COSArray encodeValues = this.getEncode();
        return new PDRange(encodeValues, n2);
    }
}

