/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfwriter;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdfwriter.COSWriter;
import org.apache.pdfbox.util.Charsets;

public class ContentStreamWriter {
    private final OutputStream output;
    public static final byte[] SPACE = new byte[]{32};
    public static final byte[] EOL = new byte[]{10};

    public ContentStreamWriter(OutputStream out) {
        this.output = out;
    }

    public void writeToken(COSBase base) throws IOException {
        this.writeObject(base);
    }

    public void writeToken(Operator op) throws IOException {
        this.writeObject(op);
    }

    public void writeTokens(Object ... tokens) throws IOException {
        for (Object token : tokens) {
            this.writeObject(token);
        }
        this.output.write("\n".getBytes(Charsets.US_ASCII));
    }

    public void writeTokens(List<?> tokens) throws IOException {
        for (Object token : tokens) {
            this.writeObject(token);
        }
    }

    private void writeObject(Object o2) throws IOException {
        if (o2 instanceof COSString) {
            COSWriter.writeString((COSString)o2, this.output);
            this.output.write(SPACE);
        } else if (o2 instanceof COSFloat) {
            ((COSFloat)o2).writePDF(this.output);
            this.output.write(SPACE);
        } else if (o2 instanceof COSInteger) {
            ((COSInteger)o2).writePDF(this.output);
            this.output.write(SPACE);
        } else if (o2 instanceof COSBoolean) {
            ((COSBoolean)o2).writePDF(this.output);
            this.output.write(SPACE);
        } else if (o2 instanceof COSName) {
            ((COSName)o2).writePDF(this.output);
            this.output.write(SPACE);
        } else if (o2 instanceof COSArray) {
            COSArray array = (COSArray)o2;
            this.output.write(COSWriter.ARRAY_OPEN);
            for (int i2 = 0; i2 < array.size(); ++i2) {
                this.writeObject(array.get(i2));
            }
            this.output.write(COSWriter.ARRAY_CLOSE);
            this.output.write(SPACE);
        } else if (o2 instanceof COSDictionary) {
            COSDictionary obj = (COSDictionary)o2;
            this.output.write(COSWriter.DICT_OPEN);
            for (Map.Entry<COSName, COSBase> entry : obj.entrySet()) {
                if (entry.getValue() == null) continue;
                this.writeObject(entry.getKey());
                this.writeObject(entry.getValue());
            }
            this.output.write(COSWriter.DICT_CLOSE);
            this.output.write(SPACE);
        } else if (o2 instanceof Operator) {
            Operator op = (Operator)o2;
            if (op.getName().equals("BI")) {
                this.output.write("BI".getBytes(Charsets.ISO_8859_1));
                this.output.write(EOL);
                COSDictionary dic = op.getImageParameters();
                for (COSName key : dic.keySet()) {
                    COSBase value = dic.getDictionaryObject(key);
                    key.writePDF(this.output);
                    this.output.write(SPACE);
                    this.writeObject(value);
                    this.output.write(EOL);
                }
                this.output.write("ID".getBytes(Charsets.ISO_8859_1));
                this.output.write(EOL);
                this.output.write(op.getImageData());
                this.output.write(EOL);
                this.output.write("EI".getBytes(Charsets.ISO_8859_1));
                this.output.write(EOL);
            } else {
                this.output.write(op.getName().getBytes(Charsets.ISO_8859_1));
                this.output.write(EOL);
            }
        } else if (o2 instanceof COSNull) {
            this.output.write("null".getBytes(Charsets.ISO_8859_1));
            this.output.write(SPACE);
        } else {
            throw new IOException("Error:Unknown type in content stream:" + o2);
        }
    }
}

