/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.jbig2.util.cache;

import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.pdfbox.jbig2.util.cache.Cache;

public class SoftReferenceCache
implements Cache {
    private final Map<Object, SoftReference<?>> cache = Collections.synchronizedMap(new WeakHashMap());

    @Override
    public Object put(Object object, Object object2, int n2) {
        SoftReference<Object> softReference = new SoftReference<Object>(object2);
        SoftReference<Object> softReference2 = this.cache.put(object, softReference);
        return this.getValueNullSafe(softReference2);
    }

    @Override
    public Object get(Object object) {
        SoftReference<?> softReference = this.cache.get(object);
        return this.getValueNullSafe(softReference);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public Object remove(Object object) {
        SoftReference<?> softReference = this.cache.remove(object);
        return this.getValueNullSafe(softReference);
    }

    private Object getValueNullSafe(SoftReference<?> softReference) {
        return softReference == null ? null : softReference.get();
    }
}

