/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.jbig2.segments;

import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.pdfbox.jbig2.Bitmap;
import org.apache.pdfbox.jbig2.Dictionary;
import org.apache.pdfbox.jbig2.SegmentHeader;
import org.apache.pdfbox.jbig2.err.InvalidHeaderValueException;
import org.apache.pdfbox.jbig2.image.Bitmaps;
import org.apache.pdfbox.jbig2.io.SubInputStream;
import org.apache.pdfbox.jbig2.segments.GenericRegion;
import org.apache.pdfbox.jbig2.util.log.Logger;
import org.apache.pdfbox.jbig2.util.log.LoggerFactory;

public class PatternDictionary
implements Dictionary {
    private final Logger log = LoggerFactory.getLogger(PatternDictionary.class);
    private SubInputStream subInputStream;
    private long dataHeaderOffset;
    private long dataHeaderLength;
    private long dataOffset;
    private long dataLength;
    private short[] gbAtX = null;
    private short[] gbAtY = null;
    private boolean isMMREncoded;
    private byte hdTemplate;
    private short hdpWidth;
    private short hdpHeight;
    private ArrayList<Bitmap> patterns;
    private int grayMax;

    private void parseHeader() throws IOException, InvalidHeaderValueException {
        this.subInputStream.readBits(5);
        this.readTemplate();
        this.readIsMMREncoded();
        this.readPatternWidthAndHeight();
        this.readGrayMax();
        this.computeSegmentDataStructure();
        this.checkInput();
    }

    private void readTemplate() throws IOException {
        this.hdTemplate = (byte)this.subInputStream.readBits(2);
    }

    private void readIsMMREncoded() throws IOException {
        if (this.subInputStream.readBit() == 1) {
            this.isMMREncoded = true;
        }
    }

    private void readPatternWidthAndHeight() throws IOException {
        this.hdpWidth = this.subInputStream.readByte();
        this.hdpHeight = this.subInputStream.readByte();
    }

    private void readGrayMax() throws IOException {
        this.grayMax = (int)(this.subInputStream.readBits(32) & 0xFFFFFFFFFFFFFFFFL);
    }

    private void computeSegmentDataStructure() throws IOException {
        this.dataOffset = this.subInputStream.getStreamPosition();
        this.dataHeaderLength = this.dataOffset - this.dataHeaderOffset;
        this.dataLength = this.subInputStream.length() - this.dataHeaderLength;
    }

    private void checkInput() throws InvalidHeaderValueException {
        if (this.hdpHeight < 1 || this.hdpWidth < 1) {
            throw new InvalidHeaderValueException("Width/Heigth must be greater than zero.");
        }
        if (this.isMMREncoded && this.hdTemplate != 0) {
            this.log.info("hdTemplate should contain the value 0");
        }
    }

    @Override
    public ArrayList<Bitmap> getDictionary() throws IOException, InvalidHeaderValueException {
        if (null == this.patterns) {
            if (!this.isMMREncoded) {
                this.setGbAtPixels();
            }
            GenericRegion genericRegion = new GenericRegion(this.subInputStream);
            genericRegion.setParameters(this.isMMREncoded, this.dataOffset, this.dataLength, this.hdpHeight, (this.grayMax + 1) * this.hdpWidth, this.hdTemplate, false, false, this.gbAtX, this.gbAtY);
            Bitmap bitmap = genericRegion.getRegionBitmap();
            this.extractPatterns(bitmap);
        }
        return this.patterns;
    }

    private void extractPatterns(Bitmap bitmap) {
        this.patterns = new ArrayList(this.grayMax + 1);
        for (int i2 = 0; i2 <= this.grayMax; ++i2) {
            Rectangle rectangle = new Rectangle(this.hdpWidth * i2, 0, this.hdpWidth, this.hdpHeight);
            Bitmap bitmap2 = Bitmaps.extract(rectangle, bitmap);
            this.patterns.add(bitmap2);
        }
    }

    private void setGbAtPixels() {
        if (this.hdTemplate == 0) {
            this.gbAtX = new short[4];
            this.gbAtY = new short[4];
            this.gbAtX[0] = -this.hdpWidth;
            this.gbAtY[0] = 0;
            this.gbAtX[1] = -3;
            this.gbAtY[1] = -1;
            this.gbAtX[2] = 2;
            this.gbAtY[2] = -2;
            this.gbAtX[3] = -2;
            this.gbAtY[3] = -2;
        } else {
            this.gbAtX = new short[1];
            this.gbAtY = new short[1];
            this.gbAtX[0] = -this.hdpWidth;
            this.gbAtY[0] = 0;
        }
    }

    @Override
    public void init(SegmentHeader segmentHeader, SubInputStream subInputStream) throws InvalidHeaderValueException, IOException {
        this.subInputStream = subInputStream;
        this.parseHeader();
    }

    protected boolean isMMREncoded() {
        return this.isMMREncoded;
    }

    protected byte getHdTemplate() {
        return this.hdTemplate;
    }

    protected short getHdpWidth() {
        return this.hdpWidth;
    }

    protected short getHdpHeight() {
        return this.hdpHeight;
    }

    protected int getGrayMax() {
        return this.grayMax;
    }
}

