/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.jbig2.segments;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.pdfbox.jbig2.Bitmap;
import org.apache.pdfbox.jbig2.Region;
import org.apache.pdfbox.jbig2.SegmentHeader;
import org.apache.pdfbox.jbig2.err.InvalidHeaderValueException;
import org.apache.pdfbox.jbig2.image.Bitmaps;
import org.apache.pdfbox.jbig2.io.SubInputStream;
import org.apache.pdfbox.jbig2.segments.GenericRegion;
import org.apache.pdfbox.jbig2.segments.PatternDictionary;
import org.apache.pdfbox.jbig2.segments.RegionSegmentInformation;
import org.apache.pdfbox.jbig2.util.CombinationOperator;
import org.apache.pdfbox.jbig2.util.log.Logger;
import org.apache.pdfbox.jbig2.util.log.LoggerFactory;

public class HalftoneRegion
implements Region {
    private final Logger log = LoggerFactory.getLogger(HalftoneRegion.class);
    private SubInputStream subInputStream;
    private SegmentHeader segmentHeader;
    private long dataHeaderOffset;
    private long dataHeaderLength;
    private long dataOffset;
    private long dataLength;
    private RegionSegmentInformation regionInfo;
    private byte hDefaultPixel;
    private CombinationOperator hCombinationOperator;
    private boolean hSkipEnabled;
    private byte hTemplate;
    private boolean isMMREncoded;
    private int hGridWidth;
    private int hGridHeight;
    private int hGridX;
    private int hGridY;
    private int hRegionX;
    private int hRegionY;
    private Bitmap halftoneRegionBitmap;
    private ArrayList<Bitmap> patterns;

    public HalftoneRegion() {
    }

    public HalftoneRegion(SubInputStream subInputStream) {
        this.subInputStream = subInputStream;
        this.regionInfo = new RegionSegmentInformation(subInputStream);
    }

    public HalftoneRegion(SubInputStream subInputStream, SegmentHeader segmentHeader) {
        this.subInputStream = subInputStream;
        this.segmentHeader = segmentHeader;
        this.regionInfo = new RegionSegmentInformation(subInputStream);
    }

    private void parseHeader() throws IOException, InvalidHeaderValueException {
        this.regionInfo.parseHeader();
        this.hDefaultPixel = (byte)this.subInputStream.readBit();
        this.hCombinationOperator = CombinationOperator.translateOperatorCodeToEnum((short)(this.subInputStream.readBits(3) & 0xFL));
        if (this.subInputStream.readBit() == 1) {
            this.hSkipEnabled = true;
        }
        this.hTemplate = (byte)(this.subInputStream.readBits(2) & 0xFL);
        if (this.subInputStream.readBit() == 1) {
            this.isMMREncoded = true;
        }
        this.hGridWidth = (int)(this.subInputStream.readBits(32) & 0xFFFFFFFFFFFFFFFFL);
        this.hGridHeight = (int)(this.subInputStream.readBits(32) & 0xFFFFFFFFFFFFFFFFL);
        this.hGridX = (int)this.subInputStream.readBits(32);
        this.hGridY = (int)this.subInputStream.readBits(32);
        this.hRegionX = (int)this.subInputStream.readBits(16) & 0xFFFF;
        this.hRegionY = (int)this.subInputStream.readBits(16) & 0xFFFF;
        this.computeSegmentDataStructure();
        this.checkInput();
    }

    private void computeSegmentDataStructure() throws IOException {
        this.dataOffset = this.subInputStream.getStreamPosition();
        this.dataHeaderLength = this.dataOffset - this.dataHeaderOffset;
        this.dataLength = this.subInputStream.length() - this.dataHeaderLength;
    }

    private void checkInput() throws InvalidHeaderValueException {
        if (this.isMMREncoded) {
            if (this.hTemplate != 0) {
                this.log.info("hTemplate = " + this.hTemplate + " (should contain the value 0)");
            }
            if (this.hSkipEnabled) {
                this.log.info("hSkipEnabled 0 " + this.hSkipEnabled + " (should contain the value false)");
            }
        }
    }

    @Override
    public Bitmap getRegionBitmap() throws IOException, InvalidHeaderValueException {
        if (null == this.halftoneRegionBitmap) {
            this.halftoneRegionBitmap = new Bitmap(this.regionInfo.getBitmapWidth(), this.regionInfo.getBitmapHeight());
            if (this.patterns == null) {
                this.patterns = this.getPatterns();
            }
            if (this.hDefaultPixel == 1) {
                Arrays.fill(this.halftoneRegionBitmap.getByteArray(), (byte)-1);
            }
            int n2 = (int)Math.ceil(Math.log(this.patterns.size()) / Math.log(2.0));
            int[][] nArray = this.grayScaleDecoding(n2);
            this.renderPattern(nArray);
        }
        return this.halftoneRegionBitmap;
    }

    private void renderPattern(int[][] nArray) {
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < this.hGridHeight; ++i2) {
            for (int i3 = 0; i3 < this.hGridWidth; ++i3) {
                n2 = this.computeX(i2, i3);
                n3 = this.computeY(i2, i3);
                Bitmap bitmap = this.patterns.get(nArray[i2][i3]);
                Bitmaps.blit(bitmap, this.halftoneRegionBitmap, n2 + this.hGridX, n3 + this.hGridY, this.hCombinationOperator);
            }
        }
    }

    private ArrayList<Bitmap> getPatterns() throws InvalidHeaderValueException, IOException {
        ArrayList<Bitmap> arrayList = new ArrayList<Bitmap>();
        for (SegmentHeader segmentHeader : this.segmentHeader.getRtSegments()) {
            PatternDictionary patternDictionary = (PatternDictionary)segmentHeader.getSegmentData();
            arrayList.addAll(patternDictionary.getDictionary());
        }
        return arrayList;
    }

    private int[][] grayScaleDecoding(int n2) throws IOException {
        short[] sArray = null;
        short[] sArray2 = null;
        if (!this.isMMREncoded) {
            sArray = new short[4];
            sArray2 = new short[4];
            if (this.hTemplate <= 1) {
                sArray[0] = 3;
            } else if (this.hTemplate >= 2) {
                sArray[0] = 2;
            }
            sArray2[0] = -1;
            sArray[1] = -3;
            sArray2[1] = -1;
            sArray[2] = 2;
            sArray2[2] = -2;
            sArray[3] = -2;
            sArray2[3] = -2;
        }
        Bitmap[] bitmapArray = new Bitmap[n2];
        GenericRegion genericRegion = new GenericRegion(this.subInputStream);
        genericRegion.setParameters(this.isMMREncoded, this.dataOffset, this.dataLength, this.hGridHeight, this.hGridWidth, this.hTemplate, false, this.hSkipEnabled, sArray, sArray2);
        int n3 = n2 - 1;
        bitmapArray[n3] = genericRegion.getRegionBitmap();
        while (n3 > 0) {
            genericRegion.resetBitmap();
            bitmapArray[--n3] = genericRegion.getRegionBitmap();
            bitmapArray = this.combineGrayScalePlanes(bitmapArray, n3);
        }
        return this.computeGrayScaleValues(bitmapArray, n2);
    }

    private Bitmap[] combineGrayScalePlanes(Bitmap[] bitmapArray, int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < bitmapArray[n2].getHeight(); ++i2) {
            for (int i3 = 0; i3 < bitmapArray[n2].getWidth(); i3 += 8) {
                byte by = bitmapArray[n2 + 1].getByte(n3);
                byte by2 = bitmapArray[n2].getByte(n3);
                bitmapArray[n2].setByte(n3++, Bitmaps.combineBytes(by2, by, CombinationOperator.XOR));
            }
        }
        return bitmapArray;
    }

    private int[][] computeGrayScaleValues(Bitmap[] bitmapArray, int n2) {
        int[][] nArray = new int[this.hGridHeight][this.hGridWidth];
        for (int i2 = 0; i2 < this.hGridHeight; ++i2) {
            for (int i3 = 0; i3 < this.hGridWidth; i3 += 8) {
                int n3 = this.hGridWidth - i3 > 8 ? 8 : this.hGridWidth - i3;
                int n4 = bitmapArray[0].getByteIndex(i3, i2);
                for (int i4 = 0; i4 < n3; ++i4) {
                    int n5 = i4 + i3;
                    nArray[i2][n5] = 0;
                    for (int i5 = 0; i5 < n2; ++i5) {
                        int[] nArray2 = nArray[i2];
                        int n6 = n5;
                        nArray2[n6] = nArray2[n6] + (bitmapArray[i5].getByte(n4) >> (7 - n5 & 7) & 1) * (1 << i5);
                    }
                }
            }
        }
        return nArray;
    }

    private int computeX(int n2, int n3) {
        return this.shiftAndFill(this.hGridX + n2 * this.hRegionY + n3 * this.hRegionX);
    }

    private int computeY(int n2, int n3) {
        return this.shiftAndFill(this.hGridY + n2 * this.hRegionX - n3 * this.hRegionY);
    }

    private int shiftAndFill(int n2) {
        if ((n2 >>= 8) < 0) {
            int n3 = (int)(Math.log(Integer.highestOneBit(n2)) / Math.log(2.0));
            for (int i2 = 1; i2 < 31 - n3; ++i2) {
                n2 |= 1 << 31 - i2;
            }
        }
        return n2;
    }

    @Override
    public void init(SegmentHeader segmentHeader, SubInputStream subInputStream) throws InvalidHeaderValueException, IOException {
        this.segmentHeader = segmentHeader;
        this.subInputStream = subInputStream;
        this.regionInfo = new RegionSegmentInformation(this.subInputStream);
        this.parseHeader();
    }

    public CombinationOperator getCombinationOperator() {
        return this.hCombinationOperator;
    }

    @Override
    public RegionSegmentInformation getRegionInfo() {
        return this.regionInfo;
    }

    protected byte getHTemplate() {
        return this.hTemplate;
    }

    protected boolean isHSkipEnabled() {
        return this.hSkipEnabled;
    }

    protected boolean isMMREncoded() {
        return this.isMMREncoded;
    }

    protected int getHGridWidth() {
        return this.hGridWidth;
    }

    protected int getHGridHeight() {
        return this.hGridHeight;
    }

    protected int getHGridX() {
        return this.hGridX;
    }

    protected int getHGridY() {
        return this.hGridY;
    }

    protected int getHRegionX() {
        return this.hRegionX;
    }

    protected int getHRegionY() {
        return this.hRegionY;
    }

    protected byte getHDefaultPixel() {
        return this.hDefaultPixel;
    }
}

